/*************************************************************************************************/
/*!
   	@file		Math.h
	@author 	Fanzo
 	@date 		2008/4/10
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	solution linear
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int SolutionLinear
		(
		float			a , 
		float			b , 
		float			solution[]
		)
{
	int	num	= 0;
	if( a == 0.0f )
		return num;
	solution[ num ] = -b / 2.0f / a;
	num++;
	return num;
}
//=================================================================================================
//!	solution quadratic
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int SolutionQuadratic
		(
		float			a , 
		float			b , 
		float			c , 
		float			solution[]
		)
{
	int	num	= 0;
	if( a == 0.0f )
	{
		return SolutionLinear( b , c , solution );
	}
	float	r = b * b - 4.0f * a * c;
	if( r == 0.0f )
	{
		solution[ num ] = -b / 2.0f / a;
		num++;
		return num;
	}
	r = sqrt( r );
	solution[ num ] = ( -b + r ) / 2.0f / a;
	num++;
	solution[ num ] = ( -b - r ) / 2.0f / a;
	num++;
	return num;
}
};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
