/*************************************************************************************************/
/*!
   	@file		Misc.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iFileStream.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne
#ifdef cb_windows
#	define com_release( p ) {if(p){p->Release();p=NULL;}}
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

#ifdef cb_windows
//=================================================================================================
cb_inline
bool IsValidHandle
		(
		HANDLE	handle
		)
{
	if( handle == NULL || handle == INVALID_HANDLE_VALUE )
		return false;
    return true;
}
//=================================================================================================
cb_inline
void SafeCloseHandle
		(
		HANDLE&		handle
		)
{
	if( true == IsValidHandle( handle ) )
		CloseHandle( handle );
	handle	= NULL;
}

#endif

//=================================================================================================
cb_inline
bool Save
		(
		IStreamWrite*	stream , 
		const guid&		clsid
		)
{
	if( false == stream->Write( &clsid , 1 , sizeof( clsid ) , Little_EndianType ) )
		return false;
	return true;
}
//=================================================================================================
cb_inline
bool Load
		(
		IStreamRead*	stream , 
		guid*			clsid
		)
{
	if( false == stream->Read( clsid , 1 , sizeof( guid ) , Little_EndianType ) )
		return false;
	return true;
}
//=================================================================================================
cb_inline
bool SaveString
		(
		IStreamWrite*	file , 
		const wstring&	str
		)
{
	long	len	= str.length();
	if( false == file->Write( &len , sizeof(len) , 1 , Little_EndianType ) )
		return false;
	if( false == file->Write( str.c_str() , sizeof(wchar_t) , len , Little_EndianType ) )
		return false;
	return true;
}
//=================================================================================================
cb_inline
bool LoadString
		(
		IStreamRead*	file , 
		wstring*		str
		)
{
	long	len;
	if( false == file->Read( &len , sizeof(len) , 1 , Little_EndianType ) )
		return false;
	wchar_t*	p = new wchar_t[len+1];
	if( false == file->Read( p , sizeof(wchar_t) , len , Little_EndianType ) )
	{
		delete []p;
		return false;
	}
	p[len]	= L'\0';
	*str	= p;
	delete []p;
	return true;
}

#ifdef cb_windows
//=================================================================================================
cb_inline
bool Save_utf16
		(
		IStreamWrite*	stream , 
		const wstring&	str
		)
{
	uint32	len = str.length();
	if( false == stream->Write( &len , sizeof( len ) , 1 , Little_EndianType ) )
		return false;
	if( false == stream->Write( str.c_str() , sizeof(wchar_t) , len , Little_EndianType ) )
		return false;
	return true;
}
//=================================================================================================
cb_inline
bool Load_utf16
		(
		IStreamRead*	stream , 
		wstring*		str
		)
{
	uint32	len;
	if( false == stream->Read( &len , sizeof( len ) , 1 , Little_EndianType ) )
		return false;
	wchar_t*	buf = new wchar_t[ len + 1 ];
	if( false == stream->Read( buf , sizeof(wchar_t) , len , Little_EndianType ) )
	{
		delete []buf;
		return false;
	}
	buf[len]	= L'\0';
	*str	= buf;
	delete []buf;
	return true;
}
#endif

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
