/*************************************************************************************************/
/*!
   	@file		CapCfgView.h
	@author 	Fanzo
 	@date 		2008/5/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"
#include	"RadioGroupView.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"CapCfgView" class 
**************************************************************************************************/
class CapCfgView : public RadioGroupView
{
// variable member
private:
	instance<CapFlat>	m_flat;	
	instance<CapRound>	m_round;	
	instance<CapArrow>	m_arrow;	

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
CapCfgView()
{
	SetRadioNum( 3 );
	SetString( 0 , L"flat" );
	SetString( 1 , L"round" );
	SetString( 2 , L"arraw" );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iCap GetValue()
{
	int		s = GetSelect();
	if( s == 0 )
	{
		return ( iCap )m_flat;
	}
	else if( s == 1 )
	{
		return ( iCap )m_round;
	}
	else
	{
		return ( iCap )m_arrow;
	}
}
};
/**************************************************************************************************
"CapCfgView_gp" class 
**************************************************************************************************/
class CapCfgView_gp : public RadioGroupView
{
// variable member
private:
	int						m_cap_id;
	iCap					m_cap;

// private functions
private:
//=================================================================================================
void UpdateCap()
{
	int		s = GetSelect();
	if( m_cap == false || m_cap_id != s )
	{
		m_cap_id	= s;
		if( s == 0 )
			m_cap	= CreateCap( Flat_CapType_gp );
		else if( s == 1 )
			m_cap	= CreateCap( Roung_CapType_gp );
		else
			m_cap	= CreateCapArrow();
	}
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
CapCfgView_gp() : m_cap_id( 0 )
{
	SetRadioNum( 3 );
	SetString( 0 , L"flat" );
	SetString( 1 , L"round" );
	SetString( 2 , L"arraw" );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iCap GetValue()
{
	UpdateCap();
	return m_cap;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace CapCfgView;		

#pragma pack( pop )			//release align
