/*************************************************************************************************/
/*!
   	@file		EdittypeCfgView.h
	@author 	Fanzo
 	@date 		2008/5/27
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"
#include	"RadioGroupView.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum Edittype
{
	Multi_Edittype , 
	Line_Edittype , 
	Arc_Edittype , 
	BezierQ_Edittype , 
	BezierC_Edittype , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"EdittypeCfgView" class 
**************************************************************************************************/
class EdittypeCfgView : public RadioGroupView
{
// variable member
private:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
EdittypeCfgView()
{
	SetRadioNum( 5 );
	SetString( 0 , L"multi" );
	SetString( 1 , L"line" );
	SetString( 2 , L"arc" );
	SetString( 3 , L"bezierQ" );
	SetString( 4 , L"bezierC" );
	SetSelect( 0 );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
Edittype GetValue()
{
	int		s = GetSelect();
	if( s == 0 )
		return Multi_Edittype;
	else if( s == 1 )
		return Line_Edittype;
	else if( s == 2 )
		return Arc_Edittype;
	else if( s == 3 )
		return BezierQ_Edittype;
	else
		return BezierC_Edittype;
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace EdittypeCfgView;		

#pragma pack( pop )			//release align
