/*************************************************************************************************/
/*!
   	@file		Window.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		msg_win_map_begin()									\
protected:														\
virtual															\
LRESULT WndProc													\
		(														\
		HWND	hwnd,											\
		UINT	msg,											\
		WPARAM	wparam,											\
		LPARAM	lparam , 										\
		bool	*def											\
		)														\
{																\

#define		msg_win_hook( msg_type , callfunc )					\
	if( msg == msg_type )										\
	{															\
		callfunc( wparam , lparam );							\
		*def = false;											\
	}

#define		msg_win_cmd_hook( ctrlid , ctrlmsg , callfunc )								\
	if( msg == WM_COMMAND && ctrlid == LOWORD(wparam) && ctrlmsg == HIWORD(wparam) )	\
	{																					\
		callfunc();																		\
		*def = false;																	\
	}

#define		msg_win_map_end()									\
	return 0;													\
}

#define		msg_dlg_map_begin()									\
protected:														\
virtual															\
bool DlgProc													\
		(														\
		HWND	hwnd,											\
		UINT	msg,											\
		WPARAM	wparam,											\
		LPARAM	lparam	 										\
		)														\
{																\
	bool	hook = false;
	
#define		msg_dlg_hook( msg_type , callfunc )					\
	if( msg == msg_type )										\
	{															\
		callfunc( wparam , lparam );							\
		hook = true;											\
	}

#define		msg_dlg_cmd_hook( ctrlid , ctrlmsg , callfunc )								\
	if( msg == WM_COMMAND && ctrlid == LOWORD(wparam) && ctrlmsg == HIWORD(wparam) )	\
	{																					\
		callfunc();																		\
		hook = true;																	\
	}

#define		msg_dlg_map_end()									\
	return hook;												\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"MainWindow" class 
**************************************************************************************************/
class Window : 
	virtual public object_base
{

// variable member
protected:
	HINSTANCE						m_hinst;
	HWND							m_hwnd;
	
// private functions
private:
//=================================================================================================
static
LRESULT CALLBACK WndProcStatic
		(
		HWND	hwnd, 
		UINT	msg, 
		WPARAM	wparam, 
		LPARAM	lparam
		)
{
	if( msg == WM_CREATE )
	{
		SetWindowLongPtr( hwnd , GWLP_USERDATA , ( LONG_PTR )( ( ( LPCREATESTRUCT )lparam )->lpCreateParams ) );
		Window	*pwin = ( Window* )GetWindowLongPtr( hwnd , GWLP_USERDATA );
		pwin->m_hwnd	= hwnd;
	}
	bool		def = true;
	LRESULT		result;
	Window	*pwin = ( Window* )GetWindowLongPtr( hwnd , GWLP_USERDATA );
	if( pwin != 0 )
		result	= pwin->WndProc( hwnd , msg , wparam , lparam , &def );
	if( def == false )
		return result;
	return DefWindowProc( hwnd, msg, wparam, lparam);
}
//=================================================================================================
ATOM RegisterClass
		(
		HINSTANCE		hinst , 
		const wchar_t*	class_name
		)
{
	WNDCLASSEX	wcex;
	wcex.cbSize			= sizeof(WNDCLASSEX);
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProcStatic;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hinst;
	wcex.hIcon			= NULL;
	wcex.hCursor		= LoadCursor( NULL, IDC_ARROW );
	wcex.hbrBackground	= (HBRUSH)GetStockObject( WHITE_BRUSH );
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= class_name;
	wcex.hIconSm		= NULL;
	return RegisterClassEx( &wcex );
}
// protected functions
protected:
//=================================================================================================
virtual
LRESULT WndProc
		(
		HWND	hwnd,
		UINT	msg,
		WPARAM	wparam,
		LPARAM	lparam ,
		bool	*def
		)
{
	return 0;
}
// public functions
public:
//=================================================================================================
Window() : m_hwnd( NULL ) , m_hinst( NULL )
{
}
//=================================================================================================
bool Create
		(
		HINSTANCE		hinst , 
		const wchar_t*	title , 
		const irect&	rect , 
		const wchar_t*	menu
		)
{
	m_hinst	= hinst;
	RegisterClass( hinst , L"BA5D8630-FC3A-43be-99ED-2B31D24D91F0" );
	m_hwnd = CreateWindow
			(
			L"BA5D8630-FC3A-43be-99ED-2B31D24D91F0", 
			title , 
			WS_OVERLAPPEDWINDOW ,
			rect.xmin , rect.ymin , rect.xmax - rect.xmin , rect.ymax - rect.ymin , 
			NULL, 
			NULL, 
			NULL , 
			this
			);
	if ( m_hwnd == NULL )
		return false;

	// menu
	if( menu != 0 )
		SetMenu( m_hwnd , LoadMenu( hinst , menu ) );

	::ShowWindow( m_hwnd , SW_SHOW );
	::UpdateWindow( m_hwnd );
	MSG		msg;
	while ( GetMessage( &msg , NULL , 0, 0 ) )
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return true;
}
//=================================================================================================
void Show
		(
		bool	show
		)
{
	if( show == false )
		::ShowWindow( m_hwnd , SW_SHOW );
	else
		::ShowWindow( m_hwnd , SW_HIDE );
}

};

/**************************************************************************************************
"Dialog" class 
**************************************************************************************************/
class Dialog : 
	virtual public object_base
{

// variable member
protected:
	HINSTANCE					m_hinst;
	HWND						m_hwnd;
	
// private functions
private:
//=================================================================================================
static
LRESULT CALLBACK DlgProcStatic
		(
		HWND	hwnd , 
		UINT	msg , 
		WPARAM	wparam , 
		LPARAM	lparam
		)
{
	if( msg == WM_INITDIALOG )
	{
		SetWindowLongPtr( hwnd , GWLP_USERDATA , ( LONG_PTR )lparam );
		Dialog*	pwin = ( Dialog* )GetWindowLongPtr( hwnd , GWLP_USERDATA );
		pwin->m_hwnd	= hwnd;
	}

	Dialog*	pwin= ( Dialog* )GetWindowLongPtr( hwnd , GWLP_USERDATA );
	bool	hook = false;
	if( pwin != 0 )
		pwin->DlgProc( hwnd , msg , wparam , lparam );
	
	if( msg == WM_DESTROY )
	{
		Dialog*	pwin = ( Dialog* )GetWindowLongPtr( hwnd , GWLP_USERDATA );
		pwin->m_hwnd	= NULL;
	}
	return hook == true ? TRUE : FALSE;
}
// protected functions
protected:
//=================================================================================================
virtual
bool DlgProc
		(
		HWND	hwnd,
		UINT	msg,
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	return false;
}
//=================================================================================================
bool EndDialog
		(
		int		retval
		)
{
	if( FALSE == ::EndDialog( m_hwnd , retval ) )
		return false;
	return true;
}
//=================================================================================================
HWND GetDlgItem
		(
		int	ctrlid
		)
{
	return ::GetDlgItem( m_hwnd , ctrlid );
}
// window
//=================================================================================================
void ctrl_Show
		(
		int		ctrlid , 
		bool	show
		)
{
	::ShowWindow( GetDlgItem( ctrlid ) , show == true ? SW_SHOW : SW_HIDE );
}
//=================================================================================================
void ctrl_Enable
		(
		int		ctrlid , 
		bool	enable
		)
{
	::EnableWindow( GetDlgItem( ctrlid ) , enable == true ? TRUE : FALSE );
}
//=================================================================================================
bool ctrl_IsEnable
		(
		int		ctrlid
		)
{
	return TRUE == IsWindowEnabled( GetDlgItem( ctrlid ) ) ? true : false;
}
// edit
//=================================================================================================
void edit_SetText
		(
		int				ctrlid , 
		const wchar_t*	str
		)
{
	::SendMessage( GetDlgItem( ctrlid ) , WM_SETTEXT , 0 , (LPARAM)str );
}
// Combo
//=================================================================================================
void combobox_ResetContent
		(
		int		ctrlid
		)
{
	::SendMessage( GetDlgItem( ctrlid ) , CB_RESETCONTENT , 0 , 0 );
}
//=================================================================================================
void combobox_AddString
		(
		int				ctrlid , 
		const wchar_t*	str
		)
{
	::SendMessage( GetDlgItem( ctrlid ) , CB_ADDSTRING , 0 , (LPARAM)str );
}
//=================================================================================================
void combobox_SetCurSel
		(
		int		ctrlid , 
		int		index
		)
{
	::SendMessage( GetDlgItem( ctrlid ) , CB_SETCURSEL , index , 0 );
}
//=================================================================================================
int combobox_GetCurSel
		(
		int		ctrlid
		)
{
	return ::SendMessage( GetDlgItem( ctrlid ) , CB_GETCURSEL , 0 , 0 );
}
// ListView
//=================================================================================================
void listview_SetExtendedListViewStyle
		(
		int		ctrlid , 
		int		style
		)
{
	ListView_SetExtendedListViewStyle( GetDlgItem(ctrlid) , style );
}
//=================================================================================================
void listview_InsertColumn
		(
		int				ctrlid , 
		int				subitem , 
		int				width , 
		const wchar_t*	str
		)
{
	LV_COLUMN col;
	col.mask		= LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM; 
	col.fmt			= LVCFMT_LEFT; 
	col.cx			= width; 
	col.pszText		= (LPWSTR)str; 
	col.iSubItem	= subitem; 
	ListView_InsertColumn( GetDlgItem( ctrlid ) , subitem , &col ); 
}
//=================================================================================================
void listview_InsertItem
		(
		int				ctrlid , 
		int				itempos , 
		const wchar_t*	str
		)
{
	LV_ITEM item;
	item.mask		= LVIF_TEXT; 
	item.pszText	= (LPWSTR)str; 
	item.iItem		= itempos; 
	item.iSubItem	= 0; 
	ListView_InsertItem( GetDlgItem( ctrlid ), &item ); 
}
//=================================================================================================
void listview_SetItem
		(
		int				ctrlid , 
		int				itempos , 
		int				subitempos , 
		const wchar_t*	str
		)
{
	LV_ITEM item;
	item.mask		= LVIF_TEXT; 
	item.pszText	= (LPWSTR)str;
	item.iItem		= itempos; 
	item.iSubItem	= subitempos; 
	ListView_SetItem( GetDlgItem(ctrlid), &item ); 
}
//=================================================================================================
bool listview_GetCheckState
		(
		int				ctrlid , 
		int				itempos
		)
{
	return ( TRUE == ListView_GetCheckState( GetDlgItem(ctrlid) , itempos ) ) ? true : false;
}
//=================================================================================================
void listview_SetCheckState
		(
		int				ctrlid , 
		int				itempos , 
		bool			state
		)
{
	ListView_SetCheckState( GetDlgItem(ctrlid) , itempos , state == true ? TRUE : FALSE );
}

// slider
//=================================================================================================
void slider_SetRange
		(
		int			ctrlid , 
		int			min , 
		int			max , 
		bool		redraw = true
		)
{
	::SendMessage( GetDlgItem( ctrlid ) , TBM_SETRANGE , (WPARAM)( redraw == true ? TRUE : FALSE ) , (LPARAM)MAKELONG( min , max ) );
}
//=================================================================================================
void slider_SetPos
		(
		int			ctrlid , 
		int			pos , 
		bool		redraw
		)
{
	::SendMessage( GetDlgItem( ctrlid ) , TBM_SETPOS , (WPARAM)( redraw == true ? TRUE : FALSE ) , (LPARAM)pos );
}
//=================================================================================================
int slider_GetPos
		(
		int			ctrlid
		)
{
	return ::SendMessage( GetDlgItem( ctrlid ) , TBM_GETPOS , 0 , 0 );
}

// public functions
public:
//=================================================================================================
Dialog() : 
		m_hinst( NULL ) , 
		m_hwnd( NULL )
{
}
//=================================================================================================
~Dialog()
{
	Destroy();
}
//=================================================================================================
bool DoModal
		(
		HINSTANCE		hinst , 
		HWND			parent , 
		const wchar_t*	templatename , 
		int*			retval
		)
{
	m_hinst	= hinst;
	int	rv = ::DialogBoxParam( hinst , templatename , parent , (DLGPROC)DlgProcStatic, (LPARAM)this );
	if( rv == -1 )
		return false;
	store( retval , rv );
	return true;
}
//=================================================================================================
bool Create
		(
		HINSTANCE		hinst , 
		HWND			parent , 
		const wchar_t*	templatename
		)
{
	m_hinst	= hinst;
	if( NULL == ::CreateDialogParam( hinst, templatename , parent , (DLGPROC)DlgProcStatic , (LPARAM)this ) )
		return false;
	return true;
}
//=================================================================================================
void Destroy()
{
	if( m_hwnd != NULL )
		DestroyWindow( m_hwnd );
	m_hwnd	= NULL;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
