<?php

require_once("tag.php");
require_once('func.php');
require_once('diff.php');

require_once('plugin.php');
require_once('parsemediator.php');




/**
 * original text and some additional information.
 * Meme(ミーム)の意味は他で調べてくれ
 * 
 * @see     : 
 * 
 * @version : 1.0.0
 *


virtual func...

//=================================================================================================
// parser,,,
 getParser();	//get parsemediator...
  createParser();
 is_parsed()
 parse()
  
//=================================================================================================
// strage...
 getStrage();	//get strage....(見実装)
  createStrage(); //...必要?
 load()
 save()
 is_loaded()
 getModifiedTime();
 delete()

//=================================================================================================
// others..(some initialize method??)
static


 */
class Meme extends ObjBase
{
	var $_parser;
	
	//pukiwiki では、内部でbracketnameとか使ってるトコもあったけど、
	//内部では、no bracket name で統一..
	var $_name;			///meme name,
	var $_encoded_name;	///encoded meme name(no suffix, no prefix,)
	var $_loaded;	//読み込まれているのか?
	var $_parser;				///parsed mediator.
	var $_lines;	//raw_text形式のファイルの行ごとの配列....
	var $_ver;	//このmemeの世代数..timestampにて保存..
	var $_passage;	//経過時間...

	function Meme($name = ""){
		$this->setName($name);
		$this->_parser	=	$this->createParser();
//		$this->_parser->setLines();
		$this->_loaded = false;
	}
	
	function addLines(& $new)
	{
		$arr = $this->getLineArray();
		$new = array_merge($arr, $new);
		$this->setLines($new);
		$this->save();
	}


	//ここでやるの?...
	function createParser()
	{
		return new ParseMediator($this->_encoded_name);
//		global $wiki;
//		$this->_parsed = $wiki->createParseMediator($this);
	}


	function & getLineArray()
	{
		if(!$this->isLoaded()){
			$this->load();
		}
		$parser = & $this->getParser();
		return $parser->getLineArray();
	}


/**
 * create file name, from unencoded string
 * 
 * @return  : encoded filename(but not include, directory and suffix)
 * @see     : $name : unencoded (normal) string
 * @param   : 
 * @throw   : 
 * @version : 1.0.0
 *
 */
	//static
	function getMemeName($name)
	{
		$str	= "";
		$array = array();
		$array = preg_split("//",$name, -1, PREG_SPLIT_NO_EMPTY);
		$l = count($array);
		$m = strlen($name);
		foreach($array as $ch){
			$str .= sprintf("%02X",ord($ch));
		}
//		$l = count($array);
//		echo($str."huaaaaaaaaa. $l $m is okasii");
		return $str;
	}
	function getModifiedTime()	{return 0;}
	
	function getName(){	return $this->_name;}


/**
 * get original string from encoded name
 * 
 * @return  : 
 * @see     : 
 * @param   : 
 * @throw   : 
 * @version : 1.0.0
 *
 */
	//static
	function getOriginalName($meme_name)
	{
//		return rawurldecode ($name)
		$str = '';
		
		for($i=0;$i<strlen($meme_name);$i+=2){
				$ch = substr($meme_name,$i,2);
				$str .= chr(intval("0X".$ch,16));
			}
		return $str;
	}

	
	function & getParser()	{return $this->_parser;}


	function & getPassageString()
	{
		global $wiki;
		$locale = & $wiki->getLocale();
		if(!$this->_passage){
			$time = UTIME - $this->getModifiedTime();

			if(ceil($time / 60) < 60){
				//less than 1hour
				$this->_passage = "(".ceil($time / 60).$locale->get("passage_minute").")";
			}
			else if(ceil($time/60/60)<24){
				//less than 1day
				$this->_passage ="(".ceil($time / 60 / 60).$locale->get("passage_hour").")";
			}
			else{
				//days..
				$this->_passage = "(".ceil($time / 60 / 60 / 24).$locale->get("passage_day").")";
			}
		}
		return $this->_passage;
	}
	
	function isLoaded()	{return $this->_loaded;}

	function isNewest()
	{
		if(!$this->_ver){
			return TRUE;
		}
//		echo("is newest ??? ".$this->getModifiedTime()."...dake?.".$this->_ver."no diff..");
		return $this->_ver == $this->getModifiedTime();
	}
	function isOldest()
	{
//		echo("is oldest ???....".$this->_ver."no diff..");
		$diffs = $this->getDiffArray();
		if(!count($diffs)){
			echo("is oldest because no diff..");
			return TRUE;
		}
		ksort($diffs);
		reset($diffs);

		list($key,$var) = each($diffs);
//		echo("is oldest ??? $key...dake?.".$this->_ver."no diff..");
		return $this->_ver == $key;
	}
	
	function isParsed()
	{
		if($this->_parser){
			return $this->_parser->isParsed();
		}
		return false;
	}


	
/**
 * memeをparse...
 * 
 * @return  : 
 * @see     : 
 * @param   : $parser : Perser class.
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function parse(& $parser)
	{
		if($this->isParsed()){
			return;	//もうparse済みだし....もう一回parseする必要はないと思う...
		}
		//もう読まれている時は読まれている.
		if(!$this->isLoaded()){
			$this->load();
		}
		$med = & $this->getParser();
		$parser->parse($med);
	}

	

	function setLines(& $arr)
	{
		$this->_parser->setLines($arr);
		$this->_loaded = TRUE;
	}
	
	function setName($name)
	{
		$this->_name	  	= $name;
		$this->_encoded_name= $this->getMemeName($name);
	}


	//(昔のバージョンを見るため)バージョンをセットする..
	function setVersion($time, $current)
	{
//		$ver = $this->getVersion();
		if("prev"==$time){
//			echo("previous...");
			$time = $this->getPreviousVersion($current);
		}
		else if("next"==$time){
			$time = $this->getNextVersion($current);
		}
		$this->_ver = $time;
		//その後diff取ってそのversionまでセットする...
		$this->loadBackup($time);
	}


}



define('MEME_SUFIX','.txt');
define('MEME_DIR', './meme/');

class FileMeme extends Meme
{
	var $_file_name;	///meme file name,
	var $_diffs;
	//protected...
	function FileMeme($name)
	{
		$this->Meme($name);
//		echo("file meme name is .. $name ");
		if(!$name){
			//無名でつくる事はないはず...だよね?
			die_("cant create no-name wiki...");
		}
//		$this->_diffs  = array();
	}

	function & getDiffArray()
	{
		if($this->_diffs){
			return $this->_diffs;
		}
		
		$file = $this->getDiffFileName();
		
		if(!isFile($file)){
			//diffのファイルが存在しないので終了,,,
			$this->_diffs = array();
			return $this->_diffs;
		}
		
		$arr = gzfile_rtrim($file);
		
		$num = count($arr);
		$out = array();
		$diffs = & $this->_diffs;
		for($i=0;$i<$num;$i++){
			$str = $arr[$i];
//			echo("ぢふ<pre>$str</pre>");
			if(preg_match("/^====(.*?):(.*?):(.*?):(.*?):/", $str, $out)){
				$key = $out[1];
				$diff = "";
				$i++; //次の行からがdiff..
				for(;$i<$num;$i++){
					$str = $arr[$i];
					if(preg_match("/^====(.*?):(.*?):(.*?):(.*?):/", $str, $out)){
						//ここでこのdiffは終わり..
						break ;
					}
					$diff .= $arr[$i] ."\n";
				}
//				echo("ぢふですよ...<br/><pre>$diff</pre>");
				$diffs[$key] = $diff;
			}
		}


		//普段逆に使う方が多いので逆転させる...
		krsort($diffs);
		return $diffs;
	}

//	function getDiffFileName(){return DIFF_DIR . $this->_encoded_name . ".txt";}
	function getDiffFileName(){
		return DIFF_DIR . $this->_encoded_name . DIFF_SUFFIX;
	}
	
	function getFileName(){return $this->_file_name;}
	


/**
 * すべてのmemeの"名前"のリストを取得する..
 * memeのarrayではないので注意...
 * @return  : 
 * @see     : 
 * @param   : 
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function & getMemeNameList()
	{
		static $list;
		if($list){
			return $list;
		}
		$list = array();
		
		if($dir = opendir(MEME_DIR)){
			while($file = readdir($dir)){
				if($file == ".." || $file == "." || strstr($file,MEME_SUFIX)===FALSE) continue;
				$page = $this->getOriginalNameFromFileName($file);
				array_push($list, $page);
//				echo("<br/>$page's original file is ...$file, ");
			}
			closedir($dir);
		}
		return $list;
	}



	function getModifiedTime()
	{
		if($this->isFile()){
			$file_name = $this->getFileName();
			return filemtime($file_name);
		}
		else{
			//このscriptが動いてる最中より前、という事にしておく,,,(参照される事あるか?)
			return UTIME - 1;
		}
	}

	function getOriginalNameFromFileName($file)
	{
		$file = preg_replace("/\.txt$/","",$file);
		$page = $this->getOriginalName(trim($file));
		return $page;
	}

	function getVersion()
	{
		if(!$this->_ver){
			//おそらく現在のファイルのバージョンじゃなかろうか?..
			return $this->getModifiedTime();
			//読まれてないと話にならん?.
		}
		return $this->_ver;
	}

	function getNextVersion($ver)
	{
		$diffs = $this->getDiffArray();
		$times = array_keys($diffs);
		$num = count($times);
		$next = $this->getModifiedTime();
		
		if(!array_key_exists($ver, $diffs)){
			//ないもののnextは???
//			echo("no time_ver is in diff why you want to get next??.");
			return $this->getModifiedTime();
		}

		ksort($diffs);
		reset($diffs);

		//一個一個みていく..
		while($arr = each($diffs)){
			list($key, $val) = $arr;
			if($ver == $key){
				$arr  = each($diffs);
				if(!$arr){
//					echo("no.more...nextfile maybe newest is ok....$ver....");
					return $this->getModifiedTime();
				}
				list($key, $val) = $arr;
//				echo("normal diff....$num, $key.beforefile ....$ver....");
				return $key;
			}
		}
		//ないから現在のtimeを返す...
//		echo("why you run this line??? no.more, nextfile ....$ver....");
		return $this->getModifiedTime();
	}

	function getPreviousVersion($ver)
	{
		$diffs = $this->getDiffArray();
		reset($diffs);
		$times = array_keys($diffs);
		$num = count($times);

		if(!count($diffs)){
//			echo("no diff..");
			return $ver;
		}
		if(!array_key_exists($ver, $diffs)){
			if($num){
				list($key, $val) = each($diffs);
//				echo("newestno..$num, $key.beforefile ....$ver....");
				return $key;
			}
			return $ver;
		}
		//一個一個みていく..
		while($arr = each($diffs)){
			list($key, $val) = $arr;
//			echo(".$key...$ver....");
			if($ver == $key){
				$arr  = each($diffs);
				if(!$arr){
//					echo("no.more...beforefile ....$ver....");
					return $ver;
				}
				list($key, $val) = $arr;
//				echo("normal diff....$num, $key.beforefile ....$ver....");
				return $key;
			}
		}
//		echo("why you run this line??? no.more, beforefile ....$ver....");
		return $ver;
	}


	
/**
 * ふつうのファイルか?
 * 
 * @return  : false : だめ true: よし..
 * @see     : 
 * @param   : 
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function isFile()
	{
		$file_name = $this->getFileName();
		return isFile($file_name);
	}



/**
 * ファイルを読み込む...
 * もう読まれている時は読まない(isLoadedは外に出した方がよさそうだけどな..)
 * @return  : true : success, false : 読めなかった(error?)
 * @see     : 
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function load()
	{
		//それぞれの状況でエラーを返す...
		$file_name = $this->getFileName();
//		echo("load $file_name file!?");
		//もう読まれている時は読まれている.
		if($this->isLoaded()){
//			echo("already loaded?");
			return true;
		}

		if(!$this->isFile()){
			$name = $this->getName();
//			echo("no $file_name($name)file!?");
			return false;
		}
		if(!is_readable ($file_name)){
			echo("no read!?");
			return false;
		}
		$arr = file_rtrim($file_name);
		$this->setLines($arr);
		return true;
	}

/**
 * ファイルのバックアップを読み込む...
 * 
 * @return  : true : success, false : 読めなかった(error?)
 * @see     : 
 * @param   : $ver : 昔のversionを読む時は引数を渡される...
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function loadBackup($ver)
	{
		$now =  $this->getModifiedTime();
		if($now == $ver){
			$this->load();
			return ;
		}
		$file_name = $this->getFileName();
		if($this->isLoaded()){
			echo("already loaded?");
			return true;
		}

		if(!$this->isFile()){
			$name = $this->getName();
			echo("no $file_name($name)file!?");
			return false;
		}
		if(!is_readable ($file_name)){
			echo("no read!?");
			return false;
		}
		$arr = file_rtrim($file_name);

		$diffs = & $this->getDiffArray();
		foreach($diffs as $time=>$diff){
			//一段階diffを適用...
//			echo("<br/>$time diff..<br/><pre>$diff</pre>\n");
			$arr = diffApplyReverse($arr, $diff);
			if($time == $ver){
				//最後にもう一回適用してbreak
				break;
			}
		}
		
		$this->setLines($arr);
		return true;
	}




/**
   save と書いてあるが,,,,
   
   -ファイル新規作成
   -ファイルを削除
   -ファイルを更新
   ...という作業が存在する..saveの中でそれぞれに分岐する..
 */
	function save($timestamp=NULL)
	{
		$file_name = $this->getFileName();
		if(file_exists($file_name)){
			$old = file_rtrim($file_name);//...
		}
		else{
			$old = array();
		}
		$new = $this->getLineArray();
		$line_num = count($new);
		$time_pre = $this->getModifiedTime();


		if(!$line_num){
			echo("..save but delete:" . $file_name);
			if($this->isLoaded()){
				unlink ($file_name);	//delete
				$this->saveDiff($old, $new, $time_pre, time()); //diffもセーブする..
				$success = true;
			}
			else{
				//読んでいないファイルで行数ゼロの時は削除するのか? とりあえずしないことにしよう...
				echo("..save but don't loaded, (nothing to do):" . $file_name);
				return true;
			}
		}
		else{
			//削除、ではなくて本当にセーブ...
			//追記... or 新規作成...
//			echo("<br/>save junda start $file_name<br/>\n");
			$success = false;

			$file = fopen($file_name,"w");
			if(!$file){
				die_("cannot write meme file, $file_name, <br/> I think, no parmission or too long file name...");
				return false;
			}

			$str = join("\n",$new);
			while(!flock($file, LOCK_EX));{			//超やばいけどファイルを無限ロック...
				if(-1 == fwrite($file, $str)){
					echo("...cant write file:" . $file_name);
					$success = false;
				}
				else{
					$success = true;
					$time = time();
					$this->saveDiff($old, $new, $time_pre, $time); //diffもセーブする..
/*
					if(!touch($file, $time)){
						echo("cant touch file time stamp");
					}
*/
				}
			}flock($file, LOCK_UN);
			fclose($file);

		}

		if($timestamp){
			touch($file, $timestamp);
		}
		else{
			if(MEME_RECENT != $this->getName()){
				$this->saveLastmodified();
			}
		}
		return $success;
	}

	function saveDiff($old, $new, $time_pre, $time)
	{
		if(MEME_RECENT == $this->getName()){
			//こいつはdiffとらんでいいだろ..
			return;
		}
		
		$name = $this->getDiffFileName();

		//新規の時はdiff作る必要ない(というか作るな..)
		if(!file_exists($name) && (!count($old))){
			//diffのfileもなく、oldが無いなら新規でmeme作ったという事だと思う..
			return;
		}
		$diff = getDiffHeader("0.0",$time_pre, $time)
		. getDiff($old, $new) . getDiffFooter("0.0", $time_pre, $time);

		if(!function_exists("gzopen")){
			return gzfprint($name, $diff, "a");
		}
		else{
			return fprint($name, $diff, "a");
		}
	}



	
	function saveLastmodified()
	{
		global $wiki, $maxshow;
		//これなんで毎回リスト作っとるんや!?   
		$files = $this->getMemeNameList();
		
		foreach($files as $page){
			if((!$page) || ($page == MEME_RECENT)){
				continue;
			}
			$meme = & $wiki->getMeme($page);
			$lastmodtime = $meme->getModifiedTime();
			$putval[$lastmodtime] = "$lastmodtime,$page";
		}
		$cnt = 1;
		krsort($putval);
		$putval = array_slice($putval, 0, $maxshow);
		$meme_recent = & $wiki->getMeme(MEME_RECENT);
/*		
		foreach($putval as $val){
			echo("<br/>$val...");
		}
*/		
		$file_name = $meme_recent->getFileName();
		return fprint($file_name, join("\n",$putval), "w");
	}
	
/**
 * 名前のセット
 * 
 * @return  : 
 * @see     : 
 * @param   : $name	:	name of meme, raw_text (un encoded)
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function setName($name)
	{
		parent::setName($name);
		$this->_file_name	= MEME_DIR . $this->_encoded_name . MEME_SUFIX;
	}


}

?>