<?php

require_once("tag.php");
require_once('func.php');
require_once('diff.php');
require_once('plugin.php');


/**
 * parse用mediator,iterator兼用..
 * ひとつのwikitextにひとつ割り振られるテンポラリーワーク...
 * wikitext,の中に入れておいてもいいか? wikitextと一対一対応する...
 * @see     : 
 * 
 * @version : 1.0.0
 * 
 */
class ParseMediator extends ObjBase
{
	var	$_body;			///本文用ツリー(メイン)
	var $_note;			///注釈用ツリー
	var $_related;		///related用ツリー...
	var $_contents;		///目次用ツリー...

//	var $_top;			///renderall 用top
	var $_lines;		///wikitext を\nごとに分割したarray
	var $_line_num;		///現在行は何行目か?
	var $_line;			///現在行の文字列..

//	var $_replaced;		///変更された行(いくつかのコンポーネントは元のソースを変更する..)
	var $_parsed;
	var $_note_num;
	var $_name;
/**
 * 
 * 
 * @return  : 
 * @see     : 
 * @param   : $name : 名前
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function ParseMediator($name="")//?? or $wiki?
	{
		$this->_body	=	new Tag(TAG_WIKIBODY);
		$this->_note	=	new Tag(TAG_WIKINOTE);
		$this->_related	=	new Tag(TAG_WIKIRELATED);
		$this->_contents =	new TagContents($name);
		$this->_lines	=	array();
		$this->_line_num=	0;
		$this->_line	=	"";
		$this->_parsed	=	FALSE;

		$this->_note_num=	1;
		global $wiki;
		$widget = & $wiki->getWidget();
		$note_hr = & $widget->get("note_hr");
		$this->_note->add($note_hr);
		$this->_name = $name;
	}


	function addBody(& $tag)
	{
		$this->_body->add($tag);
	}


	function addContent($str, $num, $h=NULL)
	{
		global $wiki;
		$widget = & $wiki->getWidget();
		$content = & $this->getContents();

		$content->addContent($str, $num);

		$cnt1 = $content->getCnt1();
		$cnt2 = $content->getCnt2();
		$cnt3 = $content->getCnt3();

		
		$n = "_".$cnt1."_".$cnt2."_".$cnt3;
		$cont = $this->_name.$n;
		$conts = "_" . $cont;
		$tag_a = new Tag("a", array("name"=>$cont));
		$tag_a2 = new Tag("a", array("href"=>"#$conts"));
		$tag_a3 = new Tag("a", array("name"=>$str));
		$tag_h = new Tag("h$num");
		$tag_i = new Tag("span", array("class"=>"super_index"));

		//他のページから http://...../idea.php?hoge#内容 とかでジャンプできるように....

		$tag_h->add($h);
//		$tag_i->add($widget->get('contents_top'));
		$ttt = ">top";		$tag_i->add($ttt);
		$tag_a2->add($tag_i);
		$tag_h->add($tag_a2);

		$this->addBody($tag_a);
		$this->addBody($tag_a3);
		$this->addBody($tag_h);

	}

	
	function addNote(& $out)
	{
		$str = $out[1];
		if(!$str){
			return;
		}
		$note = & $this->_note;
		$num = $this->_note_num++;
		
		$note_str = "note_".$this->_name."_".$num;
		$note_foot = "note_foot_".$this->_name."_".$num;
		$br	=	"<br/>";
		$tag = new Tag("a", array("name"=>$note_foot,
								  "href"=>"#$note_str",
								  "class"=>"note_super"));
		$span = new Tag("span", array("class"=>"small"));
		$link = '*'.$num;
		$tag->add($link);
		$span->add($str);
		$note->add($tag);
		$note->add($span);
		$note->add($br);
//		$note->add($str);
		return "<a name=\"$note_str\" href=\"#$note_foot\" class=\"note_super\">*$num</a>";
	}

	//関連ページを追加...
	function addRelated($page_str)
	{
		global $wiki;
		$widget = & $wiki->getWidget();
		$str = $widget->getMemeUrl($page_str);
		$tag = new Tag("a", array("class" => "related"));
		$tag->add($str);
		$this->_related->add($tag);
	}
	
	function current()
	{
		$this->setString(current($this->getLineArray()));
	}
	
	function & getBody(){return $this->_body;}

	function & getContents()		{	return $this->_contents;}
	
	function getLine()			{	return $this->_line;}
	function & getLineArray()	{	return $this->_lines;} //...
	
	function getLineNum()		{	return $this->_line_num;}
	function getName()			{	return $this->_name;}
	function getNoteNum()		{	return $this->_note_num;}

	function isParsed()			{return $this->_parsed;}

	function next()
	{
//		echo ("next..., ");
//		$this->setString(next($this->getLineArray()));
		$arr = & $this->getLineArray();
		$this->_line_num++;
		if(list($n, $line) = each($arr)){
			$this->setString($line);
			return true;
		}
		return false;
		
	}
	function prev()
	{
		$this->setString(prev($this->getLineArray()));
		$this->_line_num--;
	}



	function reset()	{	reset($this->_lines);	}


	function setParsed()	{$this->_parsed = true;}	

	function setLines(& $arr)
	{
		$this->_lines = array();	//初期化.
		if(!$arr){
			return;
		}
		if(is_string($arr)){
			//文字列だった場合、改行コードで分割された配列と見なす..
			$arr = explode("\n", $arr);
		}
		foreach($arr as $n=>$str){
			$string = rtrim($str);
			$this->_lines[$n] = $string;
		}
		$this->reset();
	}
	
/**
 * prev, next などのために、文字列用ワークセット...
 * 
 * @return  : 
 * @see     : 
 * @param   : 
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function setString(& $str)
	{
		$this->_line = $str;
	}
}

	
?>