<?php


define("MAX_FILESIZE", 1000000);

//この2点はおまじない以上の効果があるのか?	
ini_set("file_uploads", "1");
ini_set("upload_max_filesize", "8M");



define("ATTACH_ARG_COMMAND", "attach_command");
define("ATTACH_ARG_FILE", "attach_file");
define("ATTACH_DEFAULT_NUM", 1);	//file送信フォームを標準で何個書くか

	
class AttachPlugin extends Plugin
{
	function convert(& $wiki,& $mediator,& $out)
	{
		if(array_key_exists(0, $out)){
			$n = $out[0];
		}
		else{
			$n = ATTACH_DEFAULT_NUM;
		}
		
		$page = $wiki->getPage();

		$form = new Tag("form",array("enctype"=>"multipart/form-data",
									 "action"=>WIKI_SCRIPT,
									 "method"=>"post"));
		$max  = new Tag("input",array('type'=>'hidden',
									  'name'=>'MAX_FILE_SIZE',
									  'value'=>MAX_FILESIZE));
		$plugin = new Tag("input",array('type'=>'hidden',
									  'name'=>'plugin',
									  'value'=>'attach'));
		$com  = new Tag("input",array('type'=>'hidden',
									  'name'=>'attach_command',
									  'value'=>'upload'));
		$p    = new Tag("input",array('type'=>'hidden',
									  'name'=>'page',
									  'value'=>$page));
		$button   = new Tag("input",array('type'=>'submit',
									  'value'=>'Send File'));
		$form->add($max);
		$form->add($plugin);
		$form->add($com);
		$form->add($p);
//		$n = 10;
		$br = "<br/>";
		for($i=0; $i < $n; $i++){
			$send = new Tag("input", array("name"=>'userfile[]',
										   "type"=>'file'));
			$form->add($send);
			$form->add($br);
			unset($send);
		}
		$form->add($button);
		$form2 = "添付ファイルリスト<br/>\n";
		$tag = new TagOlBase();

		$list = $this->getAttachFileList($page);
		if($list){
			foreach($list as $file){
				$str = $this->getAttachFileLink($page, $file);
				$tag->addOl($str,1);
			}
		}
		
		$mediator->addBody($form);
		$mediator->addBody($form2);
		$mediator->addBody($tag);
		
	}

	function action(& $wiki)
	{
		$command = $wiki->getArg(ATTACH_ARG_COMMAND);
		switch($command){
		case "upload":
			$this->uploadFile($wiki);
			break;
		case "open":
			$this->openFile($wiki);
			break;
		default:
			parent::action($wiki);
/*
			$meme = new Meme("temp");
			$mediator = & $meme->getParser();
			$arg = array();
			$this->convert($wiki, $mediator, $arg);
			$mediator->_body->renderAll($wiki->_body, $mediator);
			break;
*/
		}
	}

	function getAttachFileLink($page, $file)
	{
		return '<a href="'.WIKI_SCRIPT.'?page='.$page.'&plugin=attach&attach_command=open&attach_file='.$file.'">'.$file."</a>";
	}
	function getAttachFileList($page)
	{
		$meme_name = Meme::getMemeName($page);
		if(!is_dir(FILE_DIR.$meme_name)){
			return ;
		}
		$list = array();
		if($dir = @opendir(FILE_DIR. $meme_name)){
			while($file = readdir($dir)){
				if($file == ".." || $file == ".") continue;
				array_push($list, $file);
			}
			closedir($dir);
		}
		return $list;
	}

	function openFile($wiki)
	{
		$name = $wiki->getArg(ATTACH_ARG_FILE);
		$page = $wiki->getPage();
		$meme_name = Meme::getMemeName($page);
		$file_name = FILE_DIR.$meme_name ."/". $name;
		$length = filesize($file_name);

		/* pukiwiki は以下のようにしているが、internationalでこれはどうよ?
		   //マシンのnativeコードを世界共通にしてけれ...
		if(function_exists("mb_convert_encoding")){
			$name = mb_convert_encoding($name, "SJIS", "auto"); 
		}
*/
		header("Content-Disposition: inline; filename=\"$name\"");
		header("Content-Length: ".$length);
		header("Content-Type: application/octet-stream");
		readfile($file_name);
	}


	function uploadFile(& $wiki)
	{
		$page = $wiki->getPage();
		$meme_name = Meme::getMemeName($page);

		$file_num = count($_FILES['userfile']['tmp_name']);

		for($count = 0; $count < $file_num; $count++){
			$file_name = $_FILES['userfile']['tmp_name'][$count];
			$name = $_FILES['userfile']['name'][$count];
			$error = $_FILES['userfile']['error'][$count];
			if($error && $name){
				echo("error $count no $error!?!?!");
			}
			if((!$file_name)||!is_uploaded_file($file_name)){
				continue;
			}
			//bool
			//memeごとにディレクトリを掘って保存する.
			if(!is_dir(FILE_DIR.$meme_name)){
				mkdir(FILE_DIR.$meme_name);
			}
			move_uploaded_file ($file_name, FILE_DIR.$meme_name."/".$name);		
			$r = chmod (FILE_DIR.$meme_name."/".$name, "0666");	//winでは失敗??
		}

/**
success?each. Array name -> Array.
each. Array type -> Array.
each. Array tmp_name -> Array.
each. Array error -> Array.
each. Array size -> Array.


   UPLOAD_ERR_OK	値: 0; エラーはなく、ファイルアップロードは成功しています。
UPLOAD_ERR_INI_SIZE	値: 1; アップロードされたファイルは、php.ini の upload_max_filesize ディレクティブの値を超えています。

UPLOAD_ERR_FORM_SIZE	値: 2; アップロードされたファイルは、HTMLフォームで指定された MAX_FILE_SIZE を超えています。

UPLOAD_ERR_PARTIAL		値: 3; アップロードされたファイルは一部のみしかアップロードされていません。

UPLOAD_ERR_NO_FILE		値: 4; ファイルはアップロードされませんでした。

*/
		
		$wiki->viewPage();
	}
}




?>