<?php

//define("COMMENT_DIR",DATA_DIR."/comment/");


require_once('plugin.php');
require_once('tag.php');
require_once('meme.php');



define("COMMENT_PREFIX","-");
define("COMMENT_ARG_NAME","name");
define("COMMENT_ARG_MESSAGE","message");
define("COMMENT_ARG_THREAD","thread");
define("COMMENT_ARG_NUMBER","comment");
define("COMMENT_ARG_PAGE","comment_page");
define('COMMENT_NAME', "comment_name");



class CommentPlugin extends Plugin
{
	function convert(& $wiki,& $mediator,& $out)
	{
		$parser = & $wiki->getParser();
		$name = $mediator->getName();

		$number = key($mediator->getLineArray()) - 1; //current == #comment の次の行なので-1..

		$reg	= "/^(".COMMENT_PREFIX."{1,3})(.*)/";

		$page_name = Meme::getOriginalName($mediator->getName());
		//...これpage引数に取らないとincludeでもめる..
		$tag = new TagCommentPlugin($page_name, $number);

		$tag->init();
		while($mediator->next()){
			$str1 = $mediator->getLine();
			if(!preg_match($reg, $str1,$out)){
				//終了...
				break;
			}
			$line = $out[2];
			$parser->replaceLine($mediator, $line);
			$tag->addSentence($line, strlen($out[1]));
		}
//		echo("ここきてますか?");
		$mediator->addBody($tag);
		$mediator->prev();				//iteratorを一個戻す(間違えて取っちゃったから..)
	}

	function action(& $wiki)
	{
//		$page = $wiki->getPage();
		$locale = & $wiki->getLocale();
		$comment_page = $wiki->getArg(COMMENT_ARG_PAGE);
		$meme = & $wiki->getMeme($comment_page);
		$meme->load();
		$name = stripslashes($wiki->getArg(COMMENT_ARG_NAME));
		if(!$name){
			$name = $locale->get('comment_default_name');
		}

		$name = "[[".$name."]]";
		$message = stripslashes($wiki->getArg(COMMENT_ARG_MESSAGE));
		$thread_string = $wiki->getArg(COMMENT_ARG_THREAD);
		if((NULL === $thread_string) || ("no" == $thread_string)){
			$depth = 0;
			$thread = 0;
		}
		else{
			list($thread, $depth) =  explode(COMMENT_PREFIX,$thread_string);
		}

		$number = $wiki->getArg(COMMENT_ARG_NUMBER);
		$time  = $wiki->getCurrentTimeString();
		

		if(3 < $depth){
			$depth = 3;
		}
		$line = str_repeat(COMMENT_PREFIX, $depth+1)
		.eval(addReturn($locale->get('comment_string')));

		array_splice($meme->getLineArray(), $number + $thread + 1, 0, $line);

		$meme->save();	//一度セーブしないとダメ、、、だよね?
		//書き込んだらあとは普通の表示と同じ...
		$wiki->viewPage();
	}
}


/**
 * コメント表示用タグ....
 * 
 * @return  : 
 * @see     : 
 * @param   : 
 * @throw   : 
 * @version : 1.0.0
 *
 */

class TagCommentPlugin extends Tag
{
	var $_number;
	var $_ul;
	var $_counter;
	var $_page;

	function TagCommentPlugin($page, $num)
	{
		$this->_page = $page;
		$this->_number = $num;
		$this->_counter = 1;
		$this->Tag("form", array("class"=>"comment-plugin",
								 "action"=> WIKI_SCRIPT,
//								 "method"=>"get"
								 "method"=>"post"
								 ));
	}
	

/**
 * コメントの文章をひとつ追加...
 * 
 * @return  : 
 * @see     : 
 * @param   : $str : コメント用文章
 * @param   : $num : 何番目のインデント?
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function & addSentence($str, $num)
	{
		$counter = $this->_counter++;
		$name = $this->getRadioName();
		$radio = $counter.COMMENT_PREFIX.$num;
		$s = "<input type=\"radio\" name=\"$name\" value=\"$radio\"/>\n".$str;
		$this->_ul->addUl($s, $num);
	}

	//radioボタンの名前.
	function getRadioName()
	{
		return COMMENT_ARG_THREAD;
	}
	function getNumber()
	{
		return $this->_number;
	}
	//なんかコンストラクターで$thisを呼ぶと(new Tagすると?)おかしくなるのでこれで初期化する...
	function init()
	{
		global $wiki;
//		$widget = & $wiki->getWidget();
		$locale = & $wiki->getLocale();
		$this->_ul = new TagUlBase();
		$radio = new TagSingle("input", array("type"=>"radio",
										"name"=>$this->getRadioName(),
										"value"=>"no"));
		
		$name = new Tag("input", array("type"=>"text",
									   "name"=>COMMENT_ARG_NAME,
									  "size"=>10));
		
		$text = new TagSingle("input", array("type"=>"text",
									   "name"=>COMMENT_ARG_MESSAGE,
									   "size"=>"50"));
		$submit= new TagSingle("input",array("type"=>"submit",
											 "value"=>$locale->get("comment_send")));

		$plugin = new Tag("input", array("type"=>"hidden",
									   "name"=>ARG_PLUGIN,
									  "value"=>"comment"));

		$page = new TagSingle("input", array("type"=>"hidden",
									   "name"=>"page",
									  "value"=>$wiki->pageString($wiki->getPage())));
		$comment_page = new TagSingle("input", array("type"=>"hidden",
									   "name"=>COMMENT_ARG_PAGE,
									  "value"=>$wiki->pageString($this->_page)));
		$number = new TagSingle("input", array("type"=>"hidden",
									   "name"=>COMMENT_ARG_NUMBER,
									  "value"=>$this->getNumber()));

		$this->add($this->_ul);
		$this->add($plugin);
		$this->add($page);
		$this->add($comment_page);
		$this->add($number);
		$this->add($radio);
		$this->add($locale->get(COMMENT_NAME));
		$this->add($name);
		$this->add($text);
		$this->add($submit);
	}
}



?>