<?php

define("RECENT_DEFAULT_NUM",20);


/**
 * Recent(20)とか表示用...
 * 
 * 
 * @see     : 
 * 
 * @version : 1.0.0
 * 
 */
class RecentPlugin extends Plugin
{
	function convert(& $wiki,& $mediator,& $out)
	{
		global $whatsnew;
		$locale = & $wiki->getLocale();
		
		if($out[0]) {
			$recent_lines = $out[0];
		}
		else{
			$recent_lines = RECENT_DEFAULT_NUM;
		}
		
		$meme_recent = $wiki->getMeme($whatsnew);
		if(!$meme_recent->isFile()){
			return;
		}

		$lines = array_slice($meme_recent->getLineArray(), 0, $recent_lines);

		$h5 = new Tag("h5", array("class"=>"recent"));//,
		$h5_string = sprintf($locale->get("recent_string"), $recent_lines);
		$h5->add($h5_string);
		$mediator->addBody($h5);


		$div = new Tag("div", array("class"=>"recent"));
		$time_str ="";
		$date = array("year"=>0,"yday"=>0);
		$li = new Tag("li");
		foreach($lines as $line){
			$match = array();
			preg_match("/(\d+),(.*)/",$line,$match);
			list(,$time, $name) = $match;
//			$title = htmlspecialchars($name);
			$title = $name;
			if(!$title){
				//なんかの手違いとかバグでこうなることがあるのでそのときは飛ばす...
				continue;
			}
			$meme = & $wiki->getMeme($name);
			$li = new Tag("li");

			$arr = getdate($time);
			if(($date["year"] != $arr["year"]) || ($date["yday"] != $arr["yday"])){
				$date = $arr;
				$time_str = "<span class=\"recent-day\">".date('Y-m-d <br/>', $time)."</span>";
				if($div){
					$mediator->addBody($div);
				}
				unset($div);
				$mediator->addBody($time_str);
				$div = new Tag("div", array("class"=>"recent"));
			}


			$link = new Tag("a", array("href"=>WIKI_SCRIPT."?".rawurlencode($name),
									   "title"=>$title ." " . $meme->getPassageString()
									   ));
			$link->add($title);
			$li->add($link);
			$div->add($li);
			unset($li);
			unset($link);
			unset($meme);
		}
		$mediator->addBody($div);
	}

	function getArg()
	{
		return array(1000);
	}
/*
	function action(& $wiki)
	{
		$meme = new Meme("temp");
		$mediator = & $meme->getParser();

		$arg = array(1000);
		$this->convert($wiki, $mediator, $arg);
		$mediator->_body->renderAll($wiki->_body, $mediator);
	}
	function action(& $wiki)	{
		$meme = new Meme("temp");
		$mediator = & $meme->getParser();
		$arg = $this->getArg();
		$this->convert($wiki, $mediator, $arg);
		$mediator->_body->renderAll($wiki->_body, $mediator);
	}
*/

}
	
?>