<?php

require_once("define.php");

define('TAG_HTML', 'html');
define('TAG_PRE', 'pre');

define('TAG_WIKIHEAD', 'wikihead');
define('TAG_WIKINOTE', 'wikinote');
define('TAG_WIKIRELATED','wikirelated');
define('TAG_WIKIBODY', 'wikibody');
define('TAG_UL_BASE', 'hoge');
define('TAG_WIKICONTENT','content');
define('TAG_WIKICONTENTS','contents');


static $tagbase_global_tag_number = 0;


class Tag extends ObjBase
{
	var $_tag_param;
	var $_tag_name;

	var $_parent; //...うーん
	var $_sibling;
	var $_child_top;
	var $_child_last;

	var $_id; //tag == tag2,というチェックを行う時にこれだけ参照する...



//	var $_string;

/**
 * 
 * 
 * @return  : 
 * @see     : 
 * @param   : name = "<$name class="$class"></$name>"という感じ...
 * @throw   : 
 * @version : 1.0.0
 *
 */
	function Tag($name, $arr = NULL)
	{
		global $tagbase_global_tag_number;
		$this->_tag_name 	= 	$name;
		$this->_parent		=	NULL;
		$this->_sibling		=	NULL;
		$this->_child_top	=	NULL;
		$this->_child_last	=	NULL;
		$this->_id = $tagbase_global_tag_number++;

		$this->_tag_param		=	array();
		if(!$arr){
			return;
		}
		/*	
		if(!is_array($arr)){
			die("$name, $arr is ???");
		}
*/
		foreach($arr as $key=> $var){
			$this->addTagParam($key, $var);
		}
	}


	function & add(& $tag)	{
		if(!$tag){
			trace($this);
			die("no tag?");
		}
		return $this->addSimple($tag);
	}
	function & addSimple(& $tag)
	{
		if(!$tag){
			die("eee?");
		}
		if(!get_class($tag)){
			//文字列はclass名とかない..
//			echo("tag_type_nothing_error...$tag ");
			$str = new TagStr($tag);
			return $this->addSimple($str);
		}
		if($tag == $this){
			die("runtime error: cant insert own, $tag!!!<br/>");
			return;
		}
		if(!is_a($tag,"Tag")){
//			$this->addSimple(new TagString($tag)); ...という風にstringとして足す?
			die("runtime error :cant insert object, $tag!!!<br/>");
			return;
		}
		if($this->isSame($tag)){
			die("runtime error :cant insert same object, $tag!!!<br/>");
			return;
		}

//		echo $tag->_tag_name . "<br/>\n";
		$tag->setParent($this);

		if(!$this->_child_top){
			$this->setChildTop($tag);
		}
		else{
			$last = & $this->getChildLast();
//			$last->trace();
			$last->setSibling($tag);
		}
		
		$this->setChildLast($tag);
		return $this;
	}

/*
	//配列として渡す事も考えてみる.. addArray(tag1, tag2, tag3,,,,)
	function & addArray($args)
	{
		$n=count($args);
		$i =0;
		while($i<$n){
			$this->add($args[$i++]);
		}
		return $this;
	}
*/	

	function addTagParam($class, $param)
	{
		if($class){
			$this->_tag_param[$class] = $param;
		}
	}



	function & getChildTop(){ return $this->_child_top;}
	function & getChildLast() {return $this->_child_last;}

	function getID()				{return $this->_number;}
	function & getParent()			{return $this->_parent;}
	function & getSibling() 		{return $this->_sibling;}






	function  getParamString() {
		$str = "";
		foreach($this->_tag_param as $class => $value){
			$str .= " $class=\"$value\"";
		}
		return $str;
	}
	function & getTagName()	{return $this->_tag_name;}


	

	function isSame(& $tag)
	{
		return $this->_id == $tag->_id;
	}


	
	function renderPre(& $out, & $mediator){
		$out .= $this->tagPre();
	}
	function renderAfter(& $out, & $mediator){
		$out .= $this->tagAfter();
	}


	function renderAll(& $out, & $mediator)
	{
		$node = & $this;
		$flg_pre = 1;
		$i = 0;	//for debug.
		$j = 0;	//for debug.
		
		while($node){//loop//			$node->trace();
			if($flg_pre){
				//pre を描画..
//				decho("pre..".$i.".".$j.".".$node->_tag_name.".".$node->_id.".<br/>\n");
				$node->renderPre($out, $mediator);$i++;

				if($node->getChildTop()){
					$node = & $node->getChildTop();
					$flg_pre = 1;
				}
				else{
					$flg_pre = 0;
				}
			}
			else{
				//afterを描画せよの意味..
//				decho("after..".$i.".".$j.".".$node->_tag_name.".".$node->_id.".<br/>\n");
				$node->renderAfter($out, $mediator);$j++;

				if($node->getSibling()){
//					echo("have sibling..");
					$node = & $node->getSibling();
					$flg_pre = 1;
				}
				else{
//					echo("no sibling..");
//					$node->trace();
					$node = & $node->getParent();
//					decho("parent..".$i.".".$j.".".$node->_tag_name.".".$node->_id.".<br/>\n");
					$flg_pre = 0;
				}
			}
		}
//		decho("end..".$i.".".$j."...<br/>\n");
	}


	function setChildTop(& $t)
	{
		if($this->isSame($t)){
			die("runtime error :cant set child top same object, $t!!!<br/>");
			return;
		}
		$this->_child_top = & $t;
	}
	function setChildLast(& $t)
	{
		if($this->isSame($t)){
			die("runtime error :cant set child last same object, $t!!!<br/>");
			return;
		}
		$this->_child_last = & $t;
	}
	function setParent(& $t)
	{
		if($this->isSame($t)){
			die("runtime error :cant set parent same object, $t!!!<br/>");
			return;
		}
		$this->_parent = & $t;
	}
	function setSibling(& $t)
	{
		if($this->isSame($t)){
//			$t->trace();
//			decho("bad..".$t->_tag_name.".".$t->_id.".<br/>\n");
			die("runtime error :cant set sibling  same object, $t!!!<br/>");
			return;
		}
		$this->_sibling = & $t;
	}



	function tagPre()
	{
		$str = "<" . $this->_tag_name . $this->getParamString() . ">\n";
		return $str;
	}

	function tagAfter(){return "</".$this->_tag_name.">\n";}
	
	
	function trace($ofs = 0){
		echo("<br/>\n");
		echo("■");
		echo str_repeat("----", $ofs);
/*
		parent::trace();
		$arr = get_object_vars($this);
		if(array_key_exists("_string", $arr)){
			echo($this->_string."  ");
		}
*/
		echo("p-:" . $this->_parent->_tag_name . " me-:". $this->_tag_name . " si:" . $this->_sibling->_tag_name." ct:".$this->_child_top->_tag_name." cl:".$this->_child_last->_tag_name."<br/>\n");
//		$this->_child_last->trace();
	}
}

//=================================================================================================
//=================================================================================================

class TagSingle extends Tag
{
	function TagSingle($str, $arr = NULL)
	{
		$this->Tag($str, $arr);
	}
	function tagPre()
	{
		return "<" . $this->_tag_name . $this->getParamString() . "/>\n";
	}
	function tagAfter(){return "";}
}

/**
 * string 用クラス...
 * 
 * 
 * @see     : 
 * 
 * @version : 1.0.0
 * 
 */

//よくわかんないけど,TagStringという名前でクラスが作れなかった,,,詳細不明...
class TagStr extends Tag
{
	var $_string;
	function TagStr($str)
	{
		$this->Tag("str");
		$this->_string = $str;
//		echo("tag string, Init : " . $str . "<br/>");
	}
	function & getString(){return $this->_string;}
	function tagPre(){return $this->getString();}
	function tagAfter(){return "";}
}

//<tag>$string</tag> となるようなタグ..
class TagStrBase extends Tag
{
	var $_string;
	function TagStrBase($name, $class, $str)
	{
		$this->Tag($name, array("class"=>$class));
		$this->_string = $str;
	}
	function & getString(){return $this->_string;}
	function tagPre(){return parent::tagPre() . $this->getString();}
}




/**
 * 
 * 
 * 
 * @see     : 
 * 
 * @version : 1.0.0
 * 
 */
class TagComment extends Tag
{
	var $_string;
	function TagComment($str)
	{
		$this->Tag("com");
		$this->_string = $str;
	}
	function tagPre(){return "<!-- ".$this->_string." -->\n";}
	function tagAfter(){return "";}
}


class TagAName extends Tag
{
	function TagAName($class, $name)
	{
		$this->Tag("a", array("class"=>$class,
							  "name"=>$name));
	}
}


class TagAHref extends TagStrBase
{
	var $_string;
	function TagAHref($class, $name, $str)
	{
		$this->TagStrBase("a", $class, $str);
		$this->addTagParam("href", $name);
		$this->_string = $str;
	}
}



class TagContent extends TagStrBase
{
	var $_num;
	var $_meme;
	function TagContent($meme, $str, $num, $num1,$num2,$num3)
	{
		$this->_num = $num;
		$this->_meme = $meme;
		$numstr = "_".$num1."_".$num2."_".$num3;
		$s = "<a name =\"_$meme".$numstr."\"></a>";
		$s.= "<a href =\"#$meme".$numstr."\">".$str."</a>";
		$this->TagStrBase('li', NULL, $s);
//		echo("TagContent $str, ".$this->_num."...<br/>");
	}
	
	function add(& $tag)
	{
//		echo("TagContent::Add ".$this->_string." ".$this->_num."...<br/>");
		$num = $this->_num + 1;
		$ul = new Tag('ul',array("class" => 'list'.$num));
		$ul->add($tag);
		$this->addSimple($ul);
	}
}



/**
 * contents表示用tag...
 * 
 * 
 * @see     : 
 * 
 * @version : 1.0.0
 * 
 */
class TagContents extends Tag
{
	var $c_cnt_1;
	var $c_cnt_2;
	var $c_cnt_3;

	var $_child1;
	var $_child2;
	var $_meme_name;

	
	function TagContents($meme_name)
	{
		$this->Tag("ul",array("class" =>"list1"));
		
		$this->c_cnt_1 = 0;//1;
		$this->c_cnt_2 = 0;
		$this->c_cnt_3 = 0;
		$this->_child1 = NULL;
		$this->_child2 = NULL;
		$this->_meme_name = $meme_name;
	}


	function getCnt1() {return $this->c_cnt_1;}
	function getCnt2() {return $this->c_cnt_2;}
	function getCnt3() {return $this->c_cnt_3;}
	
	function & getChild1()
	{
		$child = & $this->_child1;
		if(!$child){
			$this->c_cnt_1++;
			//いきなり2段階目のコンテンツを作られたが、ダミーを挟んでかわす...
			$tag = new TagContent($this->_meme_name, "dummy1", 1, $this->c_cnt_1,0,0);
			$this->add($tag);
			$this->_child1 = & $tag;
		}
		return $this->_child1;
	}

	function & getChild2()
	{
		$child2 = & $this->_child2;
		if(!$child2){
			$child = &	$this->getChild1();
			$this->c_cnt_2++;
			//いきなり三段階目のコンテンツを作られたが、ダミーを挟んでかわす...
			$tag = new TagContent($this->_meme_name, "dummy2", 2, $this->c_cnt_1,$this->c_cnt_2,0);
			$child->add($tag);
			$this->_child2 = & $tag;
		}
		return $this->_child2;
	}



	function add1($str)
	{
		$this->c_cnt_1++;
		$this->c_cnt_2 = 0;
		$this->c_cnt_3 = 0;
		
		$tag = new TagContent($this->_meme_name, $str, 1, $this->c_cnt_1,0,0);

		$this->add($tag);
		$this->_child1	= & $tag;
		unset($this->_child2);
		$this->_child2	= NULL;
	}

	function & add2($str)
	{
		$this->c_cnt_2++;
		$this->c_cnt_3 = 0;
		$tag = new TagContent($this->_meme_name, $str, 2, $this->c_cnt_1, $this->c_cnt_2,0);
		$child1 = &	$this->getChild1();
		$child1->add($tag);
		$this->_child2	= & $tag;
	}
	
	function & add3($str)
	{
		$this->c_cnt_3++;
		$tag = new TagContent($this->_meme_name, $str, 3, $this->c_cnt_1, $this->c_cnt_2, $this->c_cnt_3);
		$child2 = &	$this->getChild2();
		$child2->add($tag);
	}

	
	
	function & addContent($str, $num)
	{
		switch($num){
		case 1:
			$this->add1($str);
			break;
		case 2:
			$this->add2($str);
			break;
		case 3:
			$this->add3($str);
			break;
		}

	}
}

class TagOlBase extends Tag
{
	var $_cnt_1;
	var $_cnt_2;
	var $_cnt_3;
	var $_depth;
	function TagOlBase($n1 = 1, $n2 = 1, $n3 = 1)
	{
		$this->Tag("ol",array("class"=>"list1"));
		$this->_depth = 1;
		$this->_cnt_1 = $n1;
		$this->_cnt_2 = $n2;
		$this->_cnt_3 = $n3;
	}
	
	function & addOl($str, $num)
	{
		switch($num){
		case 1:
			$tag = new TagStrBase("li","",$str);
//			$tag->addTagParam("value", "hanage".$this->_cnt_1);
			$this->add($tag);//rootに足す..
			$this->_cnt_1++;
			$this->_cnt_2 = 1;
			$this->_cnt_3 = 1;
			break;
		case 2:
			//同じ階層なのでliで良い..
			switch($this->_depth){
			case 2:
			case 3:
				$tag = new TagStrBase("li","",$str);
//				$tag->addTagParam("value", $this->_cnt_2);
				$child = &	$this->getChildLast();
				$child->add($tag);
				break;
			case 1:
//				echo("hoge");
				$ol = new Tag("ol");
				$tag = new TagStrBase("li","",$str);
//				$tag->addTagParam("value", $this->_cnt_2);
				$ol->add($tag);
				$this->add($ol);//rootに足す..
				break;
			}
			$this->_cnt_2++;
			$this->_cnt_3 = 1;
			break;
		case 3:
			switch($this->_depth){
			case 1:
				$dummy = new Tag("ol");
				$this->add($dummy);//rootに足す..
			case 2:
				$child = &	$this->getChildLast();
				$ol = new Tag("ol");
				$tag = new TagStrBase("li","",$str);
//				$tag->addTagParam("value", $this->_cnt_3);
				$ol->add($tag);
				$child->add($ol);
				break;
			case 3:
				$tag = new TagStrBase("li","",$str);
//				$tag->addTagParam("value", $this->_cnt_3);
				$child = &	$this->getChildLast();
				$child_child = &	$child->getChildLast();
				$child_child->add($tag);
				break;
			}
			$this->_cnt_3++;
			break;
		}

		$this->_depth = $num;
	}
	
}

class TagUlBase extends Tag
{
	var $_depth;
	function TagUlBase()
	{
		$this->Tag("ul",array("class"=>"list1"));
		$this->_depth = 1;
	}
	
	function & addUl($str, $num)
	{
		switch($num){
		case 1:
			$tag = new TagStrBase("li","",$str);
			$this->add($tag);//rootに足す..
			break;
			
		case 2:
			//同じ階層なのでliで良い..
			switch($this->_depth){
			case 2:
			case 3:
				$tag = new TagStrBase("li","",$str);
				$child = &	$this->getChildLast();
				$child->add($tag);
				break;
			case 1:
//				echo("hoge");
				$ul = new Tag("ul");
				$tag = new TagStrBase("li","",$str);
				$ul->add($tag);
				$this->add($ul);//rootに足す..
				break;
			}
			break;
		case 3:
			switch($this->_depth){
			case 1:
				$dummy = new Tag("ul");
				$this->add($dummy);//rootに足す..
			case 2:
				$child = &	$this->getChildLast();
				$ul = new Tag("ul");
				$tag = new TagStrBase("li","",$str);
				$ul->add($tag);
				$child->add($ul);
				break;
			case 3:
				$tag = new TagStrBase("li","",$str);
				$child = &	$this->getChildLast();
				$child_child = &	$child->getChildLast();
				$child_child->add($tag);
				break;
			}
			break;
		}

		$this->_depth = $num;
	}
	
}


?>