<?php
require_once("phpunit/phpunit.php");
require_once("diff.php");



class DiffTest extends TestCase
{
	function DiffTest($name)
	{
        $this->TestCase($name);
	}

    function setUp()
	{
	
	}
	function testDiffAddLines()
	{
		$arr = array("ya-","hu-","mu-");
		$diff = diffAddLines($arr);
		$this->assertEquals($diff, "+ya-\n+hu-\n+mu-\n");
	}
	function testDiffDeleteLines()
	{
		$arr = array("ya-","hu-","mu-");
		$diff = diffDeleteLines($arr);
		$this->assertEquals($diff, "-ya-\n-hu-\n-mu-\n");
	}

	function testDiffApply()
	{
		$arr = array("1","2","3","4");
//		$diff = "+ふが0\n+ふが\n1もどき\n2もどき\n3もどき\n4もどき\n";
//		$diff = "+ふが\n\n\n\n\n";
		$diff = "\n-はなくそ\n+2もどき\n+2.5\n\n\n";

//		$arr = array("1");
//		$diff = "+ほげ\n\n";
		$ret = diffApply($arr, $diff);
		$huga = join("\n", $ret);
		if(count($ret)){
			$huga .= "\n";	//joinだと最後のトコは\n入らないから..
		}
		$this->assertEquals($huga, "1\n2もどき\n2.5\n3\n4\n");
	}

	function testDiffSameLines()
	{
		$arr = array("1", "2", "3");
		$diff = diffSameLines($arr);
		$this->assertEquals($diff, "\n\n\n");
	}

	function testgetDiff()
	{
		$a = array("1","2","3");
		$b = array("0","2","3");
		$diff = getDiff($a, $b);
		$this->assertEquals($diff, "-1\n+0\n\n\n");
	}
	function testgetDiff_add()
	{
		$a = array("2","3");
		$b = array("0","2","3");
		$diff = getDiff($a, $b);
		$this->assertEquals($diff, "+0\n\n\n");
	}
	function testgetDiff_sub()
	{
		$a = array("1","2","3");
		$b = array("2","3");
		$diff = getDiff($a, $b);
		$this->assertEquals($diff, "-1\n\n\n");
	}


	function testgetDiff2()
	{
		$a =
"
1
2
3
";
		$b =
"
0
2
3
";
        $arr_a = explode("\n", $a);
        $arr_b = explode("\n", $b);
		$diff = getDiff($arr_a, $arr_b);
		$this->assertEquals($diff, "\n-1\n+0\n\n\n\n");
	}
	function testgetDiff3()
	{
		$a =
"
1
2
3
4
5
6
";
		$b =
"
4
5
6
1
2
3
";
        $arr_a = explode("\n", $a);
        $arr_b = explode("\n", $b);
		$diff = getDiff($arr_a, $arr_b);
		echo($diff);
		$this->assertEquals($diff, "\n-1\n+0\n\n\n\n");
	}

	



}
	
$ts = new TestSuite("DiffTest");
$tr = new TestRunner();
$tr->run($ts);

	
?>