<?php
require_once("phpunit/phpunit.php");
require_once("meme.php");
require_once("func.php");
require_once("wiki.php");

$meme_name_test = "memetest";
$meme_name_save = "memesave";
$meme_name_parse= "memeparse";


//$meme_test_global;
$wiki = new Wiki();

class MemeTest extends TestCase
	//friend Meme
{
	var $_name;
	var $_meme;	//meme.
	var $_meme_save;
	var $_meme_parse;

//	var $_wiki;
    function MemeTest($name)
    {
        $this->TestCase($name);
    }
	
    function setUp()
	{
		global $meme_name_test, $meme_name_save, $meme_name_parse, $wiki;
		
		$this->_name = $meme_name_test;
		$this->_meme = & $wiki->getMeme($this->_name);

//		$this->assert($this->_meme_save->isLoaded(), "dont set loaded flag..");

		
	}


	function testSetLines()
	{
		$meme1 = new Meme("for string");
		$meme2 = new Meme("for array");
		
		$str1 = "this\nis\nstrings.\n";
		$str2 = array("this","is","array.");

		$meme1->setLines($str1);
		$meme2->setLines($str2);

		$med1 = $meme1->getParser();
		$med2 = $meme2->getParser();
		$this->assertEquals("this",$med1->_lines[0]);
		$this->assertEquals("is",$med1->_lines[1]);
		$this->assertEquals("strings.",$med1->_lines[2]);
		$this->assertEquals("this",$med2->_lines[0]);
		$this->assertEquals("is",$med2->_lines[1]);
		$this->assertEquals("array.",$med2->_lines[2]);
		$this->assert(3 == count($med1->_lines),"setLines(strings) array size illegal?");
		$this->assert(3 == count($med2->_lines),"setLines(array) array size illegal?");
	}

	function testLoad()
	{
		
		$encoded = $this->_meme->getMemeName($this->_name);
//		$encoded = Meme::getMemeName($this->_name);
//		echo("encoded name is $encoded");

		echo("load:".$this->_meme->getFileName());

		$flg = $this->_meme->load();
		$this->assert($flg, "load..");
//		$this->_meme->trace();
		$this->assert($this->_meme->isLoaded(), "dont set loaded flag..");
//		$this->_meme->trace();
	}


	function testparse()
	{
		global $meme_name_test, $meme_name_save, $meme_name_parse, $wiki;
		hr();
		hr();
		//for parse test..
		$meme = & $wiki->getMeme($meme_name_parse);
		hr();
		hr();
		$meme->load();
//		$meme->trace();
//		hr();
//		hr();
//		$wiki->parseMeme($meme);
//		$med = $meme->getParser();
	}

	function testEncodeDecode()
    {
		$i = 0;
		$j = 0;
		for($i=0;$j < 100;$j++){
			$name = "";
			for($i=0;$i < 30;$i++){
				//^OɎg镶͂Ȃ?
				$a = rand (32,126);
				$name .= chr($a);
			}
			$encoded = $this->_meme->getMemeName($name);
			$decoded = $this->_meme->getOriginalName($encoded);
			$this->assertEquals($name, $decoded);
		}
    }

	
	function testNofile()
	{
		$meme = new FileMeme("not_exist_file_name");
		$this->assert(!$meme->load(), "can read no exist file..");
	}



	
	function testSave()
	{
		global $meme_name_test, $meme_name_save, $meme_name_parse, $wiki;
		//for save test..
		$this->_meme_save = & $wiki->getMeme($meme_name_save);
		$this->assert($this->_meme_save->load(), "load....");
//		$this->_meme_save->load();
//		hr();
//		hr();
//		$this->_meme_save->trace();
//		hr();
//		hr();
		$this->assert($this->_meme_save->isLoaded(), "dont set loaded flag..");
		$this->assertEquals($this->_meme_save->_encoded_name, "6d656d6573617665");
		$this->assert($this->_meme_save->save(), "save....");
	}

	function testList()
	{
		$meme = new FileMeme("not_exist_file_name");
		$list  = $meme->getLineArray();
		foreach($list as $key=> $var){
			echo("$key is $var<br/>");
		}
	}
/*
	function testParse()
	{
		global $wiki;
		hr();
		$this->_meme_parse->trace();
		hr();
		hr();
		$wiki->parseMeme($this->_meme_parse);
		hr();
		$this->_meme_parse->trace();
//		$this->_meme_parse->parse();
	}
	*/
}



$ts = new TestSuite("MemeTest");
$tr = new TestRunner();
$tr->run($ts);

?>