<?php

require_once("phpunit/phpunit.php");
require_once("meme.php");
require_once("parser.php");
require_once("wiki.php");


$wiki = new Wiki();
$meme_name_parse= "memeparse";

class ParserTest extends TestCase
{
//	var $_meme;
	var $_parser;
	function  ParserTest($name)
    {
        $this->TestCase($name);
    }
	
    function setUp()
	{
		$this->_parser = new Parser();
	}

	function testParse()
	{
//		var $meme = new Meme();
		$med = new ParseMediator();

		$arr = array(
			"[\n",	
			"ق\n",
			"قق\n",
			"ققق\n",
			);
		$put = "<wikibody>\n[<br/>\nق<br/>\nقق<br/>\nققق<br/>\n</wikibody>\n";
		$med->setLines($arr);
		$this->_parser->parse($med);
		$out ="";
		$med->_body->renderAll($out, $med);
		echo("$out");

		$meme_out = Meme::getMemeName($out);
		$meme_put = Meme::getMemeName($put);

		$this->assertEquals($out, $put);
		$this->assertEquals($meme_out, $meme_put);
	}


	function testParseComment()
	{
		$med = new ParseMediator();
		$arr = array(
			"[\n",	
			"//ق\n",
			"قق\n",
			"ققق\n",
			);
		$put = "<wikibody>\n[<br/>\n<!-- ق -->\nقق<br/>\nققق<br/>\n</wikibody>\n";
		$med->setLines($arr);
		$this->_parser->parse($med);
		$out ="";
		$med->_body->renderAll($out, $med);
		echo("$out");

		$meme_out = Meme::getMemeName($out);
		$meme_put = Meme::getMemeName($put);

		$this->assertEquals($out, $put);
		$this->assertEquals($meme_out, $meme_put);
		
	}

	function testParseHr()
	{
		$med = new ParseMediator();
		$arr = array(
			"[\n",	
			"----\n",
			"قق\n",
			"ققق\n",
			);
		$put = "<wikibody>\n[<br/>\n<hr/>\nقق<br/>\nققق<br/>\n</wikibody>\n";
		$med->setLines($arr);
		$this->_parser->parse($med);
		$out ="";
		$med->_body->renderAll($out, $med);
		echo("$out");

		$meme_out = Meme::getMemeName($out);
		$meme_put = Meme::getMemeName($put);

		$this->assertEquals($out, $put);
		$this->assertEquals($meme_out, $meme_put);
		
	}
}



$ts = new TestSuite("ParserTest");
$tr = new TestRunner();
$tr->run($ts);
	
	
?>