<?php
require_once("phpunit/phpunit.php");
require_once('func.php');
require_once("tag.php");
require_once("meme.php");

// マイクロでシードを設定する
function make_seed() {
    list($usec, $sec) = explode(' ', microtime());
    return (float) $sec + ((float) $usec * 100000);
}
srand(make_seed());



	
/**
 * tagクラスのテストケース
 * TestCartクラスを継承して作成する
 */
class TagTest extends TestCase 
{
    var $_tag;
	var $_name;
    function TagTest($name)
    {
        $this->TestCase($name);
    }

    function setUp()
    {
		$i = 0;
		
		$this->_name= array();
		$this->_tag = array();
		
		for($j=0;$j < 100;$j++){
			$this->_name[$j] = "";
			for($i=0;$i < 30;$i++){
				//タグに使える文字列はなんだ?
				$a = rand (32,126);
				$this->_name[$j] .= chr($a);
			}
			$this->_tag[$j] = new Tag($this->_name[$j]);
//			$this->_tag[0]->add($this->_tag[$j]);
		}
    }

    function testTagName(){
		for($j=0;$j < 100;$j++){
			$this->assertEquals("<".$this->_name[$j].">\n", $this->_tag[$j]->tagPre());
		}
//		$this->assert(0,"hoads"); <- 失敗...
    }
	function testRenderPre()
	{
		$tag = new Tag("test");
		$out="";
		$mediator = "";

		$tag->renderPre($out, $mediator);
		$this->assertEquals("<test>\n", $out);
	}


	function testRenderAfter()
	{
		$tag = new Tag("test");
		$out="";
		$mediator = "";
		$tag->renderAfter($out, $mediator);
		$this->assertEquals("</test>\n", $out);
	}



	
	function testParent()
	{
		$out="";
		$tag = new Tag("test");
		$tag2 = new Tag("child");
		$tag2->setParent($tag);

		//どうしてこいつはrecursivといわれない・?
		$this->assertEquals($tag,$tag2->getParent());
		hr();
	}


	
	function testChild()
	{
		$tag = new Tag("test");
		$tag2 = new Tag("child_top");
		$tag3 = new Tag("child_last");
		$tag->setChildTop($tag2);
		$tag->setChildLast($tag3);
		$this->assertEquals($tag2,$tag->getChildTop());
		$this->assertEquals($tag3,$tag->getChildLast());
/*		
		$tag->add($tag2);
		$tag_child = & $tag->getChildTop();
		$this->assert($tag_child,"child is null!?");
//		$tag_child->trace();
//		$tag2->trace();

		//もうちょっと正しい評価が欲しい,全部arrayたどったりしてequalを取ってる..
		//$tag_child == $tag2,とやると、再帰的にたどっていって帰って来ない...

		$tag_parent = & $tag_child->getParent();
		$tag_parent2 = & $tag2->getParent();
		$this->assert($tag_parent->getTagName() == $tag_parent2->getTagName(), "not equql?");
		$this->assertEquals($tag_child->_parent,$tag2);
		$tag_child->trace();
		$tag2->trace();
//		$this->assert($tag_child == $tag2, "not equql?");
*/
		
	}
	function testSibling(){
		$tag = new Tag("test");
		$tag2 = new Tag("sibling");
		$tag->setSibling($tag2);
		$this->assertEquals($tag2,$tag->getSibling());
		hr();
	}
	function testManySibling(){
		$tag = new Tag("parent");
		$tag1 = new Tag("sibling1");
		$tag2 = new Tag("sibling2");
		$tag3 = new Tag("sibling3");
		$tag4 = new Tag("sibling4");
		$tag->setSibling($tag1);
		$tag1->setSibling($tag2);
		$tag2->setSibling($tag3);
		$tag3->setSibling($tag4);
		$this->assertEquals($tag1,$tag->getSibling());
//		$tag->trace();
//		$tag1->trace();
//		$tag2->trace();
//		$tag3->trace();
//		$tag4->trace();
		hr();
	}


	function testChildSibling(){
		$tag = new Tag("test");
		$hoge= & $tag;
		$hoge2 = $tag;
		$tag2 = new Tag("sibling");
		$tag->setSibling($tag2);

		if($tag2 != $tag->getSibling()){
			echo("aweo)");
		}
		
		$this->assertEquals($tag2,$tag->getSibling());
		$tag2->setChildTop($tag);
//		$tag->trace();
		$top = & $tag2->getChildTop();
//		$top->trace();
//		$tag2->trace();
		$tag2->isSame($hoge);
//		$tag->trace();
//		$tag2->trace();
//		$this->assertEquals($tag->isSame($hoge),"same ....");
		hr();
	}
	
	function testRenderAll()
	{
		hr();
		$out="";
		$mediator = "";
		$tag = new Tag("renderall");
		$tag->renderAll($out, $mediator);
		$this->assertEquals("<renderall>\n</renderall>\n", $out);
		hr();
	}
/*	
	function testAddOwn()
	{
		$tag = new Tag("pre");
		$tag->add($tag);	//自分は足せない..
		$this->assert(!$tag->getChildTop(), "can add own");
	}
*/
/*
	function testAddLocal()
	{
		hr();
		$out="";
		$tag = new Tag("test");
		$tag2 = new Tag("child");
		$tag3 = new Tag("grandson");
		$tag4 = new Tag("child2");
		$tag5 = new Tag("child3");
		$tag->add($tag2);
		$tag->add($tag4);
		$tag->add($tag5);
		$tag2->add($tag3);
		$tag->trace();
		$tag->renderAll($out);
//		$this->assertEquals("<test>\n<child>\n<grandson>\n</grandson>\n</child>\n<child2>\n</child2>\n<child3>\n</child3>\n</test>\n", $out);
//XS		hr();
	}
*/
	function testAddTmp()
	{
		$out="";
		$mediator = "";
		$tag = new Tag("test");
		$tag->add(new Tag("tmp"));
		$tag->trace();
		hr();
		hr();
		hr();
		hr();
		$tag->renderAll($out,$mediator);
		$this->assertEquals("<test>\n<tmp>\n</tmp>\n</test>\n", $out);
	}


	function testAddString()
	{
		$out="";
		$tag = new Tag("test");
		$str1 = "string";
		$str2 = "string2";
		$tag->add($str1);
		$child = $tag->getChildLast();
		$this->assertEquals($child->_string, $str1);
		$tag->add($str2);
		$child = $tag->getChildLast();
		$this->assertEquals($child->_string, $str2);
//		$this->assertEquals($tag->_string, $str1.$str2);
	}

	
	function testAddStringAndTag()
	{
		$out="";
		$mediator = "";
		$tag = new Tag("test");
		$str1 = "string";
		$str2 = "string2";
		$tag->add($str1);
		$tag->add($str2);
		$tag->add(new Tag("tmp"));
//		$tag->trace();
		$tag->renderAll($out, $mediator);
//		$this->assertEquals($tag->_string, $str1.$str2);
		$this->assertEquals("<test>\nstringstring2<tmp>\n</tmp>\n</test>\n", $out);
//		$this->assertEquals("<test>\n".$str1.$str2."\n<tmp>\n</tmp>\n</test>\n", $out);
	}
	/*
	function testAddArray()
	{
		hr();
		$out="";
		$mediator = "";
		$tag = new Tag("test");
		$tag2 = new Tag("child");
		$tag3 = new Tag("grandson");
		$tag4 = new Tag("child2");
		$tag5 = new Tag("child3");
		$tag6 = new Tag("grandson2");
		$tag2->add($tag3);
		$tag->addArray(array(& $tag2,& $tag4,& $tag5));
		$tag2->add($tag6);
//		$tag->trace();
		$tag->renderAll($out,$mediator);
		$this->assertEquals("<test>\n<child>\n<grandson>\n</grandson>\n<grandson2>\n</grandson2>\n</child>\n<child2>\n</child2>\n<child3>\n</child3>\n</test>\n", $out);
		hr();
	}
*/	
	function testTagStr()
	{
		$out="";
		$mediator = "";
		$tag = new TagStr("string");
		$tag2 = new Tag("test");
		$tag3 = new TagStr("string2");
		$tag2->add($tag);
		$tag2->add($tag3);
		$tag2->renderAll($out, $mediator);
		$this->assertEquals("<test>\nstringstring2</test>\n", $out);
		//	$this->assertEquals("<test>\nstring\nstring2\n</test>\n", $out);
		hr();
	}

	function testTagComment()
	{
		$out="";
		$mediator = "";
		$tag = new TagComment("string");
		$tag2 = new Tag("test");
		$tag3 = new TagComment("string2");
		$tag2->add($tag);
		$tag2->add($tag3);
		$tag2->renderAll($out, $mediator);
		$this->assertEquals("<test>\n<!-- string -->\n<!-- string2 -->\n</test>\n", $out);
		hr();
	}


	
	function testAddSame()
	{
		$out="";
		$mediator = "";
		$tag = new Tag("test");
		$tag2 = new Tag("tmp");
		$tag3 = new Tag("tmp");
		$tag->add(new Tag("tmp"));
		$tag->add(new Tag("tmp"));
		$tag->add($tag2);
		$tag->add($tag3);
		$tag->trace();
		$tag2->trace();
		$tag3->trace();
		$tag->renderAll($out, $mediator);
		echo($out);
		$this->assertEquals("<test>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n</test>\n", $out);
	}



	function testA()
	{
		$out = "";
		$mediator = "";

		$numstr = "1_1_1";
		$str = "string";
		$an = new TagAName(NULL, "contents".$numstr);
		$ah = new TagAHref(NULL, "#content".$numstr,$str);
		$li = new Tag("li");

		$li->add($an);
		$li->add($ah);

		$li->renderAll($out, $mediator);
		$this->assertEquals(
			"<li>\n<a name=\"contents1_1_1\">\n</a>\n<a href=\"#content1_1_1\">\nstring</a>\n</li>\n"
//			"<test>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n</test>\n"
			,$out);
		
	}
	function testContent()
	{
		$tagx= new TagContent("contenthoge",1,1,1,1);

		$out = "";
		$mediator = "";
		$tagx->renderAll($out, $mediator);
		echo($out);

		$tagx->trace();
		$this->assertEquals(
			"<li>\n<a name =\"contents_1_1_1\"></a><a href =\"#content_1_1_1\">contenthoge</a></li>\n"
//			"<test>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n</test>\n"
			, $out);

	}
	function testContent2()
	{
		$tag1= new TagContent("contenthoge1",1,1,1,1);
		$tag2= new TagContent("contenthoge2",1,1,1,1);
		$tagx= new Tag("test");

		$out = "";
		$mediator = "";

		$tagx->add($tag1);
		$tagx->add($tag2);
		$tagx->renderAll($out, $mediator);
		echo($out);
		$this->assertEquals(
			"<test>\n<li>\n<a name =\"contents_1_1_1\"></a><a href =\"#content_1_1_1\">contenthoge1</a></li>\n<li>\n<a name =\"contents_1_1_1\"></a><a href =\"#content_1_1_1\">contenthoge2</a></li>\n</test>\n", $out);
	}

	function testContent3()
	{
		$tag1= new TagContent("contenthoge",1,1,1,1);
		$tag2= new TagContent("contenthoge2",1,1,1,1);
		$tagx= new TagContents();

		$out = "";
		$mediator = "";

		$tagx->add($tag1);
		$tagx->add($tag2);
		$tagx->renderAll($out, $mediator);
		echo($out);
		$this->assertEquals(
			"<ul class=\"list1\">\n<li>\n<a name =\"contents_1_1_1\"></a><a href =\"#content_1_1_1\">contenthoge</a></li>\n<li>\n<a name =\"contents_1_1_1\"></a><a href =\"#content_1_1_1\">contenthoge2</a></li>\n</ul>\n"
//			"<test>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n<tmp>\n</tmp>\n</test>\n"
			, $out);
	}
	
	function testContents()
	{
		$str="*hoge";
		$tag = new Tag("hoge");
		$st = new TagStr("string");
		$tagx= new TagContents();
		$mediator = "";
		$tagx->addContent("cont1",1);
		$tagx->addContent("cont1.1",1);
		$tagx->addContent("cont2",2);
		$tagx->addContent("cont3",1);

		$tag->add($str);
		$tag->add($tagx);
		$tag->add($str);
		$tag->renderAll($out, $mediator);
		echo($out);
		$this->assertEquals(
			"<hoge>\n*hoge<ul class=\"list1\">\n<li>\n<a name =\"contents_1_0_0\"></a><a href =\"#content_1_0_0\">cont1</a></li>\n<li>\n<a name =\"contents_2_0_0\"></a><a href =\"#content_2_0_0\">cont1.1</a><ul class=\"list1\">\n<li>\n<a name =\"contents_2_1_0\"></a><a href =\"#content_2_1_0\">cont2</a></li>\n</ul>\n</li>\n<li>\n<a name =\"contents_3_0_0\"></a><a href =\"#content_3_0_0\">cont3</a></li>\n</ul>\n*hoge</hoge>\n"
			, $out);

	}


}

/**
 * 全てのテストを実行
 * TestSuiteクラスの引数には、TestCaseクラスのサブクラス名を指定する
 */
$ts = new TestSuite("TagTest");
$tr = new TestRunner();
$tr->run($ts);
?>