<?php
require_once("phpunit/phpunit.php");
define("INI_FILE","ini.php");

require_once('edit.php');
require_once("wiki.php");
require_once('func.php');

$wiki = 0;
class WikiTest extends TestCase
{
    function setUp()
	{
		global $wiki;
		$wiki = new Wiki();
		$wiki->decodeArg();
	}

	function testGetParser()
	{
		global $wiki;
		$parser = $wiki->getParser();
//		$this->assert(is_subclass_of($parser,"parser"), "parser is not parser??");
		$this->assert((get_class($parser)=="parser") || is_subclass_of($parser,"parser"), "parser is not parser??");
	}

	function testMeme()
	{
		global $wiki;
		$name = "memetest";
		$meme = $wiki->getMeme($name);
		$this->assert((get_class($meme)=="meme") || is_subclass_of($meme,"meme"), "meme is not meme??");
	}

	function testParseMediator()
	{
		global $wiki;
		$name = "memetest";
		$meme = $wiki->getMeme($name);
		$mediator = $meme->getParser($name);
		$this->assert((get_class($mediator)=="parsemediator") || is_subclass_of($mediator,"parsemediator"), "mediator is not subclass of mediator??");
		
	}
	


	function testViewPage()
	{
		global $wiki, $body;
		$put="<wikihead>\n</wikihead>\n<wikibody>\n<!-- コメント -->\n<hr/>\n</wikibody>\n<wikirelated>\n</wikirelated>\n<wikinote>\n</wikinote>\n";

		$name = "memetest";
		$meme = $wiki->getMeme($name);
//		$mediator = $meme->getParser($name);
		$out = "";
		$parser = & $wiki->getParser();
		$meme->parse($parser);
//		$mediator->renderAll($out);
		$wiki->viewPage($name);
		$body = $wiki->_body;
		hr();
		echo(Meme::getMemeName($body));
		echo($body);
		hr();
		echo($put);
		echo(Meme::getMemeName($put));
		hr();
//		$this->assertEquals($body, "");
		$this->assertEquals($body, $put);
//		echo($body);
	}

	

	function testEdit()
	{
		global $wiki, $body;
		$body = "";
		$put="<wikihead>\n</wikihead>\n<wikibody>\n<!-- コメント -->\n<hr/>\n</wikibody>\n<wikirelated>\n</wikirelated>\n<wikinote>\n</wikinote>\n";

		$name = "memetest";
		
		$wiki->editPage($name);
		$body = $wiki->_body;
		hr();
		echo($body);
		hr();
//		echo($put);
		hr();
//		$this->assertEquals($body, "");
//		$this->assertEquals($body, $put);
//		echo($body);
	}
	
	
	function testmain()
	{
		global $wiki;
		$wiki->main();
	}


	
/**
 * 全てのテストを実行
 * TestSuiteクラスの引数には、TestCaseクラスのサブクラス名を指定する
 */
}
$ts = new TestSuite("WikiTest");
$tr = new TestRunner();
$tr->run($ts);




?>