/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontUtil;

public class ContextClassLoaderObjectInputStream
extends ObjectInputStream {
    private final JasperReportsContext jasperReportsContext;

    public ContextClassLoaderObjectInputStream(JasperReportsContext jasperReportsContext, InputStream in) throws IOException {
        super(in);
        this.jasperReportsContext = jasperReportsContext;
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public ContextClassLoaderObjectInputStream(InputStream in) throws IOException {
        this(DefaultJasperReportsContext.getInstance(), in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                throw e;
            }
            String name = desc.getName();
            try {
                return Class.forName(name, false, contextClassLoader);
            }
            catch (ClassNotFoundException e2) {
                throw e;
            }
        }
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Font font;
        Font font2 = font = obj instanceof Font ? (Font)obj : null;
        if (font != null) {
            String fontName = font.getName();
            Font newFont = FontUtil.getInstance(this.jasperReportsContext).getAwtFontFromBundles(fontName, font.getStyle(), font.getSize(), null, true);
            if (newFont != null) {
                return newFont.deriveFont(font.getAttributes());
            }
        }
        return obj;
    }
}

