/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.ArrayList;
import java.util.List;
import org.idempiere.distributed.ITopicSubscriber;

public class TopicImpl<E>
implements org.idempiere.distributed.ITopic<E> {
    private ITopic<E> topic;
    private List<TopicSubscriberAdapter<E>> adapters;

    public TopicImpl(ITopic<E> topic) {
        this.topic = topic;
        this.adapters = new ArrayList<TopicSubscriberAdapter<E>>();
    }

    public String getName() {
        return this.topic.getName();
    }

    public void subscribe(ITopicSubscriber<E> subscriber) {
        TopicSubscriberAdapter<E> adapter = new TopicSubscriberAdapter<E>(subscriber);
        this.topic.addMessageListener(adapter);
        this.adapters.add(adapter);
    }

    public void unsubscribe(ITopicSubscriber<E> subscriber) {
        TopicSubscriberAdapter<E> found = null;
        for (TopicSubscriberAdapter<E> adapter : this.adapters) {
            if (adapter.subscriber != subscriber) continue;
            found = adapter;
            this.topic.removeMessageListener(adapter);
            break;
        }
        if (found != null) {
            this.adapters.remove(found);
        }
    }

    public void publish(E message) {
        this.topic.publish(message);
    }

    class TopicSubscriberAdapter<T>
    implements MessageListener<T> {
        protected ITopicSubscriber<T> subscriber;

        protected TopicSubscriberAdapter(ITopicSubscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        public void onMessage(Message<T> message) {
            this.subscriber.onMessage(message.getMessageObject());
        }
    }
}

