/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import org.adempiere.apps.graph.PerformanceDetail;
import org.adempiere.apps.graph.PerformanceIndicator;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MGoal;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ViewPI
extends CPanel
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = 8022906851004145960L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(ViewPI.class);
    private ConfirmPanel confirmPanel = new ConfirmPanel();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.fine("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.initPanel();
            CScrollPane scroll = new CScrollPane(this);
            this.m_frame.getContentPane().add((Component)scroll, "Center");
            this.confirmPanel.addActionListener(this);
            this.m_frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.sizeIt();
    }

    private void sizeIt() {
        this.m_frame.pack();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.removeAll();
    }

    private void initPanel() {
        BoxLayout layout = new BoxLayout(this, 3);
        MGoal[] goals = MGoal.getGoals((Properties)Env.getCtx());
        int i = 0;
        while (i < goals.length) {
            PerformanceIndicator pi = new PerformanceIndicator(goals[i]);
            pi.addActionListener(this);
            this.add(pi);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        } else if (e.getSource() instanceof PerformanceIndicator) {
            MGoal goal;
            PerformanceIndicator pi = (PerformanceIndicator)e.getSource();
            if (log.isLoggable(Level.INFO)) {
                log.info(pi.getName());
            }
            if ((goal = pi.getGoal()).getMeasure() != null) {
                new PerformanceDetail(goal);
            }
        }
    }
}

