/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.client;

import java.net.URI;
import org.adempiere.client.Application;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.db.CConnection;
import org.compiere.db.SecurityPrincipal;
import org.compiere.interfaces.Status;
import org.restlet.Context;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class StatusInterface
implements Status {
    private ClientResource createClientResource(URI uri) {
        Context context = this.getContext();
        ClientResource resource = new ClientResource(context, uri);
        resource.setChallengeResponse(this.createChallengeResponse());
        return resource;
    }

    private ChallengeResponse createChallengeResponse() {
        SecurityPrincipal principal = CConnection.get().getAppServerCredential();
        if (principal != null) {
            ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, principal.identity, principal.secret);
            return cr;
        }
        return null;
    }

    private Context getContext() {
        return Application.context;
    }

    public String getDateVersion() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/version/date", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getMainVersion() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/version/main", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getDbType() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/type", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getDbHost() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/host", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public int getDbPort() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/port", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return Integer.parseInt(response.getText());
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getDbName() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/name", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getConnectionURL() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/url", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getDbUid() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/uid", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getDbPwd() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/password", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String getFwHost() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/fwhost", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public int getFwPort() {
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/status/database/fwport", null, null);
            ClientResource resource = this.createClientResource(uri);
            Representation response = resource.get();
            return Integer.parseInt(response.getText());
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }
}

