/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.swing.CToggleButton;
import org.compiere.swing.ColorBlind;
import org.compiere.util.Ini;
import org.compiere.util.MiniBrowser;
import org.compiere.util.ValueNamePair;
import sun.awt.AppContext;

public class PLAFEditor
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6010229234801706748L;
    private static Logger log = Logger.getLogger(PLAFEditor.class.getName());
    private boolean m_setting = false;
    private boolean m_colorTest = false;
    static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    static Object[] s_columns = new Object[]{"-0-", "-1-", "-2-", "-3-", "-O-", "-l-"};
    static Object[][] s_data = new Object[][]{{"-00-", "-01-", "-02-", "-03-", "-0O-", "-0l-"}, {"-10-", "-11-", "-12-", "-13-", "-1O-", "-1l-"}, {"-20-", "-21-", "-22-", "-23-", "-2O-", "-2l-"}, {"-30-", "-31-", "-32-", "-33-", "-3O-", "-3l-"}, {"-O0-", "-O1-", "-O2-", "-O3-", "-OO-", "-Ol-"}, {"-l0-", "-l1-", "-l2-", "-l3-", "-lO-", "-ll-"}};
    static Object[] s_pos = new Object[]{"Top", "Left", "Bottom", "Right"};
    private CPanel mainPanel = new CPanel(new BorderLayout());
    private CPanel northPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private CButton bOK = AdempierePLAF.getOKButton();
    private CButton bCancel = AdempierePLAF.getCancelButton();
    private CButton bHelp = new CButton();
    private GridBagLayout northLayout = new GridBagLayout();
    private CLabel lfLabel = new CLabel();
    private CComboBox lfField = new CComboBox(AdempierePLAF.getPLAFs());
    private CLabel themeLabel = new CLabel();
    private CComboBox themeField = new CComboBox(AdempierePLAF.getThemes());
    private FlowLayout southLayout = new FlowLayout();
    private CButton rButton = new CButton();
    private CComboBox blindField = new CComboBox(ColorBlind.COLORBLIND_TYPE);
    private CLabel blindLabel = new CLabel();
    private BorderLayout mainLayout = new BorderLayout();
    private CTabbedPane example = new CTabbedPane();
    private CPanel jPanel1 = new CPanel();
    private TitledBorder exampleBorder;
    private CPanel jPanel2 = new CPanel();
    private JLabel jLabel1 = new JLabel();
    private JTextField jTextField1 = new JTextField();
    private JCheckBox jCheckBox1 = new JCheckBox();
    private JRadioButton jRadioButton1 = new JRadioButton();
    private CButton jButton1 = new CButton();
    private CToggleButton jToggleButton1 = new CToggleButton();
    private CComboBox jComboBox1 = new CComboBox(s_columns);
    private JTextArea jTextArea1 = new JTextArea();
    private JTextPane jTextPane1 = new JTextPane();
    private JEditorPane jEditorPane1 = new JEditorPane();
    private JPasswordField jPasswordField1 = new JPasswordField();
    private JList jList1 = new JList<Object>(s_columns);
    private JSplitPane jSplitPane1 = new JSplitPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTree jTree1 = new JTree();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTable jTable1 = new JTable(s_data, s_columns);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private CPanel jPanelFlat = new CPanel(new CompiereColor(new Color(255, 205, 255), true));
    private CPanel jPanelGradient = new CPanel(new CompiereColor(new Color(233, 210, 210), new Color(217, 210, 233)));
    private CPanel jPanelTexture = new CPanel(new CompiereColor(CompiereColor.class.getResource("vincent.jpg"), Color.lightGray, 0.7f));
    private CPanel jPanelLines = new CPanel(new CompiereColor(new Color(178, 181, 205), new Color(193, 193, 205), 1.0f, 5));
    private JButton jButtonFlat = new JButton();
    private CButton jButtonGardient = new CButton();
    private JButton jButtonTexture = new JButton();
    private CButton jButtonLines = new CButton();
    private JComboBox jComboBoxFlat = new JComboBox<Object>(s_pos);
    private JTextField jTextFieldFlat = new JTextField();
    private JLabel jLabelFlat = new JLabel();
    private CComboBox jComboBoxGradient = new CComboBox(s_pos);
    private CTextField jTextFieldGradient = new CTextField();
    private CLabel jLabelGradient = new CLabel();
    private JComboBox jComboBoxTexture = new JComboBox<Object>(s_pos);
    private JTextField jTextFieldTexture = new JTextField();
    private JLabel jLabelTexture = new JLabel();
    private CComboBox jComboBoxLines = new CComboBox(s_pos);
    private CTextField jTextFieldLines = new CTextField();
    private CLabel jLabelLines = new CLabel();
    private CCheckBox jCheckBoxLines = new CCheckBox();
    private JCheckBox jCheckBoxTexture = new JCheckBox();
    private CCheckBox jCheckBoxGradient = new CCheckBox();
    private JCheckBox jCheckBoxFlat = new JCheckBox();

    public PLAFEditor() {
        this.init(false);
    }

    public PLAFEditor(boolean showExample) {
        this.init(true);
    }

    public PLAFEditor(Dialog owner, boolean showExample) {
        super(owner, "", true);
        this.init(true);
    }

    public PLAFEditor(Frame owner, boolean showExample) {
        super(owner, "", true);
        this.init(true);
    }

    private void init(boolean showExample) {
        try {
            this.jbInit();
            this.dynInit();
            this.example.setVisible(showExample);
            this.blindLabel.setVisible(showExample);
            this.blindField.setVisible(showExample);
            AdempierePLAF.showCenterScreen(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setTitle(s_res.getString("LookAndFeelEditor"));
        this.mainPanel.setLayout(this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.jTextFieldFlat.setColumns(10);
        this.jTextFieldGradient.setColumns(10);
        this.jTextFieldTexture.setColumns(10);
        this.jTextFieldLines.setColumns(10);
        this.jCheckBoxLines.setText("jCheckBox");
        this.jCheckBoxTexture.setText("jCheckBox");
        this.jCheckBoxGradient.setText("jCheckBox");
        this.jCheckBoxFlat.setText("jCheckBox");
        this.jPanelGradient.setToolTipText("Indented Level 1");
        this.jPanelTexture.setToolTipText("Indented Level 2");
        this.jPanelLines.setToolTipText("Indented Level 1");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.lfLabel.setText(s_res.getString("LookAndFeel"));
        this.lfField.addActionListener(this);
        this.themeLabel.setText(s_res.getString("Theme"));
        this.themeField.addActionListener(this);
        this.rButton.setText(s_res.getString("Reset"));
        this.rButton.addActionListener(this);
        this.blindLabel.setText(s_res.getString("ColorBlind"));
        this.blindField.addActionListener(this);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bHelp.addActionListener(this);
        this.northPanel.setLayout(this.northLayout);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.exampleBorder = new TitledBorder(s_res.getString("Example"));
        this.example.setBorder(this.exampleBorder);
        this.jLabel1.setText("jLabel");
        this.jTextField1.setText("jTextField");
        this.jCheckBox1.setText("jCheckBox");
        this.jRadioButton1.setText("jRadioButton");
        this.jButton1.setText("jButton");
        this.jToggleButton1.setText("jToggleButton");
        this.jTextArea1.setText("jTextArea");
        this.jTextPane1.setText("jTextPane");
        this.jEditorPane1.setText("jEditorPane");
        this.jPasswordField1.setText("jPasswordField");
        this.jPanel2.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jScrollPane1.setPreferredSize(new Dimension(100, 200));
        this.jScrollPane2.setPreferredSize(new Dimension(100, 200));
        this.jButtonFlat.setText("Confirm");
        this.jButtonGardient.setText("Input");
        this.jButtonTexture.setText("Message");
        this.jButtonLines.setText("Error");
        this.jTextFieldFlat.setText("jTextField");
        this.jLabelFlat.setText("jLabel");
        this.jTextFieldGradient.setText("jTextField");
        this.jLabelGradient.setText("jLabel");
        this.jTextFieldTexture.setText("jTextField");
        this.jLabelTexture.setText("jLabel");
        this.jTextFieldLines.setText("jTextField");
        this.jLabelLines.setText("jLabel");
        this.mainPanel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.lfLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.lfField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.northPanel.add((Component)this.themeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.themeField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.northPanel.add((Component)this.rButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.blindLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.blindField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bCancel, null);
        this.southPanel.add((Component)this.bOK, null);
        this.mainPanel.add((Component)this.example, "Center");
        this.example.add((Component)this.jPanel1, "JPanel");
        this.jPanel1.add((Component)this.jTextPane1, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.2, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jEditorPane1, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.2, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jList1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.2, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jTextField1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jCheckBox1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel1.add((Component)this.jRadioButton1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.1, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jToggleButton1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.1, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jTextArea1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.2, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jComboBox1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jPasswordField1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.example.add((Component)this.jPanel2, "JPanel");
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jScrollPane1, "left");
        this.jSplitPane1.add((Component)this.jScrollPane2, "right");
        this.jPanelFlat.setName("FlatP");
        this.jPanelGradient.setName("GradientP");
        this.jPanelTexture.setName("TextureP");
        this.jPanelLines.setName("LineP");
        this.example.add((Component)this.jPanelFlat, "jPanel Flat");
        this.jPanelFlat.add((Component)this.jButtonFlat, null);
        this.jPanelFlat.add((Component)this.jComboBoxFlat, null);
        this.example.add((Component)this.jPanelGradient, "jPanel Gradient 1");
        this.jPanelGradient.add((Component)this.jButtonGardient, null);
        this.jPanelGradient.add((Component)this.jComboBoxGradient, null);
        this.jPanelGradient.add((Component)this.jLabelGradient, null);
        this.jPanelGradient.add((Component)this.jTextFieldGradient, null);
        this.example.add((Component)this.jPanelTexture, "jPanel Texture 2");
        this.jPanelTexture.add((Component)this.jButtonTexture, null);
        this.jPanelTexture.add((Component)this.jComboBoxTexture, null);
        this.jPanelTexture.add((Component)this.jLabelTexture, null);
        this.jPanelTexture.add((Component)this.jTextFieldTexture, null);
        this.example.add((Component)this.jPanelLines, "jPanel Lines 1");
        this.jPanelLines.add((Component)this.jButtonLines, null);
        this.jPanelLines.add((Component)this.jComboBoxLines, null);
        this.jPanelLines.add((Component)this.jLabelLines, null);
        this.jPanelLines.add((Component)this.jTextFieldLines, null);
        this.jScrollPane2.getViewport().add((Component)this.jTable1, null);
        this.jScrollPane1.getViewport().add((Component)this.jTree1, null);
        this.jPanelFlat.add((Component)this.jLabelFlat, null);
        this.jPanelFlat.add((Component)this.jTextFieldFlat, null);
        this.jPanelLines.add((Component)this.jCheckBoxLines, null);
        this.jPanelTexture.add((Component)this.jCheckBoxTexture, null);
        this.jPanelGradient.add((Component)this.jCheckBoxGradient, null);
        this.jPanelFlat.add((Component)this.jCheckBoxFlat, null);
    }

    private void dynInit() {
        this.setLFSelection();
        this.jPanelGradient.setTabLevel(1);
        this.jPanelTexture.setTabLevel(2);
        this.jPanelLines.setTabLevel(1);
        this.jComboBoxFlat.addActionListener(this);
        this.jComboBoxGradient.addActionListener(this);
        this.jComboBoxTexture.addActionListener(this);
        this.jComboBoxLines.addActionListener(this);
        this.jButton1.addActionListener(this);
        this.jButtonFlat.addActionListener(this);
        this.jButtonGardient.addActionListener(this);
        this.jButtonTexture.addActionListener(this);
        this.jButtonLines.addActionListener(this);
    }

    private void setLFSelection() {
        this.m_setting = true;
        ValueNamePair plaf = null;
        LookAndFeel lookFeel = UIManager.getLookAndFeel();
        String look = lookFeel.getClass().getName();
        int i = 0;
        while (i < AdempierePLAF.getPLAFs().length) {
            ValueNamePair vp = AdempierePLAF.getPLAFs()[i];
            if (vp.getValue().equals(look)) {
                plaf = vp;
                break;
            }
            ++i;
        }
        if (plaf != null) {
            this.lfField.setSelectedItem(plaf);
        }
        MetalTheme metalTheme = null;
        ValueNamePair theme = null;
        boolean metal = UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
        this.themeField.setModel((ComboBoxModel)new DefaultComboBoxModel<ValueNamePair>(AdempierePLAF.getThemes()));
        if (metal) {
            theme = null;
            AppContext context = AppContext.getAppContext();
            metalTheme = (MetalTheme)context.get("currentMetalTheme");
            if (metalTheme != null) {
                String lookTheme = metalTheme.getName();
                int i2 = 0;
                while (i2 < AdempierePLAF.getThemes().length) {
                    ValueNamePair vp = AdempierePLAF.getThemes()[i2];
                    if (vp.getName().equals(lookTheme)) {
                        theme = vp;
                        break;
                    }
                    ++i2;
                }
            }
            if (theme != null) {
                this.themeField.setSelectedItem(theme);
            }
        }
        this.m_setting = false;
        if (log.isLoggable(Level.INFO)) {
            log.info(lookFeel + " - " + metalTheme);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getSource() == this.bOK) {
            Ini.saveProperties((boolean)true);
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.bHelp) {
            new MiniBrowser("http://www.adempiere.com/wiki/index.php/LooksHelp");
        } else if (e.getSource() == this.lfField && !this.m_setting) {
            this.m_setting = true;
            AdempierePLAF.setPLAF((ValueNamePair)this.lfField.getSelectedItem(), null, true);
            AdempierePLAF.updateUI(this);
            this.setLFSelection();
            this.m_setting = false;
        } else if (e.getSource() == this.themeField && !this.m_setting) {
            Ini.setProperty((String)"UITheme", (String)this.themeField.getSelectedItem().toString());
            AdempierePLAF.setPLAF((ValueNamePair)this.lfField.getSelectedItem(), (ValueNamePair)this.themeField.getSelectedItem(), true);
            AdempierePLAF.updateUI(this);
        } else if (e.getSource() == this.rButton) {
            AdempierePLAF.reset();
            AdempierePLAF.updateUI(this);
            this.setLFSelection();
            ColorBlind.setColorType(0);
        } else if (e.getSource() == this.blindField) {
            int sel = this.blindField.getSelectedIndex();
            if (sel != ColorBlind.getColorType()) {
                if (!this.m_colorTest) {
                    this.m_colorTest = true;
                    int size = Toolkit.getDefaultToolkit().getColorModel().getPixelSize();
                    if (size < 24) {
                        JOptionPane.showMessageDialog(this, "Your environment has only a pixel size of " + size + ".\nTo see the effect, you need to have a pixel size of 24 (true color)", "Insufficient Color Capabilities", 0);
                    }
                }
                ColorBlind.setColorType(sel);
                AdempierePLAF.updateUI(this);
            }
        } else if (e.getSource() == this.jComboBoxFlat || e.getSource() == this.jComboBoxGradient || e.getSource() == this.jComboBoxTexture || e.getSource() == this.jComboBoxLines) {
            if (!this.m_setting) {
                this.m_setting = true;
                int index = ((JComboBox)e.getSource()).getSelectedIndex();
                this.example.setTabPlacement(index + 1);
                this.jComboBoxFlat.setSelectedIndex(index);
                this.jComboBoxGradient.setSelectedIndex(index);
                this.jComboBoxTexture.setSelectedIndex(index);
                this.jComboBoxLines.setSelectedIndex(index);
                this.m_setting = false;
            }
        } else if (e.getSource() == this.jButtonFlat) {
            JOptionPane.showConfirmDialog(this, "Confirm Dialog");
        } else if (e.getSource() == this.jButtonGardient) {
            JOptionPane.showInputDialog(this, (Object)"Input Dialog");
        } else if (e.getSource() == this.jButtonTexture) {
            JOptionPane.showMessageDialog(this, "Message Dialog");
        } else if (e.getSource() == this.jButtonLines) {
            JOptionPane.showMessageDialog(this, "Message Dialog - Error", "Error", 0);
        } else {
            e.getSource();
        }
        boolean metal = UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
        this.themeField.setEnabled(metal);
        this.themeLabel.setEnabled(metal);
        boolean adempiere = UIManager.getLookAndFeel() instanceof CompiereLookAndFeel;
        boolean enableBlind = adempiere && this.themeField.getSelectedItem() != null && this.themeField.getSelectedItem().toString().indexOf("Adempiere") != -1;
        this.blindField.setEnabled(enableBlind);
        this.blindLabel.setEnabled(enableBlind);
        if (e.getSource() != this.blindField && !enableBlind) {
            this.blindField.setSelectedIndex(0);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.isModal()) {
            System.exit(0);
        }
    }
}

