/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.adempiere.base.IGridTabExporter;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.grid.GridController;
import org.compiere.grid.VTabbedPane;
import org.compiere.model.GridTab;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.ExtensionFileFilter;

public class AExport {
    private CLogger log;
    private int m_WindowNo;
    private Map<String, IGridTabExporter> exporterMap;
    private Map<String, String> extensionMap;
    private APanel parent;

    public AExport(APanel parent) {
        block14: {
            this.log = CLogger.getCLogger(this.getClass());
            this.m_WindowNo = 0;
            this.exporterMap = null;
            this.extensionMap = null;
            this.m_WindowNo = parent.getWindowNo();
            this.exporterMap = new HashMap<String, IGridTabExporter>();
            this.extensionMap = new HashMap<String, String>();
            List exporterList = EquinoxExtensionLocator.instance().list(IGridTabExporter.class).getExtensions();
            for (IGridTabExporter exporter : exporterList) {
                String extension = exporter.getFileExtension();
                if (this.extensionMap.containsKey(extension)) continue;
                this.extensionMap.put(extension, exporter.getFileExtensionLabel());
                this.exporterMap.put(extension, exporter);
            }
            JFileChooser chooser = new JFileChooser();
            for (Map.Entry entry : this.extensionMap.entrySet()) {
                chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter((String)entry.getKey(), (String)entry.getValue()));
            }
            if (chooser.showSaveDialog(parent) != 0) {
                return;
            }
            File file = ExtensionFileFilter.getFile((File)chooser.getSelectedFile(), (FileFilter)chooser.getFileFilter());
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "", (Throwable)e);
                ADialog.error(this.m_WindowNo, parent, "FileCannotCreate", e.getLocalizedMessage());
                return;
            }
            String ext = file.getPath();
            if (ext.lastIndexOf(46) == -1) {
                ADialog.error(this.m_WindowNo, parent, "FileInvalidExtension");
                return;
            }
            ext = ext.substring(ext.lastIndexOf(46) + 1).toLowerCase();
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("File=" + file.getPath() + "; Type=" + ext);
            }
            parent.setCursor(Cursor.getPredefinedCursor(3));
            this.parent = parent;
            try {
                try {
                    if (this.extensionMap.containsKey(ext)) {
                        this.export(file, parent.getCurrentTab(), ext);
                        break block14;
                    }
                    ADialog.error(this.m_WindowNo, parent, "FileInvalidExtension");
                }
                catch (Exception e) {
                    ADialog.error(this.m_WindowNo, parent, "Error", e.getLocalizedMessage());
                    if (CLogMgt.isLevelFinest()) {
                        e.printStackTrace();
                    }
                    parent.setCursor(Cursor.getDefaultCursor());
                }
            }
            finally {
                parent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void export(File outFile, GridTab tab, String extension) throws Exception {
        boolean currentRowOnly = ADialog.ask(this.m_WindowNo, this.parent, "ExportCurrentRowOnly");
        IGridTabExporter exporter = this.exporterMap.get(extension);
        HashSet<String> tables = new HashSet<String>();
        ArrayList<GridTab> childs = new ArrayList<GridTab>();
        List includedList = tab.getIncludedTabs();
        for (GridTab included : includedList) {
            String tableName = included.getTableName();
            if (tables.contains(tableName)) continue;
            tables.add(tableName);
            childs.add(included);
        }
        int selected = this.parent.getSelectedTabIndex();
        VTabbedPane tabbedPane = (VTabbedPane)this.parent.getCurrentTabbedPane();
        int i = selected + 1;
        while (i < tabbedPane.getTabCount()) {
            GridController gc;
            Component c = tabbedPane.getComponentAt(i);
            if (c instanceof GridController && (gc = (GridController)c).getMTab() != null) {
                if (gc.getMTab().getTabLevel() <= tab.getTabLevel()) break;
                String tableName = gc.getMTab().getTableName();
                if (!tables.contains(tableName)) {
                    tables.add(tableName);
                    childs.add(gc.getMTab());
                }
            }
            ++i;
        }
        exporter.export(tab, childs, currentRowOnly, outFile, 0);
    }
}

