/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;

public class ALoginTest
extends CDialog
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 23728881908041435L;
    private String m_host;
    private String m_port;
    private String m_dbName;
    private String m_uid;
    private String m_pwd;
    private Thread m_worker;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel southPanel = new CPanel();
    private JButton bOK = new JButton();
    private JScrollPane infoPane = new JScrollPane();
    private JTextArea info = new JTextArea();
    private FlowLayout southLayout = new FlowLayout();

    public ALoginTest(Dialog frame, String host, String dbName, String port, String uid, String pwd) {
        super(frame, "Connect Test: " + host, true);
        this.m_host = host;
        this.m_dbName = dbName;
        this.m_port = port;
        this.m_uid = uid;
        this.m_pwd = pwd;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            this.inform("Internal Error = " + ex.getMessage());
        }
        try {
            this.m_worker = new Thread(this);
            this.m_worker.start();
        }
        catch (Exception e1) {
            this.inform("Internal Error = " + e1);
        }
        AEnv.showCenterScreen(this);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.mainPanel.setLayout(this.mainLayout);
        this.bOK.setText("Exit");
        this.bOK.addActionListener(this);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.infoPane.setPreferredSize(new Dimension(400, 400));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bOK, null);
        this.mainPanel.add((Component)this.infoPane, "Center");
        this.infoPane.getViewport().add((Component)this.info, null);
    }

    private void inform(String text) {
        System.out.println(text);
        this.info.append(text);
        this.info.append("\n");
        this.info.setCaretPosition(this.info.getText().length());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            while (this.m_worker != null && this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.dispose();
        }
    }

    @Override
    public void run() {
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        this.inform("Using Java=" + vmName + " " + vmVersion);
        this.inform("");
        boolean found = false;
        boolean foundJDBC = false;
        this.inform("*** Testing connection to Server: " + this.m_host + " ***");
        if (this.m_host == null || this.m_host.length() == 0) {
            this.inform("ERROR: invalid host name");
            return;
        }
        String host = this.m_host;
        this.inform("Trying Echo - Port 7");
        found = this.testHostPort(host, 7);
        this.inform("Trying FTP - Port 21");
        if (this.testHostPort(host, 21) && !found) {
            found = true;
        }
        this.inform("Trying HTTP - Port 80");
        if (this.testHostPort(host, 80) && !found) {
            found = true;
        }
        this.inform("Trying Kerberos - Port 88");
        if (this.testHostPort(host, 88) && !found) {
            found = true;
        }
        this.inform("Trying NetBios Session - Port 139");
        if (this.testHostPort(host, 139) && !found) {
            found = true;
        }
        this.inform("Trying RMI - Port 1099");
        if (this.testHostPort(host, 1099) && !found) {
            found = true;
        }
        this.inform("Trying Oracle Connection Manager - Port 1630");
        if (this.testHostPort(host, 1630) && !found) {
            found = true;
        }
        this.inform("Trying Oracle JDBC - TCP Port 1521");
        foundJDBC = this.testHostPort(host, 1521);
        int jdbcPort = 0;
        try {
            jdbcPort = Integer.parseInt(this.m_port);
        }
        catch (Exception e) {
            this.inform("ERROR: Cannot parse port=" + this.m_port);
            this.inform(e.getMessage());
            return;
        }
        if (jdbcPort != 1521) {
            this.inform("Trying Oracle JDBC - TCP Port " + jdbcPort);
            if (this.testHostPort(host, jdbcPort) && !foundJDBC) {
                foundJDBC = true;
            }
        }
        if (this.m_worker != null && this.m_worker.isInterrupted()) {
            return;
        }
        if (found && foundJDBC) {
            this.inform("*** Server found: " + host + " ***");
            this.inform("");
        } else if (!found && foundJDBC) {
            this.inform("*** Server found: " + host + " (JDBC only) ***");
            this.inform("");
        } else {
            if (found && !foundJDBC) {
                this.inform("ERROR: Server found: " + host + " - but no JDBC ***");
                this.inform("Make sure that the Oracle Listener process is active");
                return;
            }
            this.inform("ERROR: Server NOT found: " + host + "***");
            this.inform("End Test: Make sure that you can ping the Server");
            return;
        }
        this.inform("Connect to DB: " + this.m_dbName);
        this.inform("Connect with entered parameters");
        if (!this.testJDBC(host, jdbcPort, this.m_dbName, this.m_uid, this.m_pwd)) {
            if (this.m_worker != null && this.m_worker.isInterrupted()) {
                return;
            }
            if (jdbcPort != 1521) {
                this.inform("Connect with standard JDBC port 1521");
                if (this.testJDBC(host, 1521, this.m_dbName, this.m_uid, this.m_pwd)) {
                    this.inform("Please set port to 1521");
                    return;
                }
                if (this.m_worker != null && this.m_worker.isInterrupted()) {
                    return;
                }
            }
            this.inform("Connect with user system/manager");
            if (this.testJDBC(host, 1521, this.m_dbName, "system", "manager")) {
                this.inform("Please check ADEMPIERE user id and password");
                this.inform(".... and please change SYSTEM password");
                return;
            }
        }
        this.inform("*** Adempiere database found: " + host + ":" + jdbcPort + "/" + this.m_dbName + " ***");
        if (this.m_worker != null && this.m_worker.isInterrupted()) {
            return;
        }
        this.inform("");
        this.inform("Testing available application users:");
        this.testAdempiereUsers(host, jdbcPort);
        this.inform("");
        this.inform("*** Test complete **");
    }

    private boolean testHostPort(String host, int port) {
        Socket pingSocket = null;
        try {
            InetAddress server = InetAddress.getByName(host);
            pingSocket = new Socket(server, port);
        }
        catch (UnknownHostException e) {
            this.inform("  Unknown Host: " + e);
        }
        catch (IOException io) {
            this.inform("  IO Exception: " + io);
        }
        if (pingSocket != null) {
            try {
                pingSocket.close();
            }
            catch (IOException e) {
                this.inform("  IO close exception: " + e);
            }
            this.inform("  *** success ***");
            return true;
        }
        return false;
    }

    private boolean testJDBC(String host, int port, String sid, String uid, String pwd) {
        boolean ok = false;
        String urlC = "jdbc:oracle:thin:@//" + host + ":" + port + "/" + sid;
        try {
            this.inform("  Trying Client connection URL=" + urlC + ", User=" + uid);
            Connection con = DriverManager.getConnection(urlC, uid, pwd);
            this.inform("  - connected");
            DatabaseMetaData conMD = con.getMetaData();
            this.inform("  - Driver Name:\t" + conMD.getDriverName());
            this.inform("  - Driver Version:\t" + conMD.getDriverVersion());
            this.inform("  - DB Name:\t" + conMD.getDatabaseProductName());
            this.inform("  - DB Version:\t" + conMD.getDatabaseProductVersion());
            con.close();
            this.inform("  *** success ***");
            ok = true;
        }
        catch (SQLException e) {
            this.inform("  ERROR: " + e.getMessage());
        }
        String urlS = "jdbc:oracle:oci8:@";
        try {
            this.inform("  Trying Server connection URL=" + urlS + ", User=" + uid);
            Connection con = DriverManager.getConnection(urlS, uid, pwd);
            this.inform("  - connected");
            DatabaseMetaData conMD = con.getMetaData();
            this.inform("  - Driver Name:\t" + conMD.getDriverName());
            this.inform("  - Driver Version:\t" + conMD.getDriverVersion());
            this.inform("  - DB Name:\t" + conMD.getDatabaseProductName());
            this.inform("  - DB Version:\t" + conMD.getDatabaseProductVersion());
            con.close();
            this.inform("  *** success ***");
        }
        catch (SQLException e) {
            this.inform("  ERROR: " + e.getMessage());
        }
        return ok;
    }

    private void testAdempiereUsers(String host, int port) {
        String sql = "SELECT Name, Password FROM AD_User WHERE IsActive='Y'";
        String urlC = "jdbc:oracle:thin:@//" + host + ":" + port + "/" + this.m_dbName;
        try {
            this.inform("  - Client connection URL=" + urlC + ", User=" + this.m_uid);
            Connection con = DriverManager.getConnection(urlC, this.m_uid, this.m_pwd);
            this.inform("  - connected");
            Statement stmt = con.createStatement();
            this.inform("  - statement created");
            ResultSet rs = stmt.executeQuery(sql);
            this.inform("  - query executed listing active application users:");
            while (rs.next()) {
                String user = rs.getString(1);
                String password = rs.getString(2);
                String answer = ">>  User = " + user;
                if ((user.equals("System") || user.equals("SuperUser")) && password.equals("System")) {
                    answer = String.valueOf(answer) + "  with standard password (should be changed)";
                }
                this.inform(answer);
            }
            rs.close();
            this.inform("  - query closed");
            stmt.close();
            this.inform("  - statement closed");
            con.close();
            this.inform("  - connection closed");
        }
        catch (SQLException e) {
            this.inform("  ERROR: " + e.getMessage());
        }
    }
}

