/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.Point;
import java.util.Properties;
import javax.swing.JPopupMenu;
import org.compiere.apps.wf.WFContentPanel;
import org.compiere.apps.wf.WFNodeWidget;
import org.compiere.apps.wf.WFPopupItem;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;

public class NodeMenu
implements PopupMenuProvider {
    private WFContentPanel panel;
    private MWorkflow m_wf;

    public NodeMenu(WFContentPanel panel, MWorkflow wf) {
        this.panel = panel;
        this.m_wf = wf;
    }

    public JPopupMenu getPopupMenu(Widget w, Point p2) {
        WFNodeWidget widget = (WFNodeWidget)w;
        MWFNode node = widget.getModel();
        JPopupMenu m_LinePopupMenu = new JPopupMenu(node.getName());
        if (node.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
            String title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteNode")) + ": " + node.getName();
            this.addMenuItem(m_LinePopupMenu, title, node, -1);
            m_LinePopupMenu.addSeparator();
        }
        MWFNode[] nodes = this.m_wf.getNodes(true, Env.getAD_Client_ID((Properties)Env.getCtx()));
        MWFNodeNext[] lines = node.getTransitions(Env.getAD_Client_ID((Properties)Env.getCtx()));
        int n = 0;
        while (n < nodes.length) {
            MWFNode nn = nodes[n];
            if (nn.getAD_WF_Node_ID() != node.getAD_WF_Node_ID()) {
                boolean found = false;
                int i = 0;
                while (i < lines.length) {
                    MWFNodeNext line = lines[i];
                    if (nn.getAD_WF_Node_ID() == line.getAD_WF_Next_ID()) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    String title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"AddLine")) + ": " + node.getName() + " -> " + nn.getName();
                    this.addMenuItem(m_LinePopupMenu, title, node, nn.getAD_WF_Node_ID());
                }
            }
            ++n;
        }
        m_LinePopupMenu.addSeparator();
        int i = 0;
        while (i < lines.length) {
            MWFNodeNext line = lines[i];
            if (line.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
                MWFNode next = MWFNode.get((Properties)Env.getCtx(), (int)line.getAD_WF_Next_ID());
                String title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteLine")) + ": " + node.getName() + " -> " + next.getName();
                this.addMenuItem(m_LinePopupMenu, title, line);
            }
            ++i;
        }
        return m_LinePopupMenu;
    }

    private void addMenuItem(JPopupMenu menu, String title, MWFNode node, int AD_WF_NodeTo_ID) {
        WFPopupItem item = new WFPopupItem(title, node, AD_WF_NodeTo_ID);
        menu.add(item);
        item.addActionListener(this.panel);
    }

    private void addMenuItem(JPopupMenu menu, String title, MWFNodeNext line) {
        WFPopupItem item = new WFPopupItem(title, line);
        menu.add(item);
        item.addActionListener(this.panel);
    }
}

