/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.AMenuStartItem;
import org.compiere.apps.AWindow;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.wf.WFContentPanel;
import org.compiere.apps.wf.WFNodeWidget;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;

public class WFPanel
extends CPanel
implements ActionListener,
FormPanel,
ObjectSceneListener {
    private static final long serialVersionUID = 4478193785606693055L;
    private AMenu m_menu = null;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MWorkflow m_wf = null;
    private Properties m_ctx = Env.getCtx();
    private MWFNode m_activeNode = null;
    private boolean m_readWrite = false;
    private String m_WF_whereClause = null;
    private int m_WF_Window_ID = -1;
    private static CLogger log = CLogger.getCLogger(WFPanel.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel southPanel = new CPanel();
    private WFContentPanel centerPanel = new WFContentPanel(this);
    private BorderLayout southLayout = new BorderLayout();
    private JScrollPane infoScrollPane = new JScrollPane();
    private JTextPane infoTextPane = new JTextPane();
    private CPanel buttonPanel = new CPanel();
    private JButton wfStart = new JButton();
    private JButton wfBack = new JButton();
    private JButton wfNext = new JButton();
    private JButton wfEnd = new JButton();
    private CPanel loadPanel = new CPanel(new FlowLayout(3));
    private CComboBox workflow = new CComboBox();
    private CButton bResetLayout = AEnv.getButton("Reset");
    private CButton bSaveLayout = AEnv.getButton("Save");
    private CButton bZoom = AEnv.getButton("Zoom");
    private CButton bIgnore = AEnv.getButton("Ignore");
    private WFNodeWidget selectedWidget;

    public WFPanel() {
        this(null, null, -1);
    }

    public WFPanel(AMenu menu) {
        this(menu, null, -1);
    }

    public WFPanel(AMenu menu, String wfWhereClause, int wfWindow_ID) {
        this.m_menu = menu;
        this.m_readWrite = menu == null;
        this.m_WF_whereClause = wfWhereClause;
        this.m_WF_Window_ID = wfWindow_ID;
        if (log.isLoggable(Level.INFO)) {
            log.info("RW=" + this.m_readWrite);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WFPanel", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        CompiereColor.setBackground(this);
        this.southPanel.setLayout(this.southLayout);
        this.add((Component)new JScrollPane(this.centerPanel), "Center");
        this.infoScrollPane.getViewport().add((Component)this.infoTextPane, null);
        this.infoScrollPane.setPreferredSize(new Dimension(200, 140));
        this.infoTextPane.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setRequestFocusEnabled(false);
        this.infoTextPane.setContentType("text/html");
        this.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.infoScrollPane, "Center");
        this.southPanel.add((Component)this.buttonPanel, "South");
        this.wfStart.setIcon(Env.getImageIcon((String)"wfStart24.gif"));
        this.wfStart.setMargin(new Insets(0, 10, 0, 10));
        this.wfStart.setRequestFocusEnabled(false);
        this.wfStart.addActionListener(this);
        this.wfStart.setToolTipText(Msg.getMsg((Properties)this.m_ctx, (String)"WFStart"));
        this.wfBack.setIcon(Env.getImageIcon((String)"wfBack24.gif"));
        this.wfBack.setMargin(new Insets(0, 15, 0, 15));
        this.wfBack.setRequestFocusEnabled(false);
        this.wfBack.addActionListener(this);
        this.wfBack.setToolTipText(Msg.getMsg((Properties)this.m_ctx, (String)"WFPrevious"));
        this.wfNext.setIcon(Env.getImageIcon((String)"wfNext24.gif"));
        this.wfNext.setMargin(new Insets(0, 15, 0, 15));
        this.wfNext.setRequestFocusEnabled(false);
        this.wfNext.addActionListener(this);
        this.wfNext.setToolTipText(Msg.getMsg((Properties)this.m_ctx, (String)"WFNext"));
        this.wfEnd.setIcon(Env.getImageIcon((String)"wfEnd24.gif"));
        this.wfEnd.setMargin(new Insets(0, 10, 0, 10));
        this.wfEnd.setRequestFocusEnabled(false);
        this.wfEnd.addActionListener(this);
        this.wfEnd.setToolTipText(Msg.getMsg((Properties)this.m_ctx, (String)"WFExit"));
        this.buttonPanel.add((Component)this.wfStart, null);
        this.buttonPanel.add((Component)this.wfBack, null);
        this.buttonPanel.add((Component)this.wfNext, null);
        this.buttonPanel.add((Component)this.wfEnd, null);
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo);
        }
        try {
            this.loadPanel();
            frame.getContentPane().add((Component)this.loadPanel, "North");
            this.setPreferredSize(new Dimension(500, 500));
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void loadPanel() {
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_Workflow_ID, Name FROM AD_Workflow " + (!Util.isEmpty((String)this.m_WF_whereClause, (boolean)true) ? " WHERE " + this.m_WF_whereClause : "") + " ORDER BY 2", "AD_Workflow", false, false);
        Object[] pp = DB.getKeyNamePairs((String)sql, (boolean)true);
        this.workflow = new CComboBox(pp);
        this.loadPanel.add(this.workflow);
        this.workflow.addActionListener(this);
        this.loadPanel.add(this.bIgnore);
        this.bIgnore.addActionListener(this);
        this.loadPanel.add(this.bResetLayout);
        this.bResetLayout.addActionListener(this);
        this.loadPanel.add(this.bSaveLayout);
        this.bSaveLayout.addActionListener(this);
        this.loadPanel.add(this.bZoom);
        this.bZoom.addActionListener(this);
    }

    private void load(boolean readWrite) {
        KeyNamePair pp = (KeyNamePair)this.workflow.getSelectedItem();
        if (pp == null) {
            return;
        }
        this.load(pp.getKey(), readWrite);
    }

    public void load(int AD_Workflow_ID, boolean readWrite) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("RW=" + readWrite + " - AD_Workflow_ID=" + AD_Workflow_ID);
        }
        if (AD_Workflow_ID == 0) {
            return;
        }
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        this.m_wf = new MWorkflow(Env.getCtx(), AD_Workflow_ID, null);
        this.centerPanel.removeAll();
        this.centerPanel.setReadWrite(readWrite);
        this.centerPanel.getGraphScene().addObjectSceneListener((ObjectSceneListener)this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.centerPanel.setWorkflow(this.m_wf);
        MWFNode[] nodes = this.m_wf.getNodes(true, AD_Client_ID);
        ArrayList added = new ArrayList();
        int i = 0;
        while (i < nodes.length) {
            if (!added.contains(nodes[i].getAD_WF_Node_ID())) {
                this.centerPanel.addNode(nodes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < nodes.length) {
            MWFNodeNext[] nexts = nodes[i].getTransitions(AD_Client_ID);
            int j = 0;
            while (j < nexts.length) {
                this.centerPanel.addEdge(nexts[j]);
                ++j;
            }
            ++i;
        }
        StringBuilder msg = new StringBuilder("<HTML>");
        msg.append("<H2>").append(this.m_wf.getName(true)).append("</H2>");
        String s = this.m_wf.getDescription(true);
        if (s != null && s.length() > 0) {
            msg.append("<B>").append(s).append("</B>");
        }
        if ((s = this.m_wf.getHelp(true)) != null && s.length() > 0) {
            msg.append("<BR>").append(s);
        }
        msg.append("</HTML>");
        this.infoTextPane.setText(msg.toString());
        this.infoTextPane.setCaretPosition(0);
        this.centerPanel.relayout();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_wf == null && e.getSource() != this.workflow) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        if (e.getSource() == this.bZoom) {
            this.zoom();
        } else if (e.getSource() == this.bIgnore) {
            this.load(this.m_wf.getAD_Workflow_ID(), true);
        } else if (e.getSource() == this.workflow) {
            this.load(true);
        } else if (e.getSource() == this.bSaveLayout) {
            if (this.m_wf.getAD_Client_ID() == AD_Client_ID) {
                this.m_wf.saveEx();
            }
            MWFNode[] nodes = this.m_wf.getNodes(false, AD_Client_ID);
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].getAD_Client_ID() == AD_Client_ID) {
                    nodes[i].saveEx();
                }
                ++i;
            }
        } else if (e.getSource() == this.bResetLayout) {
            this.resetLayout();
        } else if (e.getSource() == this.wfStart || this.m_activeNode == null) {
            this.start(this.m_wf.getAD_WF_Node_ID());
        } else if (e.getSource() == this.wfBack) {
            this.start(this.m_wf.getPrevious(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID));
        } else if (e.getSource() == this.wfNext) {
            this.start(this.m_wf.getNext(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID));
        } else if (e.getSource() == this.wfEnd) {
            this.start(this.m_wf.getLast(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID));
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void start(MWFNode node) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Node=" + node);
        }
        StringBuilder msg = new StringBuilder("<HTML>");
        msg.append("<H2>").append(node.getName(true)).append("</H2>");
        String s = node.getDescription(true);
        if (s != null && s.length() > 0) {
            msg.append("<B>").append(s).append("</B>");
        }
        if ((s = node.getHelp(true)) != null && s.length() > 0) {
            msg.append("<BR>").append(s);
        }
        msg.append("</HTML>");
        this.infoTextPane.setText(msg.toString());
        this.infoTextPane.setCaretPosition(0);
        if (this.m_menu != null) {
            new AMenuStartItem(node.getAD_WF_Node_ID(), false, node.getName(true), this.m_menu).start();
        }
        this.m_activeNode = node;
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        boolean first = this.m_wf.isFirst(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID);
        boolean last = this.m_wf.isLast(this.m_activeNode.getAD_WF_Node_ID(), AD_Client_ID);
        this.wfStart.setEnabled(!first);
        this.wfBack.setEnabled(!first);
        this.wfNext.setEnabled(!last);
        this.wfEnd.setEnabled(!last);
    }

    public void start(int AD_WF_Node_ID) {
        if (AD_WF_Node_ID == 0) {
            return;
        }
        Widget object = this.centerPanel.getGraphScene().findWidget((Object)AD_WF_Node_ID);
        if (object != null) {
            WFNodeWidget widget = (WFNodeWidget)object;
            widget.setBackground((Paint)Color.CYAN);
            if (this.selectedWidget != null) {
                this.selectedWidget.setBackground((Paint)Color.WHITE);
            }
            this.selectedWidget = widget;
            this.start(widget.getModel());
        }
    }

    public void resetLayout() {
        Point p0 = new Point(0, 0);
        int i = 0;
        while (i < this.centerPanel.getComponentCount()) {
            Component comp = this.centerPanel.getComponent(i);
            comp.setLocation(p0);
            ++i;
        }
        this.centerPanel.validate();
    }

    private void zoom() {
        AWindow frame;
        if (this.m_WF_Window_ID <= 0) {
            this.m_WF_Window_ID = MTable.get((Properties)this.m_ctx, (int)117).getAD_Window_ID();
        }
        if (this.m_WF_Window_ID <= 0) {
            throw new AdempiereException("@NotFound@ @AD_Window_ID@");
        }
        MQuery query = null;
        if (this.m_wf != null) {
            query = MQuery.getEqualQuery((String)"AD_Workflow_ID", (int)this.m_wf.getAD_Workflow_ID());
        }
        if (!(frame = new AWindow(null)).initWindow(this.m_WF_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        AEnv.showCenterScreen(frame);
        frame = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WFPanel[");
        if (this.m_wf != null) {
            sb.append(this.m_wf.getAD_Workflow_ID());
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)true);
        JFrame jf = new JFrame("WF");
        WFPanel pp = new WFPanel(null);
        pp.load(101, true);
        jf.getContentPane().add(pp);
        jf.pack();
        jf.setVisible(true);
    }

    public void focusChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
    }

    public void highlightingChanged(ObjectSceneEvent arg0, Set<Object> arg1, Set<Object> arg2) {
    }

    public void hoverChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
    }

    public void objectAdded(ObjectSceneEvent arg0, Object arg1) {
    }

    public void objectRemoved(ObjectSceneEvent arg0, Object arg1) {
    }

    public void objectStateChanged(ObjectSceneEvent event, Object changedObject, ObjectState previousState, ObjectState newState) {
        Widget w = (Widget)changedObject;
        System.out.println("location=" + w.getLocation());
    }

    public void selectionChanged(ObjectSceneEvent event, Set<Object> prevSelection, Set<Object> selection) {
        if (selection != null && selection.size() > 0) {
            Object selected = selection.toArray()[selection.size() - 1];
            WFNodeWidget widget = (WFNodeWidget)this.centerPanel.getGraphScene().findWidget(selected);
            widget.setBackground((Paint)Color.CYAN);
            if (this.selectedWidget != null) {
                this.selectedWidget.setBackground((Paint)Color.WHITE);
            }
            this.selectedWidget = widget;
            this.start(widget.getModel());
        }
    }
}

