/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormCheck;
import org.compiere.grid.VPaymentFormDialog;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPaymentValidate;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VPaymentFormCheck
extends PaymentFormCheck
implements ActionListener,
FocusListener {
    private VPaymentFormDialog dialog;
    private CLabel sBankAccountLabel = new CLabel();
    private CComboBox sBankAccountCombo = new CComboBox();
    private CLabel sCurrencyLabel = new CLabel();
    private CComboBox sCurrencyCombo = new CComboBox();
    private CLabel sAmountLabel = new CLabel();
    private VNumber sAmountField = new VNumber();
    private CLabel sRoutingLabel = new CLabel();
    private CTextField sRoutingField = new CTextField();
    private CLabel sNumberLabel = new CLabel();
    private CTextField sNumberField = new CTextField();
    private CLabel sCheckLabel = new CLabel();
    private CTextField sCheckField = new CTextField();
    private CButton sOnline = new CButton();
    private CLabel sStatus = new CLabel();

    public VPaymentFormCheck(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.dialog = new VPaymentFormDialog((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        GridBagLayout sPanelLayout = new GridBagLayout();
        this.dialog.getPanel().setLayout(sPanelLayout);
        this.sBankAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.sAmountLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Amount"));
        this.sRoutingLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"RoutingNo"));
        this.sNumberLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AccountNo"));
        this.sCheckLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"CheckNo"));
        this.sCheckField.setColumns(8);
        this.sCurrencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.sNumberField.setPreferredSize(new Dimension(100, 21));
        this.sRoutingField.setPreferredSize(new Dimension(70, 21));
        this.sOnline.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Online"));
        this.sOnline.addActionListener(this);
        this.dialog.getPanel().add((Component)this.sBankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sBankAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.sCurrencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sCurrencyCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.sAmountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sAmountField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.sAmountField.addFocusListener(this);
        this.dialog.getPanel().add((Component)this.sRoutingLabel, new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sRoutingField, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sNumberLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sNumberField, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sCheckLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sCheckField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.sOnline, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.sStatus, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void loadData() {
        Integer C_Currency_ID;
        super.loadData();
        this.sAmountField.setValue(this.m_Amount);
        if (this.m_C_Payment_ID != 0) {
            this.sRoutingField.setText(this.m_mPayment.getRoutingNo());
            this.sNumberField.setText(this.m_mPayment.getAccountNo());
            this.sCheckField.setText(this.m_mPayment.getCheckNo());
            this.sStatus.setText(this.m_mPayment.getR_PnRef());
            this.sAmountField.setValue(this.m_mPayment.getPayAmt());
        }
        if (this.s_Currencies.containsKey(C_Currency_ID = new Integer(this.m_C_Currency_ID))) {
            Enumeration en = this.s_Currencies.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.sCurrencyCombo.addItem(this.s_Currencies.get(key));
            }
            this.sCurrencyCombo.addActionListener(this);
            this.sCurrencyCombo.setSelectedItem(this.s_Currencies.get(C_Currency_ID));
        } else {
            this.sCurrencyLabel.setVisible(false);
            this.sCurrencyCombo.setVisible(false);
        }
        ArrayList list = this.getBankAccountList();
        for (KeyNamePair pp : list) {
            this.sBankAccountCombo.addItem(pp);
        }
        if (this.selectedBankAccount != null) {
            this.sBankAccountCombo.setSelectedItem(this.selectedBankAccount);
        }
        boolean exist = this.isBankAccountProcessorExist(this.m_C_Currency_ID, (BigDecimal)this.sAmountField.getValue());
        this.sOnline.setVisible(exist);
        if (exist) {
            this.updateOnlineButton();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sCurrencyCombo) {
            int C_Currency_ID = 0;
            KeyNamePair pp = (KeyNamePair)this.sCurrencyCombo.getSelectedItem();
            if (pp != null) {
                C_Currency_ID = pp.getKey();
            }
            BigDecimal amt = MConversionRate.convert((Properties)Env.getCtx(), (BigDecimal)this.m_Amount, (int)this.m_C_Currency_ID, (int)C_Currency_ID, (int)this.m_AD_Client_ID, (int)this.m_AD_Org_ID);
            this.sAmountField.setValue(amt);
            this.updateOnlineButton();
        } else if (e.getSource() == this.sOnline) {
            this.processOnline();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.sAmountField) {
            this.updateOnlineButton();
        }
    }

    private void updateOnlineButton() {
        int C_Currency_ID = 0;
        KeyNamePair pp = (KeyNamePair)this.sCurrencyCombo.getSelectedItem();
        if (pp != null) {
            C_Currency_ID = pp.getKey();
        }
        BigDecimal PayAmt = (BigDecimal)this.sAmountField.getValue();
        if (C_Currency_ID > 0 && PayAmt != null) {
            MBankAccountProcessor bankAccountProcessor = this.getBankAccountProcessor(C_Currency_ID, PayAmt);
            this.sOnline.setEnabled(bankAccountProcessor != null);
            this.setBankAccountProcessor(bankAccountProcessor);
        } else {
            this.sOnline.setEnabled(false);
            this.setBankAccountProcessor(null);
        }
    }

    public boolean checkMandatory() {
        String error;
        int C_BankAccount_ID = 0;
        boolean dataOK = true;
        KeyNamePair kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem();
        if (kp != null) {
            C_BankAccount_ID = kp.getKey();
        }
        if ((error = MPaymentValidate.validateRoutingNo((String)this.sRoutingField.getText())).length() != 0) {
            this.sRoutingField.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.getWindowNo(), this.dialog, error);
            dataOK = false;
        }
        if ((error = MPaymentValidate.validateAccountNo((String)this.sNumberField.getText())).length() != 0) {
            this.sNumberField.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.getWindowNo(), this.dialog, error);
            dataOK = false;
        }
        if ((error = MPaymentValidate.validateCheckNo((String)this.sCheckField.getText())).length() != 0) {
            this.sCheckField.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.getWindowNo(), this.dialog, error);
            dataOK = false;
        }
        if (C_BankAccount_ID == 0) {
            ADialog.error(this.getWindowNo(), this.dialog, "FillMandatory", this.sBankAccountLabel.getText());
            dataOK = false;
        }
        return dataOK;
    }

    public boolean saveChangesInTrx(String trxName) {
        boolean ok;
        int newC_BankAccount_ID = 0;
        KeyNamePair kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem();
        if (kp != null) {
            newC_BankAccount_ID = kp.getKey();
        }
        if (!(ok = this.save(newC_BankAccount_ID, this.sRoutingField.getText(), this.sNumberField.getText(), this.sCheckField.getText(), (BigDecimal)this.sAmountField.getValue(), trxName))) {
            ADialog.error(this.getWindowNo(), this.dialog, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            ADialog.info(this.getWindowNo(), this.dialog, "PaymentCreated", this.m_mPayment.getDocumentNo());
        }
        return ok;
    }

    public void showWindow() {
        this.dialog.setVisible(true);
    }

    public void closeWindow() {
        this.dialog.dispose();
    }

    public Object getWindow() {
        return this.dialog;
    }
}

