/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormDirect;
import org.compiere.grid.VPaymentFormDialog;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class VPaymentFormDirect
extends PaymentFormDirect
implements ActionListener {
    private VPaymentFormDialog dialog;
    private CLabel tAccountLabel = new CLabel();
    private CComboBox tAccountCombo = new CComboBox();
    private CButton tOnline = new CButton();
    private CTextField tRoutingField = new CTextField();
    private CTextField tNumberField = new CTextField();
    private CLabel tStatus = new CLabel();
    private CLabel tRoutingText = new CLabel();
    private CLabel tNumberText = new CLabel();

    public VPaymentFormDirect(int windowNo, GridTab mTab, boolean isDebit) {
        super(windowNo, mTab, isDebit);
        this.dialog = new VPaymentFormDialog((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        GridBagLayout tPanelLayout = new GridBagLayout();
        this.dialog.getPanel().setLayout(tPanelLayout);
        this.tAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BP_BankAccount_ID"));
        this.tRoutingField.setColumns(8);
        this.tNumberField.setColumns(10);
        this.tRoutingText.setText(Msg.translate((Properties)Env.getCtx(), (String)"RoutingNo"));
        this.tNumberText.setText(Msg.translate((Properties)Env.getCtx(), (String)"AccountNo"));
        this.tOnline.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Online"));
        this.tOnline.addActionListener(this);
        this.dialog.getPanel().add((Component)this.tAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.tAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.tRoutingField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.tNumberField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.tStatus, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.tRoutingText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.tNumberText, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.tOnline, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void loadData() {
        if (this.m_C_Payment_ID != 0) {
            this.tRoutingField.setText(this.m_mPayment.getRoutingNo());
            this.tNumberField.setText(this.m_mPayment.getAccountNo());
            this.tStatus.setText(this.m_mPayment.getR_PnRef());
        }
        ArrayList list = this.getBPBankAccountList();
        for (KeyNamePair pp : list) {
            this.tAccountCombo.addItem(pp);
        }
        boolean exist = this.isBankAccountProcessorExist();
        this.tOnline.setVisible(exist);
        MBankAccountProcessor bankAccountProcessor = this.getBankAccountProcessor();
        this.setBankAccountProcessor(bankAccountProcessor);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tOnline) {
            this.processOnline();
        }
    }

    public boolean checkMandatory() {
        boolean dataOK = true;
        KeyNamePair bpba = (KeyNamePair)this.tAccountCombo.getSelectedItem();
        if (bpba == null) {
            this.tAccountCombo.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.getWindowNo(), this.dialog, "PaymentBPBankNotFound");
            dataOK = false;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + dataOK);
        }
        return dataOK;
    }

    public boolean saveChangesInTrx(String trxName) {
        boolean ok = this.save(0, this.tRoutingField.getText(), this.tNumberField.getText(), trxName);
        if (!ok) {
            ADialog.error(this.getWindowNo(), this.dialog, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            ADialog.info(this.getWindowNo(), this.dialog, "PaymentCreated", this.m_mPayment.getDocumentNo());
        }
        return ok;
    }

    public void showWindow() {
        this.dialog.setVisible(true);
    }

    public void closeWindow() {
        this.dialog.dispose();
    }

    public Object getWindow() {
        return this.dialog;
    }
}

