/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.text.JTextComponent;
import org.adempiere.exceptions.DBException;
import org.compiere.grid.ed.AutoCompleter;
import org.compiere.grid.ed.CityVO;
import org.compiere.model.MSysConfig;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CityAutoCompleter
extends AutoCompleter {
    public static final CityVO ITEM_More = new CityVO(-1, "...", -1, "");
    private final int m_maxRows = MSysConfig.getIntValue((String)"LOCATION_MAX_CITY_ROWS", (int)7);
    private CityVO m_city = null;
    private final int m_windowNo;
    private ArrayList<CityVO> list = new ArrayList();
    private ArrayList<CityVO> listShow = new ArrayList();

    public CityAutoCompleter(JTextComponent comp, int windowNo) {
        super(comp);
        this.m_windowNo = windowNo;
        this.listBox.setVisibleRowCount(this.m_maxRows);
        this.setCity(null);
    }

    @Override
    protected void acceptedListItem(Object selected) {
        if (selected == null || selected == ITEM_More) {
            this.setCity(null);
            return;
        }
        CityVO item = (CityVO)selected;
        this.setCity(item);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Region_ID", (String)String.valueOf(item.C_Region_ID));
        this.textBox.setText(item.CityName);
    }

    @Override
    protected boolean updateListData() {
        String search = this.textBox.getText();
        if (this.m_city != null && this.m_city.CityName.compareTo(search) != 0) {
            this.setCity(null);
        }
        this.listShow.clear();
        boolean truncated = false;
        search = search.toUpperCase();
        int i = 0;
        for (CityVO vo : this.list) {
            if (!vo.CityName.toUpperCase().startsWith(search)) continue;
            if (i > 0 && i == this.m_maxRows + 1) {
                this.listShow.add(ITEM_More);
                truncated = true;
                break;
            }
            this.listShow.add(vo);
            ++i;
        }
        this.listBox.setListData(this.listShow.toArray());
        if (this.listShow.isEmpty()) {
            return false;
        }
        CityVO city = this.listShow.get(0);
        if (city.CityName.equalsIgnoreCase(search)) {
            this.m_city = city;
            return true;
        }
        if (!truncated && this.listShow.size() == 1 && this.m_city != null && this.listShow.get(0).equals((Object)this.m_city)) {
            this.log.finest("nothing to do 1");
            return false;
        }
        return true;
    }

    public void fillList() {
        this.list.clear();
        this.listShow.clear();
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder("SELECT cy.C_City_ID, cy.Name, cy.C_Region_ID, r.Name FROM C_City cy LEFT OUTER JOIN C_Region r ON (r.C_Region_ID=cy.C_Region_ID) WHERE cy.AD_Client_ID IN (0,?)");
        params.add(this.getAD_Client_ID());
        if (this.getC_Region_ID() > 0) {
            sql.append(" AND cy.C_Region_ID=?");
            params.add(this.getC_Region_ID());
        }
        if (this.getC_Country_ID() > 0) {
            sql.append(" AND cy.C_Country_ID=?");
            params.add(this.getC_Country_ID());
        }
        sql.append(" ORDER BY cy.Name, r.Name");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), null);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                int i = 0;
                while (rs.next()) {
                    CityVO vo = new CityVO(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getString(4));
                    this.list.add(vo);
                    if (i <= this.m_maxRows) {
                        this.listShow.add(vo);
                    } else if (i == this.m_maxRows + 1 && i > 0) {
                        this.listShow.add(ITEM_More);
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.listBox.setListData(this.listShow.toArray());
    }

    private void setCity(CityVO vo) {
        this.m_city = vo;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("C_City_ID=" + this.m_city);
        }
        if (this.m_city == null) {
            this.textBox.setBackground(new Color(230, 230, 255));
        } else {
            this.textBox.setBackground(Color.WHITE);
        }
    }

    public int getC_City_ID() {
        return this.m_city != null ? this.m_city.C_City_ID : -1;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public int getC_Country_ID() {
        return Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Country_ID");
    }

    public int getC_Region_ID() {
        return Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Region_ID");
    }

    public CityVO getCity() {
        return this.m_city;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e == null || this.listBox == null || this.listBox.getSelectedValue() == null || this.listBox.getSelectedValue().equals(ITEM_More)) {
            this.setCity(null);
            return;
        }
        CityVO item = (CityVO)this.listBox.getSelectedValue();
        this.setCity(item);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Region_ID", (String)String.valueOf(item.C_Region_ID));
        this.textBox.setText(item.CityName);
    }
}

