/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.model.MLocator;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MRole;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VLocatorDialog
extends CDialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 4727764506935600690L;
    private int m_WindowNo;
    private boolean m_change = false;
    private MLocatorLookup m_mLocator;
    private int m_M_Locator_ID;
    private boolean m_mandatory = false;
    private int m_only_Warehouse_ID = 0;
    private int m_M_Warehouse_ID;
    private String m_M_WarehouseName;
    private String m_M_WarehouseValue;
    private String m_Separator;
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private static CLogger log = CLogger.getCLogger(VLocatorDialog.class);
    private CPanel panel = new CPanel();
    private CPanel mainPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BorderLayout southLayout = new BorderLayout();
    private VComboBox fLocator = new VComboBox();
    private CComboBox fWarehouse = new CComboBox();
    private JCheckBox fCreateNew = new JCheckBox();
    private CTextField fX = new CTextField();
    private CTextField fY = new CTextField();
    private CTextField fZ = new CTextField();
    private JLabel lLocator = new JLabel();
    private CTextField fWarehouseInfo = new CTextField();
    private CTextField fValue = new CTextField();
    private JLabel lWarehouseInfo = new JLabel();
    private JLabel lWarehouse = new JLabel();
    private JLabel lX = new JLabel();
    private JLabel lY = new JLabel();
    private JLabel lZ = new JLabel();
    private JLabel lValue = new JLabel();

    public VLocatorDialog(Frame frame, String title, MLocatorLookup mLocator, int M_Locator_ID, boolean mandatory, int only_Warehouse_ID) {
        super(frame, title, true);
        this.m_WindowNo = AEnv.getWindowNo(frame);
        try {
            this.jbInit();
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VLocatorDialog", (Throwable)ex);
        }
        this.m_mLocator = mLocator;
        this.m_M_Locator_ID = M_Locator_ID;
        this.m_mandatory = mandatory;
        this.m_only_Warehouse_ID = only_Warehouse_ID;
        this.initLocator();
        AEnv.positionCenterWindow(frame, this);
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.panelLayout);
        this.southPanel.setLayout(this.southLayout);
        this.mainPanel.setLayout(this.gridBagLayout);
        this.panelLayout.setHgap(5);
        this.panelLayout.setVgap(10);
        this.fCreateNew.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"CreateNew"));
        this.fX.setColumns(15);
        this.fY.setColumns(15);
        this.fZ.setColumns(15);
        this.lLocator.setLabelFor(this.fLocator);
        this.lLocator.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        this.fWarehouseInfo.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.fWarehouseInfo.setReadWrite(false);
        this.fWarehouseInfo.setColumns(15);
        this.fValue.setColumns(15);
        this.lWarehouseInfo.setLabelFor(this.fWarehouseInfo);
        this.lWarehouseInfo.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.lWarehouse.setLabelFor(this.fWarehouse);
        this.lWarehouse.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.lX.setLabelFor(this.fX);
        this.lX.setText(Msg.getElement((Properties)Env.getCtx(), (String)"X"));
        this.lY.setLabelFor(this.fY);
        this.lY.setText(Msg.getElement((Properties)Env.getCtx(), (String)"Y"));
        this.lZ.setLabelFor(this.fZ);
        this.lZ.setText(Msg.getElement((Properties)Env.getCtx(), (String)"Z"));
        this.lValue.setLabelFor(this.fValue);
        this.lValue.setText(Msg.translate((Properties)Env.getCtx(), (String)"Value"));
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.lLocator, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fLocator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fCreateNew, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.lWarehouseInfo, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fWarehouseInfo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.lWarehouse, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fWarehouse, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.lX, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fX, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.lY, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fY, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.lZ, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fZ, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.lValue, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.fValue, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.panel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.confirmPanel.addActionListener(this);
    }

    private void initLocator() {
        block9: {
            log.fine("");
            String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse";
            if (this.m_only_Warehouse_ID != 0) {
                sql = String.valueOf(sql) + " WHERE M_Warehouse_ID=" + this.m_only_Warehouse_ID;
            }
            String SQL = String.valueOf(MRole.getDefault().addAccessSQL(sql, "M_Warehouse", false, false)) + " ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.fWarehouse.addItem(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, SQL, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Warehouses=" + this.fWarehouse.getItemCount());
        }
        this.m_mLocator.fillComboBox(this.m_mandatory, true, true, false, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_mLocator.toString());
        }
        this.fLocator.setModel((ComboBoxModel)this.m_mLocator);
        this.fLocator.setValue(this.m_M_Locator_ID);
        this.fLocator.addActionListener(this);
        this.displayLocator();
        this.fCreateNew.setSelected(false);
        this.fCreateNew.addActionListener(this);
        this.enableNew();
        this.fWarehouse.addActionListener(this);
        this.fX.addKeyListener(this);
        this.fY.addKeyListener(this);
        this.fZ.addKeyListener(this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (e.getActionCommand().equals("Ok")) {
            this.actionOK();
            this.m_change = true;
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_change = false;
            this.dispose();
        } else if (e.getSource() == this.fLocator) {
            this.displayLocator();
        } else if (source == this.fCreateNew) {
            this.enableNew();
        } else if (this.fCreateNew.isSelected() && source == this.fWarehouse) {
            this.createValue();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.fCreateNew.isSelected()) {
            this.createValue();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void displayLocator() {
        MLocator l = (MLocator)this.fLocator.getSelectedItem();
        if (l == null) {
            return;
        }
        this.m_M_Locator_ID = l.getM_Locator_ID();
        this.fWarehouseInfo.setText(l.getWarehouseName());
        this.fX.setText(l.getX());
        this.fY.setText(l.getY());
        this.fZ.setText(l.getZ());
        this.fValue.setText(l.getValue());
        this.getWarehouseInfo(l.getM_Warehouse_ID());
        int size = this.fWarehouse.getItemCount();
        int i = 0;
        while (i < size) {
            KeyNamePair pp = (KeyNamePair)this.fWarehouse.getItemAt(i);
            if (pp.getKey() == l.getM_Warehouse_ID()) {
                this.fWarehouse.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private void enableNew() {
        boolean sel = this.fCreateNew.isSelected();
        this.lWarehouse.setVisible(sel);
        this.fWarehouse.setVisible(sel);
        this.lWarehouseInfo.setVisible(!sel);
        this.fWarehouseInfo.setVisible(!sel);
        this.fX.setReadWrite(sel);
        this.fY.setReadWrite(sel);
        this.fZ.setReadWrite(sel);
        this.fValue.setReadWrite(sel);
        this.pack();
    }

    private void getWarehouseInfo(int M_Warehouse_ID) {
        block7: {
            if (M_Warehouse_ID == this.m_M_Warehouse_ID) {
                return;
            }
            this.m_M_Warehouse_ID = 0;
            this.m_M_WarehouseName = "";
            this.m_M_WarehouseValue = "";
            this.m_Separator = ".";
            this.m_AD_Client_ID = 0;
            this.m_AD_Org_ID = 0;
            String SQL = "SELECT M_Warehouse_ID, Value, Name, Separator, AD_Client_ID, AD_Org_ID FROM M_Warehouse WHERE M_Warehouse_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    pstmt.setInt(1, M_Warehouse_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_M_Warehouse_ID = rs.getInt(1);
                        this.m_M_WarehouseValue = rs.getString(2);
                        this.m_M_WarehouseName = rs.getString(3);
                        this.m_Separator = rs.getString(4);
                        this.m_AD_Client_ID = rs.getInt(5);
                        this.m_AD_Org_ID = rs.getInt(6);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, SQL, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void createValue() {
        KeyNamePair pp = (KeyNamePair)this.fWarehouse.getSelectedItem();
        if (pp == null) {
            return;
        }
        this.getWarehouseInfo(pp.getKey());
        StringBuilder buf = new StringBuilder(this.m_M_WarehouseValue);
        buf.append(this.m_Separator).append(this.fX.getText());
        buf.append(this.m_Separator).append(this.fY.getText());
        buf.append(this.m_Separator).append(this.fZ.getText());
        this.fValue.setText(buf.toString());
    }

    private void actionOK() {
        if (this.fCreateNew.isSelected()) {
            KeyNamePair pp = (KeyNamePair)this.fWarehouse.getSelectedItem();
            if (pp != null) {
                this.getWarehouseInfo(pp.getKey());
            }
            String mandatoryFields = "";
            if (this.m_M_Warehouse_ID == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lWarehouse.getText() + " - ";
            }
            if (this.fValue.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lValue.getText() + " - ";
            }
            if (this.fX.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lX.getText() + " - ";
            }
            if (this.fY.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lY.getText() + " - ";
            }
            if (this.fZ.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lZ.getText() + " - ";
            }
            if (mandatoryFields.length() != 0) {
                ADialog.error(this.m_WindowNo, this, "FillMandatory", mandatoryFields.substring(0, mandatoryFields.length() - 3));
                return;
            }
            MLocator loc = MLocator.get((Properties)Env.getCtx(), (int)this.m_M_Warehouse_ID, (String)this.fValue.getText(), (String)this.fX.getText(), (String)this.fY.getText(), (String)this.fZ.getText());
            this.m_M_Locator_ID = loc.getM_Locator_ID();
            this.fLocator.addItem(loc);
            this.fLocator.setSelectedItem(loc);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("M_Locator_ID=" + this.m_M_Locator_ID);
        }
    }

    public Integer getValue() {
        MLocator l = (MLocator)this.fLocator.getSelectedItem();
        if (l != null && l.getM_Locator_ID() != 0) {
            return new Integer(l.getM_Locator_ID());
        }
        return null;
    }

    public boolean isChanged() {
        MLocator l;
        if (this.m_change && (l = (MLocator)this.fLocator.getSelectedItem()) != null) {
            return l.getM_Locator_ID() == this.m_M_Locator_ID;
        }
        return this.m_change;
    }
}

