/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.compiere.apps.ADialog;
import org.compiere.model.MPOS;
import org.compiere.pos.CashSubFunctions;
import org.compiere.pos.POSKeyboard;
import org.compiere.pos.PosKeyboardFocusManager;
import org.compiere.pos.PosOrderModel;
import org.compiere.pos.SubCurrentLine;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.pos.SubOrder;
import org.compiere.swing.CFrame;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PosBasePanel
extends CPanel {
    private static final long serialVersionUID = 7477837683408198860L;
    public static String trxName = null;
    private int m_WindowNo = 0;
    private CFrame m_frame;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = Env.getCtx();
    private int m_SalesRep_ID = 0;
    protected MPOS p_pos = null;
    private PosKeyboardFocusManager m_focusMgr = null;
    protected SubOrder f_order;
    protected SubCurrentLine f_curLine;
    protected SubFunctionKeys f_functionKeys;
    protected CashSubFunctions f_cashfunctions;
    private Timer logoutTimer;
    PosOrderModel m_order = null;
    private Timestamp m_today = Env.getContextAsDate((Properties)this.m_ctx, (String)"#Date");
    private KeyboardFocusManager originalKeyboardFocusManager;
    private boolean debug = true;
    private CFrame frame;
    private HashMap<Integer, POSKeyboard> keyboards = new HashMap();

    public PosBasePanel() {
        super((LayoutManager)new MigLayout(" fill", "[500!]10[300:350:, fill]", ""));
        this.originalKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.m_focusMgr = new PosKeyboardFocusManager();
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this.m_focusMgr);
    }

    public String getTrxName() {
        return trxName;
    }

    public void init(int WindowNo, CFrame frame) {
        this.frame = frame;
        if (this.debug) {
            frame.setPreferredSize(new Dimension(1024, 768));
        } else {
            frame.setExtendedState(6);
            frame.setResizable(false);
        }
        this.m_SalesRep_ID = Env.getAD_User_ID((Properties)this.m_ctx);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("init - SalesRep_ID=" + this.m_SalesRep_ID);
        }
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        frame.setJMenuBar(null);
        try {
            if (!this.dynInit()) {
                this.dispose();
                frame.dispose();
                return;
            }
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "init", (Throwable)e);
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("PosPanel.init - " + this.getPreferredSize());
        }
        if (this.p_pos.getAutoLogoutDelay() > 0 && this.logoutTimer == null) {
            this.logoutTimer = new Timer(1000, new ActionListener(){
                PointerInfo pi = null;
                long lastMouseMove = System.currentTimeMillis();
                long lastKeyboardEvent = System.currentTimeMillis();

                @Override
                public void actionPerformed(ActionEvent e) {
                    long now = e.getWhen();
                    PointerInfo newPi = MouseInfo.getPointerInfo();
                    if (newPi != null && this.pi != null && !this.pi.getLocation().equals(newPi.getLocation())) {
                        this.lastMouseMove = now;
                    }
                    this.pi = newPi;
                    this.lastKeyboardEvent = PosBasePanel.this.m_focusMgr.getLastWhen();
                    PosBasePanel.this.p_pos.getAutoLogoutDelay();
                    Math.max(this.lastKeyboardEvent, this.lastMouseMove);
                }
            });
            this.logoutTimer.start();
        }
        this.m_focusMgr.start();
    }

    public void dispose() {
        this.keyboards.clear();
        this.keyboards = null;
        if (this.logoutTimer != null) {
            this.logoutTimer.stop();
        }
        this.logoutTimer = null;
        if (this.m_focusMgr != null) {
            this.m_focusMgr.stop();
        }
        this.m_focusMgr = null;
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this.originalKeyboardFocusManager);
        if (this.f_order != null) {
            this.f_order.dispose();
        }
        this.f_order = null;
        if (this.f_curLine != null) {
            this.f_curLine.dispose();
        }
        this.f_curLine = null;
        if (this.f_functionKeys != null) {
            this.f_functionKeys.dispose();
        }
        this.f_functionKeys = null;
        if (this.f_cashfunctions != null) {
            this.f_cashfunctions.dispose();
        }
        this.f_cashfunctions = null;
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.m_ctx = null;
    }

    private boolean dynInit() {
        if (!this.setMPOS()) {
            return false;
        }
        this.frame.setTitle("Adempiere POS: " + this.p_pos.getName());
        this.f_order = new SubOrder(this);
        this.add((Component)this.f_order, "split 2, flowy, growx, spany");
        this.f_curLine = new SubCurrentLine(this);
        this.add((Component)this.f_curLine, "h 300, growx, growy, gaptop 10");
        this.f_functionKeys = new SubFunctionKeys(this);
        this.add((Component)this.f_functionKeys, "aligny top, h 500, growx, growy, flowy, split 2");
        return true;
    }

    private boolean setMPOS() {
        String title;
        Object[] poss = null;
        poss = this.m_SalesRep_ID == 100 ? this.getPOSs(0) : this.getPOSs(this.m_SalesRep_ID);
        if (poss.length == 0) {
            ADialog.error(this.m_WindowNo, this.m_frame, "NoPOSForUser");
            return false;
        }
        if (poss.length == 1) {
            this.p_pos = poss[0];
            return true;
        }
        String msg = Msg.getMsg((Properties)this.m_ctx, (String)"SelectPOS");
        Object selection = JOptionPane.showInputDialog(this.m_frame, msg, title = Env.getHeader((Properties)this.m_ctx, (int)this.m_WindowNo), 3, null, poss, poss[0]);
        if (selection != null) {
            this.p_pos = (MPOS)selection;
            return true;
        }
        return false;
    }

    private MPOS[] getPOSs(int SalesRep_ID) {
        String pass_field = "SalesRep_ID";
        int pass_ID = SalesRep_ID;
        if (SalesRep_ID == 0) {
            pass_field = "AD_Client_ID";
            pass_ID = Env.getAD_Client_ID((Properties)this.m_ctx);
        }
        return MPOS.getAll((Properties)this.m_ctx, (String)pass_field, (int)pass_ID);
    }

    public Timestamp getToday() {
        return this.m_today;
    }

    public void newOrder() {
        this.log.info("PosPanel.newOrder");
        this.f_order.setC_BPartner_ID(0);
        this.m_order = null;
        this.m_order = PosOrderModel.createOrder(this.p_pos, this.f_order.getBPartner(), trxName);
        this.f_curLine.newLine();
        this.f_curLine.f_name.requestFocusInWindow();
        this.updateInfo();
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public void updateInfo() {
        if (this.m_order != null) {
            this.m_order.reload();
        }
        if (this.f_curLine != null) {
            this.f_curLine.updateTable(this.m_order);
        }
        if (this.f_order != null) {
            this.f_order.updateOrder();
        }
    }

    public void setOldOrder(int m_c_order_id) {
        if (this.m_order != null) {
            this.m_order.deleteOrder();
        }
        this.m_order = m_c_order_id == 0 ? null : new PosOrderModel(this.m_ctx, m_c_order_id, trxName, this.p_pos);
        this.updateInfo();
    }

    public void setOrder(int m_c_order_id) {
        this.m_order = m_c_order_id == 0 ? null : new PosOrderModel(this.m_ctx, m_c_order_id, trxName, this.p_pos);
    }

    public POSKeyboard getKeyboard(int keyLayoutId) {
        if (this.keyboards.containsKey(keyLayoutId)) {
            return this.keyboards.get(keyLayoutId);
        }
        POSKeyboard keyboard = new POSKeyboard(this, keyLayoutId);
        this.keyboards.put(keyLayoutId, keyboard);
        return keyboard;
    }
}

