/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.gui.Hotspots;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPanel
extends JPanel {
    protected Display pages;
    protected PdfFormData currentAcroFormData;
    protected PdfAnnots annotsData;
    protected PageLines pageLines;
    protected AcroRenderer currentFormRenderer;
    protected AcroRenderer currentAnnotRenderer;
    Hotspots displayHotspots;
    Hotspots printHotspots;
    protected Rectangle[] alternateOutlines;
    String altName;
    private int lastIndent = -1;
    PageOffsets currentOffset;
    protected boolean renderPage = false;
    protected boolean IsPrintAutoRotateAndCenter = false;
    boolean usePDFPaperSize = false;
    protected int pageScalingMode = 2;
    protected int displayView = 1;
    private int scrollInterval = 10;
    protected int pageCount = 0;
    private boolean showCrop = false;
    private boolean isNewRotationSet = false;
    protected boolean displayViewportBorder = false;
    protected boolean isDecoding = false;
    protected boolean stopDecoding = false;
    protected int alignment = 1;
    protected int displayRotation = 0;
    private Point current_p;
    protected Rectangle viewableArea = null;
    private Vector_Int merge_level;
    private Vector_Shape merge_outline;
    private boolean[] showDebugLevel;
    private Color[] debugColors;
    private boolean showMerging = false;
    AffineTransform demoAf = null;
    private boolean tooltipsAreInitialised = false;
    private RepaintManager currentManager = RepaintManager.currentManager(this);
    protected int pageNumber = 1;
    protected AffineTransform displayScaling;
    protected AffineTransform viewScaling = null;
    public boolean showAnnotations = true;
    protected boolean formsAvailable = true;
    protected PdfPageData pageData = new PdfPageData();
    private Rectangle lastHighlight = null;
    protected Rectangle cursorBoxOnScreen = null;
    protected Rectangle lastCursorBoxOnScreen = null;
    private boolean drawCrossHairs = false;
    private int boxContained = -1;
    private Color selectedHandleColor = Color.red;
    private int handlesGap = 5;
    private Color outlineColor;
    protected Rectangle currentHighlightedObject = null;
    private Color outlineHighlightColor;
    private Color[] highlightColors;
    private final int strip = 2;
    private Rectangle2D[] outlineZone = null;
    private int[] processedByRegularExpression = null;
    protected int insetW = 0;
    protected int insetH = 0;
    private boolean[] highlightedZonesSelected = null;
    Rectangle userAnnot = null;
    private int defaultSize;
    private int y_size = this.defaultSize = 100;
    private int max_y;
    private int max_x;
    private int x_size = this.defaultSize;
    int[] cx = null;
    int[] cy = null;
    protected float scaling = 1.0f;
    private Vector_String toolTipText;
    private Vector_Rectangle toolTipRectangle;
    private Vector_Int ttType;
    private Vector_Int toolTipPage;
    private int tooltipsCount = 0;
    private int highlightMode = 0;
    public static final int SHOW_OBJECTS = 1;
    public static final int SHOW_LINES = 2;
    public static final int SHOW_BOXES = 4;
    protected int size = 20;
    protected Font highlightFont = null;
    protected Border myBorder = null;
    private static final int OUTLINE_CURRENT = 2;
    private static final int SHOW_SELECTED = 4;
    private static final int TEXT_TOOLTIP = 8;
    private static final int MASTER_TOOLTIP = 16;
    protected DropTarget dropTarget = null;
    protected ObjectStore objectStoreRef = new ObjectStore();
    protected DynamicVectorRenderer currentDisplay = new DynamicVectorRenderer(1, this.objectStoreRef, false);
    Map userAnnotIcons;
    protected boolean useBorder = true;
    private int[] selectionOrder;
    private Rectangle[] areas;
    private Rectangle rectAreas;
    private Object[] linkedItems;
    private int[] parents;
    protected boolean useAcceleration = true;
    private Shape[] fragmentShapes;
    private int x_size_cropped;
    private int y_size_cropped;
    private AffineTransform cursorAf;
    private Rectangle actualBox;
    private boolean drawInteractively = false;
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    private int pageUsedForTransform;
    protected int additionalPageCount = 0;
    protected int xOffset = 0;

    public void initNonPDF(PdfDecoder pdfDecoder) {
        this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
        this.pages.setup(true, null, pdfDecoder);
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        if (this.currentDisplay != null) {
            return this.currentDisplay.getCombinedAreas(rectangle, bl);
        }
        return null;
    }

    protected final void flushToolTips() {
        this.toolTipText = new Vector_String(100);
        this.toolTipRectangle = new Vector_Rectangle(100);
        this.ttType = new Vector_Int(100);
        this.toolTipPage = new Vector_Int(100);
        this.tooltipsCount = 0;
    }

    public final void addMergingDisplayForDebugging(Vector_Int vector_Int, Vector_Shape vector_Shape, int n, Color[] colorArray) {
        this.merge_level = vector_Int;
        this.merge_outline = vector_Shape;
        this.showDebugLevel = new boolean[n];
        this.debugColors = colorArray;
    }

    public final void setDebugView(int n, boolean bl) {
        if (this.showDebugLevel != null) {
            this.showDebugLevel[n] = bl;
        }
    }

    public final BufferedImage getPageAsThumbnail(int n, DynamicVectorRenderer dynamicVectorRenderer) {
        if (dynamicVectorRenderer == null) {
            dynamicVectorRenderer = this.currentDisplay;
            ObjectStore.cachePage(new Integer(this.pageNumber), dynamicVectorRenderer);
        }
        BufferedImage bufferedImage = this.getImageFromRenderer(n, dynamicVectorRenderer, this.pageNumber);
        return bufferedImage;
    }

    protected BufferedImage getImageFromRenderer(int n, DynamicVectorRenderer dynamicVectorRenderer, int n2) {
        int n3 = this.pageData.getMediaBoxHeight(n2);
        int n4 = this.pageData.getMediaBoxX(n2);
        int n5 = this.pageData.getMediaBoxY(n2);
        int n6 = this.pageData.getCropBoxWidth(n2);
        int n7 = this.pageData.getCropBoxHeight(n2);
        int n8 = this.pageData.getCropBoxX(n2);
        int n9 = this.pageData.getCropBoxY(n2);
        if (n9 > 0) {
            n9 = n3 - n7 - n9;
        }
        float f = (float)n / (float)n7;
        int n10 = this.pageData.getRotation(n2);
        int n11 = -1;
        if (n10 == 90 | n10 == 270) {
            int n12 = n6;
            n6 = n7;
            n7 = n12;
            n11 = 1;
            n12 = n8;
            n8 = n9;
            n9 = n12;
        }
        AffineTransform affineTransform = this.getScalingForImage(n2, n10, f);
        int n13 = n4 - n8;
        int n14 = n5 - n9;
        affineTransform.translate(n13, n11 * n14);
        return dynamicVectorRenderer.getPageAsImage(f, n8, n9, n6, n7, n2, affineTransform, 1);
    }

    public final void setHighlightedZones(int n, int[] nArray, int[] nArray2, Shape[] shapeArray, Object[] objectArray, int[] nArray3, Rectangle2D[] rectangle2DArray, boolean[] blArray, Color[] colorArray, int[] nArray4, int[] nArray5) {
        this.cx = nArray;
        this.cy = nArray2;
        this.fragmentShapes = shapeArray;
        this.linkedItems = objectArray;
        this.parents = nArray3;
        this.outlineZone = rectangle2DArray;
        this.processedByRegularExpression = nArray5;
        this.highlightedZonesSelected = blArray;
        this.highlightMode = n;
        this.highlightColors = colorArray;
        this.selectionOrder = nArray4;
        this.alternateOutlines = null;
    }

    private void createToolTip(int n, String string, Rectangle rectangle, int n2) {
        if (!this.tooltipsAreInitialised) {
            this.tooltipsAreInitialised = true;
            this.toolTipText = new Vector_String(100);
            this.toolTipRectangle = new Vector_Rectangle(100);
            this.ttType = new Vector_Int(100);
            this.toolTipPage = new Vector_Int(100);
        }
        this.toolTipRectangle.addElement(rectangle);
        this.toolTipText.addElement(string);
        this.ttType.addElement(n);
        this.toolTipPage.addElement(n2);
        ++this.tooltipsCount;
    }

    public void setDebugDisplay(boolean bl) {
        this.showMerging = bl;
    }

    public final void setInset(int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
    }

    public void ensurePointIsVisible(Point point) {
        super.scrollRectToVisible(new Rectangle(point.x, this.y_size - point.y, this.scrollInterval, this.scrollInterval));
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = null;
        if (this.displayView != 1) {
            dimension = this.pages.getPageSize(this.displayView);
        }
        if (dimension == null) {
            dimension = this.displayRotation == 90 | this.displayRotation == 270 ? new Dimension((int)((float)(this.y_size_cropped + this.insetW + this.insetW) + (float)this.xOffset * this.scaling + (float)(this.additionalPageCount * (this.insetW + this.insetW))), this.x_size_cropped + this.insetH + this.insetH) : new Dimension((int)((float)(this.x_size_cropped + this.insetW + this.insetW) + (float)this.xOffset * this.scaling + (float)(this.additionalPageCount * (this.insetW + this.insetW))), this.y_size_cropped + this.insetH + this.insetH);
        }
        return dimension;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public final Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public void setFoundTextAreas(Rectangle rectangle) {
        this.rectAreas = rectangle;
    }

    public void setHighlightedAreas(Rectangle[] rectangleArray) {
        if (this.displayView != 1) {
            this.areas = null;
            return;
        }
        if (rectangleArray != null) {
            Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (rectangleArray[i] == null) continue;
                rectangleArray2[i] = new Rectangle(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
            }
            this.areas = rectangleArray2;
            this.currentManager.addDirtyRegion(this, 0, 0, this.x_size, this.y_size);
        } else {
            this.areas = null;
        }
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        this.current_p = new Point((int)((point.getX() - (double)this.insetW) / (double)this.scaling), (int)(((double)(this.y_size + this.insetH) - point.getY()) / (double)this.scaling));
        if (this.displayHotspots != null) {
            string = this.displayHotspots.getTooltip(this.current_p, this.userAnnotIcons, this.pageNumber);
        }
        return string;
    }

    public final void updateCursorBoxOnScreen(Rectangle rectangle, Color color) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.displayView != 1) {
            return;
        }
        int n5 = this.x_size;
        int n6 = this.y_size;
        if (rectangle != null) {
            int n7;
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
            int n8 = this.pageData.getCropBoxX(this.pageNumber);
            int n9 = this.pageData.getCropBoxY(this.pageNumber);
            int n10 = this.pageData.getCropBoxWidth(this.pageNumber);
            int n11 = this.pageData.getCropBoxHeight(this.pageNumber);
            if (n4 < n8) {
                n7 = n8 - n4;
                n2 -= n7;
                n4 = n8;
            }
            if (n3 < n9) {
                n7 = n9 - n3;
                n -= n7;
                n3 += n7;
            }
            if (n4 + n2 > n10 + n8 + this.xOffset) {
                n2 = n8 + this.xOffset + n10 - n4;
            }
            if (n3 + n > n9 + n11) {
                n = n9 + n11 - n3;
            }
            this.cursorBoxOnScreen = new Rectangle(n4, n3, n2, n);
        } else {
            this.cursorBoxOnScreen = null;
        }
        this.outlineColor = color;
        n4 = 30;
        n3 = 0;
        if (this.alignment == 2) {
            n2 = this.getBounds().width;
            n = this.getPDFWidth();
            if (this.displayView != 1) {
                n = (int)this.pages.getPageSize(this.displayView).getWidth();
            }
            n3 = (n2 - n) / 2;
        }
        if (this.lastCursorBoxOnScreen != null) {
            if (this.displayRotation == 0 || this.displayRotation == 180) {
                this.currentManager.addDirtyRegion(this, this.insetW + n3, this.insetH, n5 + 5 + this.xOffset, n6);
            } else {
                this.currentManager.addDirtyRegion(this, this.insetH + n3, this.insetW, n6 + 5 + this.xOffset, n5);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            this.currentManager.addDirtyRegion(this, (int)((float)this.cursorBoxOnScreen.x * this.scaling) - n4, (int)((float)(this.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * this.scaling) - n4, (int)((float)this.cursorBoxOnScreen.width * this.scaling) + n4 + n4, (int)((float)this.cursorBoxOnScreen.height * this.scaling) + n4 + n4);
        }
        if (this.viewScaling != null) {
            this.currentManager.markCompletelyDirty(this);
        }
    }

    public void repaintArea(Rectangle rectangle, int n) {
        int n2 = 10;
        if (n2 < this.insetH) {
            n2 = this.insetH;
        }
        if (n2 < this.insetW) {
            n2 = this.insetW;
        }
        this.currentManager.addDirtyRegion(this, (int)((float)rectangle.x * this.scaling) - n2, (int)((float)(n - rectangle.y - rectangle.height) * this.scaling) - n2, (int)((float)(rectangle.x + rectangle.width) * this.scaling) + n2 + n2, (int)((float)(rectangle.y + rectangle.height) * this.scaling) + n2 + n2);
    }

    public final void removeHiglightedObject() {
        if (this.lastHighlight != null) {
            this.currentManager.addDirtyRegion(this, this.lastHighlight.x - 2, this.lastHighlight.y - 2, this.lastHighlight.width + 2 + 2, this.lastHighlight.height + 2 + 2);
            this.currentHighlightedObject = null;
        }
    }

    public final void addHiglightedObject(Rectangle rectangle, Color color) {
        if (this.displayView != 1) {
            return;
        }
        this.currentHighlightedObject = rectangle;
        this.outlineHighlightColor = color;
        if (this.currentHighlightedObject != null && this.currentHighlightedObject != this.lastHighlight) {
            this.currentManager.addDirtyRegion(this, this.currentHighlightedObject.x - 2, this.currentHighlightedObject.y - 2, this.currentHighlightedObject.width + 2 + 2, this.currentHighlightedObject.height + 2 + 2);
            this.lastHighlight = this.currentHighlightedObject;
        }
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (!this.isDecoding && this.cursorBoxOnScreen != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                if (this.cursorAf != null) {
                    graphics2D.setTransform(this.cursorAf);
                    Shape shape = graphics2D.getClip();
                    if (this.alignment == 2 && shape != null) {
                        graphics2D.setClip(null);
                    }
                    this.paintRectangle(graphics2D);
                    graphics2D.setClip(shape);
                    graphics2D.setTransform(affineTransform);
                }
            }
        }
        catch (Exception exception) {
            this.pages.stopGeneratingPage();
            this.pages.flushPageCaches();
        }
        catch (Error error) {
            this.pages.flushPageCaches();
            this.pages.stopGeneratingPage();
            this.paint(graphics);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(graphics);
        } else {
            final Graphics graphics2 = graphics;
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfPanel.this.threadSafePaint(graphics2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void threadSafePaint(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        if (this.displayScaling == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.formsAvailable && this.renderPage && !this.stopDecoding) {
            n2 = this.pageNumber;
            n = this.pageNumber;
            if (this.displayView != 1) {
                n2 = this.pages.getStartPage();
                n = this.pages.getEndPage();
                if (n2 == 0 || n == 0 || this.lastEnd != n || this.lastStart != n2) {
                    this.lastFormPage = -1;
                }
                this.lastEnd = n;
                this.lastStart = n2;
            }
            if (this.lastFormPage != this.pageNumber) {
                this.lastFormPage = this.pageNumber;
                if (this.currentFormRenderer != null && this.currentAcroFormData != null && !this.stopDecoding) {
                    this.currentFormRenderer.displayComponentsOnscreen(n2, n, this, this.scaling, this.displayRotation);
                }
                if (this.showAnnotations && this.currentAnnotRenderer != null && this.annotsData != null && !this.stopDecoding) {
                    this.currentAnnotRenderer.displayComponentsOnscreen(n2, n, this, this.scaling, this.displayRotation);
                }
            }
        }
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("threadsafePaint called " + this.displayView);
        }
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, false, this.pageData, this.insetW, this.insetH);
        n2 = 0;
        if (this.alignment == 2) {
            n = this.getBounds().width;
            int n3 = this.getPDFWidth();
            if (this.displayView != 1) {
                n3 = (int)this.pages.getPageSize(this.displayView).getWidth();
            }
            if (n > n3) {
                n2 = (n - n3) / 2;
                if (this.displayView == 1) {
                    this.lastIndent = n2;
                } else if (this.displayView == 2 && this.lastIndent != -1) {
                    n2 = this.lastIndent;
                    this.lastIndent = -1;
                } else {
                    this.lastIndent = -1;
                }
                graphics2D.translate(n2, 0);
            }
            if (this.formsAvailable) {
                if (this.currentFormRenderer != null && this.currentAcroFormData != null) {
                    this.currentFormRenderer.resetScaledLocation(this.scaling, this.displayRotation, n2);
                }
                if (this.showAnnotations && this.currentAnnotRenderer != null) {
                    this.currentAnnotRenderer.resetScaledLocation(this.scaling, this.displayRotation, n2);
                }
            }
        }
        Rectangle rectangle = null;
        this.pages.initRenderer(this.areas, graphics2D, this.myBorder, n2);
        if (!this.isDecoding || this.drawInteractively) {
            this.actualBox = this.pages.drawPage(this.viewScaling, this.displayScaling, this.pageUsedForTransform);
        } else {
            this.currentDisplay.paintBackground(graphics2D, rectangle);
        }
        if (this.displayView == 1) {
            if (this.rectAreas != null) {
                AffineTransform affineTransform2 = null;
                if (this.viewScaling != null) {
                    affineTransform2 = graphics2D.getTransform();
                    graphics2D.transform(this.viewScaling);
                }
                Composite composite = graphics2D.getComposite();
                graphics2D.setColor(Color.blue);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                if (this.rectAreas != null) {
                    graphics2D.fillRect(this.rectAreas.x, this.rectAreas.y, this.rectAreas.width, this.rectAreas.height);
                }
                graphics2D.setComposite(composite);
                if (this.viewScaling != null) {
                    graphics2D.setTransform(affineTransform2);
                }
            }
            if (this.currentHighlightedObject == null && this.lastHighlight != null) {
                this.lastHighlight = null;
            }
            AffineTransform affineTransform3 = graphics2D.getTransform();
            if (this.viewScaling != null) {
                graphics2D.transform(this.viewScaling);
            }
            if (this.highlightedZonesSelected != null) {
                this.paintHighlights(graphics2D);
            }
            if (this.displayHotspots != null) {
                this.displayHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, this.pageNumber);
            }
            if (this.merge_level != null && this.showMerging) {
                this.paintMergingInfo(graphics2D);
            }
            if (this.cursorBoxOnScreen != null) {
                this.cursorAf = graphics2D.getTransform();
            } else {
                this.actualBox = null;
            }
            this.pages.resetToDefaultClip();
            if (this.currentHighlightedObject != null) {
                graphics2D.setColor(this.outlineHighlightColor);
                graphics2D.draw(this.currentHighlightedObject);
            }
            if (this.showCrop) {
                graphics2D.setColor(Color.orange);
                this.pages.completeForm(graphics2D);
            }
        }
        this.pages.drawBorder();
        graphics2D.setTransform(affineTransform);
    }

    private void paintMergingInfo(Graphics2D graphics2D) {
        int n = this.merge_outline.size() - 1;
        for (int i = 0; i < n; ++i) {
            Area area = this.merge_outline.elementAt(i);
            int n2 = this.merge_level.elementAt(i);
            if (!(this.showDebugLevel[n2] & area != null)) continue;
            graphics2D.setColor(this.debugColors[n2]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.draw(area.getBounds());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(area);
        }
    }

    public void setDrawCrossHairs(boolean bl, int n, Color color) {
        this.drawCrossHairs = bl;
        this.boxContained = n;
        this.selectedHandleColor = color;
    }

    private void paintRectangle(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(1.0f / this.scaling);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(this.outlineColor);
        graphics2D.draw(this.cursorBoxOnScreen);
        if (this.drawCrossHairs) {
            int n6 = this.cursorBoxOnScreen.x;
            n5 = this.cursorBoxOnScreen.y;
            n4 = n6 + this.cursorBoxOnScreen.width;
            n3 = n5 + this.cursorBoxOnScreen.height;
            n2 = this.pageData.getMediaBoxWidth(this.pageNumber);
            int n7 = this.pageData.getMediaBoxHeight(this.pageNumber);
            n = this.pageData.getMediaBoxX(this.pageNumber);
            int n8 = this.pageData.getMediaBoxY(this.pageNumber);
            graphics2D.setStroke(new BasicStroke(3.0f / this.scaling, 1, 1, 0.0f, new float[]{0.0f, 6.0f / this.scaling, 0.0f, 6.0f / this.scaling}, 0.0f));
            graphics2D.drawLine(n6, n5, n, n5);
            graphics2D.drawLine(n6, n5, n6, n8);
            graphics2D.drawLine(n4, n5, n2, n5);
            graphics2D.drawLine(n4, n5, n4, n8);
            graphics2D.drawLine(n6, n3, n, n3);
            graphics2D.drawLine(n6, n3, n6, n7);
            graphics2D.drawLine(n4, n3, n2, n3);
            graphics2D.drawLine(n4, n3, n4, n7);
            Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n6 - this.handlesGap, n5 + Math.abs(n3 - n5) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 + Math.abs(n4 - n6) / 2 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 + Math.abs(n4 - n6) / 2 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n5 + Math.abs(n3 - n5) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2)};
            graphics2D.setStroke(basicStroke);
            if (this.boxContained != -1 && this.boxContained < rectangleArray.length) {
                if (this.selectedHandleColor != null) {
                    Color color = graphics2D.getColor();
                    graphics2D.setColor(this.selectedHandleColor);
                    graphics2D.fill(rectangleArray[this.boxContained]);
                    graphics2D.setColor(color);
                } else {
                    graphics2D.fill(rectangleArray[this.boxContained]);
                }
            }
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (i == this.boxContained) continue;
                graphics2D.draw(rectangleArray[i]);
            }
        }
        graphics2D.setStroke(stroke);
        if (this.actualBox == null) {
            this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
        } else {
            Rectangle rectangle = this.cursorBoxOnScreen.getBounds();
            n5 = (int)rectangle.getMinX();
            n4 = (int)rectangle.getMinY();
            n3 = (int)rectangle.getMaxX();
            n2 = (int)rectangle.getMaxY();
            Rectangle rectangle2 = this.actualBox.getBounds();
            n = (int)rectangle2.getMinX();
            if (n < n5) {
                n5 = n;
            }
            if ((n = (int)rectangle2.getMinY()) < n4) {
                n4 = n;
            }
            if ((n = (int)rectangle2.getMaxX()) > n3) {
                n3 = n;
            }
            if ((n = (int)rectangle2.getMaxY()) > n2) {
                n2 = n;
            }
            this.lastCursorBoxOnScreen = new Rectangle(n5 - 5, n4 - 5, 10 + n3 - n5, 10 + (n2 - n4));
        }
    }

    private void paintHighlights(Graphics2D graphics2D) {
        if (this.alternateOutlines != null) {
            int n;
            int n2 = this.alternateOutlines.length;
            for (n = 0; n < n2; ++n) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                graphics2D.setColor(Color.darkGray);
                graphics2D.fill(this.alternateOutlines[n]);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
                graphics2D.draw(this.alternateOutlines[n]);
            }
            if (this.merge_outline != null && !this.altName.equals("Nothing") && !this.altName.equals("Lines")) {
                n = this.merge_outline.size() - 1;
                for (int i = 0; i < n; ++i) {
                    Area area = this.merge_outline.elementAt(i);
                    int n3 = this.merge_level.elementAt(i);
                    if (!(n3 == 2 & area != null)) continue;
                    graphics2D.setColor(this.debugColors[n3]);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                    graphics2D.draw(area.getBounds());
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
                    graphics2D.fill(area);
                }
            }
        } else {
            int n = this.highlightedZonesSelected.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray;
                if (this.highlightedZonesSelected[i]) {
                    this.highlightStoryOnscreen(graphics2D, i);
                    continue;
                }
                if ((this.highlightMode & 1) != 1 || this.fragmentShapes[i] == null) continue;
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                if (this.highlightColors[i] == null) {
                    graphics2D.setColor(Color.darkGray);
                } else {
                    graphics2D.setColor(this.highlightColors[i]);
                }
                graphics2D.fill(this.fragmentShapes[i]);
                graphics2D.draw(this.outlineZone[i]);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
                graphics2D.draw(this.outlineZone[i]);
                if (this.linkedItems == null || (nArray = (int[])this.linkedItems[i]) == null) continue;
                this.numberItems(false, graphics2D, i + "-", nArray);
            }
            if (this.pageLines != null && (this.highlightMode & 2) == 2) {
                this.pageLines.drawLines(graphics2D);
            }
            if (this.pageLines != null && (this.highlightMode & 4) == 4) {
                this.pageLines.drawBoxes(graphics2D);
            }
            if (this.selectionOrder != null) {
                this.numberItems(false, graphics2D, "", this.selectionOrder);
            }
        }
    }

    private void highlightStoryOnscreen(Graphics2D graphics2D, int n) {
        if (this.fragmentShapes[n] != null) {
            if (this.highlightColors[n] == null) {
                graphics2D.setColor(Color.blue);
            } else {
                graphics2D.setColor(this.highlightColors[n]);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.fill(this.fragmentShapes[n]);
            graphics2D.draw(this.outlineZone[n]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
            graphics2D.draw(this.outlineZone[n]);
            int n2 = this.outlineZone[n].getBounds().x;
            int n3 = this.outlineZone[n].getBounds().y;
            graphics2D.drawLine(n2, n3 + (int)this.outlineZone[n].getBounds().getHeight(), n2 + (int)this.outlineZone[n].getBounds().getWidth(), n3);
            if (this.processedByRegularExpression[n] > 0) {
                graphics2D.drawLine(n2 + (int)this.outlineZone[n].getBounds().getWidth(), n3 + (int)this.outlineZone[n].getBounds().getHeight(), n2, n3);
            }
        }
    }

    private void numberItems(boolean bl, Graphics2D graphics2D, String string, int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[0];
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            if (n4 == -1) {
                i = n;
                continue;
            }
            String string2 = string + "" + n3;
            if (this.linkedItems == null) {
                if (this.fragmentShapes[n4] != null) {
                    this.numberItem(graphics2D, n4, string2);
                }
                ++n3;
                continue;
            }
            int[] nArray2 = (int[])this.linkedItems[n4];
            if (nArray2 != null) {
                ++n3;
                int n5 = nArray2.length;
                int n6 = 0;
                for (int j = 0; j < n5; ++j) {
                    int n7 = nArray2[j];
                    ++n6;
                    if (n7 == -1) {
                        j = n5;
                        continue;
                    }
                    if (this.fragmentShapes[n4] == null) continue;
                    this.numberItem(graphics2D, n7, string2 + "." + n6);
                }
                continue;
            }
            if (this.parents[n4] != -1) continue;
            if (this.fragmentShapes[n4] != null) {
                this.numberItem(graphics2D, n4, string2);
            }
            ++n3;
        }
    }

    private void numberItem(Graphics2D graphics2D, int n, String string) {
        AffineTransform affineTransform = new AffineTransform();
        GlyphVector glyphVector = this.highlightFont.createGlyphVector(graphics2D.getFontRenderContext(), string);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(this.cx[n], -this.cy[n]);
        Area area = new Area(glyphVector.getOutline());
        area.transform(affineTransform);
        graphics2D.setColor(Color.black);
        graphics2D.fill(area.getBounds());
        graphics2D.setColor(Color.white);
        graphics2D.fill(area);
    }

    private void flagNumbersForRedraw(int n) {
        if (this.selectionOrder != null && this.cx != null && this.cy != null) {
            for (int i = 0; i < this.selectionOrder.length; ++i) {
                int n2 = this.selectionOrder[i];
                if (n2 == -1) {
                    i = this.selectionOrder.length;
                    continue;
                }
                this.currentManager.addDirtyRegion(this, (int)((float)this.cx[n2] * this.scaling), (int)((float)(n - this.cy[n2] - 25) * this.scaling), (int)(25.0f * this.scaling), (int)(25.0f * this.scaling));
                int[] nArray = (int[])this.linkedItems[n2];
                if (nArray == null) continue;
                for (int j = 0; j < nArray.length; ++j) {
                    int n3 = nArray[j];
                    if (n3 == -1) {
                        j = nArray.length;
                        continue;
                    }
                    this.currentManager.addDirtyRegion(this, (int)((float)this.cx[n3] * this.scaling), (int)((float)(n - this.cy[n3] - 25) * this.scaling), (int)(25.0f * this.scaling), (int)(25.0f * this.scaling));
                }
            }
        }
    }

    public final int getPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getRawPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size;
        }
        return this.x_size;
    }

    public void setMessageFrame(JFrame jFrame) {
        this.currentDisplay.setMessageFrame(jFrame);
    }

    public final int getPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final int getRawPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size;
        }
        return this.y_size;
    }

    public Rectangle[] getPageHotspots() {
        if (this.displayHotspots != null) {
            return this.displayHotspots.getAnnotationhotSpots();
        }
        return null;
    }

    public void disableBorderForPrinting() {
        this.useBorder = false;
    }

    public final void setPDFBorder(Border border) {
        this.myBorder = border;
        this.useBorder = true;
    }

    protected final AffineTransform getScalingForImage(int n, int n2, float f) {
        double d = (float)this.pageData.getMediaBoxX(n) * f;
        double d2 = (float)this.pageData.getMediaBoxY(n) * f;
        double d3 = (float)this.pageData.getMediaBoxHeight(n) * f;
        double d4 = (float)this.pageData.getCropBoxWidth(n) * f;
        double d5 = (float)this.pageData.getCropBoxHeight(n) * f;
        double d6 = (float)this.pageData.getCropBoxX(n) * f;
        double d7 = (float)this.pageData.getCropBoxY(n) * f;
        AffineTransform affineTransform = new AffineTransform();
        int n3 = (int)(d4 + (d6 - d));
        int n4 = (int)(d5 + (d7 - d2));
        if (n2 == 270) {
            affineTransform.rotate(-1.5707963267948966, n3 / 2, n4 / 2);
            double d8 = affineTransform.getTranslateX();
            double d9 = affineTransform.getTranslateY();
            affineTransform.translate((double)n4 - d9, -d8);
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-(d6 + d), -(d3 - d5 - (d7 - d2)));
        } else if (n2 == 180) {
            affineTransform.rotate(Math.PI, n3 / 2, n4 / 2);
            affineTransform.translate(-(d6 + d), (double)n4 + (d7 + d2) - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else if (n2 == 90) {
            affineTransform.rotate(1.5707963267948966);
            affineTransform.translate(0.0, d7 + d2 - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -(d3 - d5 - (d7 - d2)));
        }
        affineTransform.scale(f, f);
        return affineTransform;
    }

    public final void setPageRotation(int n) {
        this.displayRotation = n;
        if (this.displayView != 1) {
            n = 0;
        }
        this.pageUsedForTransform = this.pageNumber;
        this.displayScaling = this.getScalingForImage(this.pageNumber, n, this.scaling);
        if (n == 90) {
            this.displayScaling.translate((float)this.insetH / this.scaling, (float)this.insetW / this.scaling);
        } else if (n == 270) {
            this.displayScaling.translate((float)(-this.insetH) / this.scaling, (float)(-this.insetW) / this.scaling);
        } else if (n == 180) {
            this.displayScaling.translate((float)(-this.insetW) / this.scaling, (float)this.insetH / this.scaling);
        } else {
            this.displayScaling.translate((float)this.insetW / this.scaling, (float)(-this.insetH) / this.scaling);
        }
        this.pages.refreshDisplay();
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            double d = (double)this.viewableArea.width / (double)this.pageData.getCropBoxWidth(this.pageNumber);
            double d2 = (double)this.viewableArea.height / (double)this.pageData.getCropBoxHeight(this.pageNumber);
            double d3 = d;
            if (d2 < d) {
                d3 = d2;
            }
            double d4 = this.viewableArea.x;
            double d5 = (double)this.viewableArea.y + ((double)this.viewableArea.height - (double)this.pageData.getCropBoxHeight(this.pageNumber) * d3);
            this.viewScaling.translate(d4, d5);
            this.viewScaling.scale(d3, d3);
        } else {
            this.viewScaling = null;
        }
    }

    public final void setPageParameters(float f, int n, int n2) {
        if (this.pages != null) {
            this.pages.setScaling(f);
        }
        this.isNewRotationSet = true;
        this.displayRotation = n2;
        this.setPageParameters(f, n);
    }

    public final void setPageParameters(float f, int n) {
        this.pageNumber = n;
        this.scaling = f;
        int n2 = this.pageData.getMediaBoxWidth(n);
        this.max_y = this.pageData.getMediaBoxHeight(n);
        this.max_x = this.pageData.getMediaBoxWidth(n);
        int n3 = this.pageData.getCropBoxWidth(n);
        int n4 = this.pageData.getCropBoxHeight(n);
        this.x_size_cropped = (int)((float)n3 * f);
        this.y_size_cropped = (int)((float)n4 * f);
        this.x_size = (int)((float)n3 * f);
        this.y_size = (int)((float)n4 * f);
        if (!this.isNewRotationSet) {
            this.displayRotation = this.pageData.getRotation(n);
        } else {
            this.isNewRotationSet = false;
        }
        this.currentDisplay.init(n2, this.max_y, this.displayRotation);
        this.setPageRotation(this.displayRotation);
    }

    protected final AffineTransform setPageParametersForImage(float f, int n) {
        int n2;
        AffineTransform affineTransform = new AffineTransform();
        int n3 = this.pageData.getCropBoxWidth(n);
        int n4 = this.pageData.getCropBoxHeight(n);
        int n5 = this.pageData.getCropBoxX(n);
        int n6 = this.pageData.getCropBoxY(n);
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            n2 = n3;
            n3 = n4;
            n4 = n2;
        }
        n2 = (int)((float)n3 * f);
        int n7 = (int)((float)n4 * f);
        int n8 = this.pageData.getRotation(n);
        affineTransform.translate((float)(-n5) * f, (float)n6 * f);
        if (n8 == 270) {
            affineTransform.rotate(-1.5707963267948966, n2 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            affineTransform.translate((double)n7 - d2, -d);
        } else if (n8 == 180) {
            affineTransform.rotate(Math.PI, n2 / 2, n7 / 2);
        } else if (n8 == 90) {
            affineTransform.rotate(1.5707963267948966, n2 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate(-d3, (double)n2 - d);
        }
        if (f < 1.0f) {
            affineTransform.translate(n2, n7);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n2, 0.0);
            affineTransform.scale(f, f);
        } else {
            affineTransform.translate(n2, n7);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n2, 0.0);
            affineTransform.scale(f, f);
        }
        return affineTransform;
    }

    public void setHardwareAccelerationforScreen(boolean bl) {
        this.useAcceleration = bl;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int n) {
        this.scrollInterval = n;
    }

    public void setAnnotationsVisible(boolean bl) {
        this.showAnnotations = bl;
    }

    public void setDrawInteractively(boolean bl) {
        this.drawInteractively = bl;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public int getPrintPageScalingMode() {
        return this.pageScalingMode;
    }

    public void setPrintPageScalingMode(int n) {
        this.pageScalingMode = n;
    }

    public void setUsePDFPaperSize(boolean bl) {
        this.usePDFPaperSize = bl;
    }
}

