/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Map;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class TrueType
extends PdfFont {
    public TrueType() {
    }

    public void readFontData(byte[] byArray) {
        LogWriter.writeMethod("{readFontData}", 0);
        this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, byArray);
    }

    protected void substituteFontUsed(String string, String string2) throws PdfFontException {
        InputStream inputStream = null;
        try {
            inputStream = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
        }
        if (inputStream == null) {
            throw new PdfFontException("Unable to load font " + string);
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65535];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.close();
            this.readFontData(byteArrayOutputStream.toByteArray());
            this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), true, this.isCIDFont);
            this.isFontEmbedded = true;
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
        }
    }

    public TrueType(String string) {
        this.glyphs = new TTGlyphs();
        this.init(null);
        this.substituteFont = string;
    }

    public TrueType(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new TTGlyphs();
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    public Map createFont(Map map, String string, boolean bl, Map map2, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readTrueTypeFont}" + map, 0);
        this.fontTypes = 2;
        Map map3 = super.createFont(map, string, bl, map2, objectStore);
        if (bl) {
            Object object;
            Object object2;
            if (map3 != null) {
                object2 = map3.get("FontFile2");
                try {
                    if (object2 != null) {
                        object = object2 instanceof String ? (Object)this.currentPdfFile.readStream((String)object2, true) : (Object)((byte[])((Map)object2).get("DecodedStream"));
                        this.readEmbeddedFont((byte[])object, this.hasEncoding, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                int n;
                if (this.glyphs.remapFont) {
                    this.glyphs.remapFont = false;
                }
                object2 = (object = this.loader.getResourceAsStream(this.substituteFont)) == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream((InputStream)object);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[65535];
                while ((n = ((FilterInputStream)object2).read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                ((BufferedInputStream)object2).close();
                this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), false, true);
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(map);
        if (bl) {
            this.setFont(this.glyphs.fontName, 1);
        }
        return map3;
    }

    public void createFont(String string) throws Exception {
        int n;
        this.fontTypes = 2;
        this.setBaseFontName(string);
        InputStream inputStream = this.loader.getResourceAsStream(this.substituteFont);
        BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65535];
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        bufferedInputStream.close();
        this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), false, true);
        this.isFontSubstituted = true;
    }

    protected final void readEmbeddedFont(byte[] byArray, boolean bl, boolean bl2) {
        LogWriter.writeMethod("{readEmbeddedFont}", 0);
        try {
            LogWriter.writeLog("Embedded TrueType font used");
            this.readFontData(byArray);
            this.isFontEmbedded = true;
            this.glyphs.setEncodingToUse(bl, this.getFontEncoding(false), bl2, this.TTstreamisCID);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " processing TrueType font");
            exception.printStackTrace();
        }
    }
}

