/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InvoiceGenerateRMA
extends SvrProcess {
    private boolean p_Selection = false;
    private String p_docAction = "CO";
    private int m_created = 0;
    private Timestamp m_dateinvoiced = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Selection")) {
                    this.p_Selection = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_dateinvoiced = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        if (this.m_dateinvoiced == null) {
            this.m_dateinvoiced = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        block7: {
            if (!this.p_Selection) {
                throw new IllegalStateException("Shipments can only be generated from selection");
            }
            String sql = "SELECT rma.M_RMA_ID FROM M_RMA rma, T_Selection WHERE rma.DocStatus='CO' AND rma.IsSOTrx='Y' AND rma.AD_Client_ID=? AND rma.M_RMA_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    pstmt.setInt(2, this.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.generateInvoice(rs.getInt(1));
                    }
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sql, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }

    private int getInvoiceDocTypeId(int M_RMA_ID) {
        String docTypeSQl = "SELECT dt.C_DocTypeInvoice_ID FROM C_DocType dt INNER JOIN M_RMA rma ON dt.C_DocType_ID=rma.C_DocType_ID WHERE rma.M_RMA_ID=?";
        int docTypeId = DB.getSQLValue(null, (String)docTypeSQl, (int)M_RMA_ID);
        return docTypeId;
    }

    private MInvoice createInvoice(MRMA rma) {
        int docTypeId = this.getInvoiceDocTypeId(rma.get_ID());
        if (docTypeId == -1) {
            throw new IllegalStateException("Could not get invoice document type for Vendor RMA");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setRMA(rma);
        invoice.setC_DocTypeTarget_ID(docTypeId);
        if (!invoice.save()) {
            throw new IllegalStateException("Could not create invoice");
        }
        return invoice;
    }

    private MInvoiceLine[] createInvoiceLines(MRMA rma, MInvoice invoice) {
        MRMALine[] rmaLines;
        ArrayList<MInvoiceLine> invLineList = new ArrayList<MInvoiceLine>();
        MRMALine[] mRMALineArray = rmaLines = rma.getLines(true);
        int n = rmaLines.length;
        int n2 = 0;
        while (n2 < n) {
            MRMALine rmaLine = mRMALineArray[n2];
            if (rmaLine.getM_InOutLine_ID() == 0 && rmaLine.getC_Charge_ID() == 0) {
                StringBuilder msgiste = new StringBuilder("No customer return line - RMA = ").append(rma.getDocumentNo()).append(", Line = ").append(rmaLine.getLine());
                throw new IllegalStateException(msgiste.toString());
            }
            MInvoiceLine invLine = new MInvoiceLine(invoice);
            invLine.setRMALine(rmaLine);
            if (!invLine.save()) {
                throw new IllegalStateException("Could not create invoice line");
            }
            invLineList.add(invLine);
            ++n2;
        }
        MInvoiceLine[] invLines = new MInvoiceLine[invLineList.size()];
        invLineList.toArray(invLines);
        return invLines;
    }

    private void generateInvoice(int M_RMA_ID) {
        MRMA rma = new MRMA(this.getCtx(), M_RMA_ID, this.get_TrxName());
        this.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Processing")) + " " + rma.getDocumentInfo());
        MInvoice invoice = this.createInvoice(rma);
        MInvoiceLine[] invoiceLines = this.createInvoiceLines(rma, invoice);
        if (invoiceLines.length == 0) {
            StringBuilder msglog = new StringBuilder("No invoice lines created: M_RMA_ID=").append(M_RMA_ID).append(", M_Invoice_ID=").append(invoice.get_ID());
            this.log.log(Level.WARNING, msglog.toString());
        }
        StringBuilder processMsg = new StringBuilder().append(invoice.getDocumentNo());
        if (!invoice.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            StringBuilder msg = new StringBuilder("Invoice Processing failed: ").append(invoice).append(" - ").append(invoice.getProcessMsg());
            this.log.warning(msg.toString());
            throw new IllegalStateException(msg.toString());
        }
        if (!invoice.save()) {
            throw new IllegalStateException("Could not update invoice");
        }
        String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@InvoiceProcessed@ " + processMsg.toString()));
        this.addLog(invoice.getC_Invoice_ID(), invoice.getDateInvoiced(), null, message, invoice.get_Table_ID(), invoice.getC_Invoice_ID());
        ++this.m_created;
    }
}

