/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.util.logging.Level;
import org.compiere.model.MLanguage;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class LanguageMaintenance
extends SvrProcess {
    private int p_AD_Language_ID = 0;
    private String p_MaintenanceMode = null;
    public static String MAINTENANCEMODE_Add = "A";
    public static String MAINTENANCEMODE_Delete = "D";
    public static String MAINTENANCEMODE_ReCreate = "R";
    private MLanguage m_language = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("MaintenanceMode")) {
                    this.p_MaintenanceMode = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_AD_Language_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.m_language = new MLanguage(this.getCtx(), this.p_AD_Language_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Mode=" + this.p_MaintenanceMode + ", ID=" + this.p_AD_Language_ID + " - " + this.m_language);
        }
        if (this.m_language.isBaseLanguage()) {
            throw new Exception("Base Language has no Translations");
        }
        int deleteNo = 0;
        int insertNo = 0;
        if (MAINTENANCEMODE_Delete.equals(this.p_MaintenanceMode) || MAINTENANCEMODE_ReCreate.equals(this.p_MaintenanceMode)) {
            deleteNo = this.m_language.maintain(false);
        }
        if (MAINTENANCEMODE_Add.equals(this.p_MaintenanceMode) || MAINTENANCEMODE_ReCreate.equals(this.p_MaintenanceMode)) {
            if (this.m_language.isActive() && this.m_language.isSystemLanguage()) {
                insertNo = this.m_language.maintain(true);
                this.m_language.setIsLoginLocale(true);
                this.m_language.saveEx();
            } else {
                throw new Exception("Language not active System Language");
            }
        }
        if (MAINTENANCEMODE_Delete.equals(this.p_MaintenanceMode) && this.m_language.isSystemLanguage()) {
            this.m_language.setIsSystemLanguage(false);
            this.m_language.saveEx();
        }
        StringBuilder msgreturn = new StringBuilder("@Deleted@=").append(deleteNo).append(" - @Inserted@=").append(insertNo);
        return msgreturn.toString();
    }
}

