/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_I_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportOrder
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_docAction = "PR";
    private Timestamp m_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("DocAction")) {
                this.m_docAction = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        int noInsertLine;
        int noInsert;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        block115: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block113: {
                sql = null;
                no = 0;
                clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
                if (this.m_deleteOldImported) {
                    sql = new StringBuilder("DELETE I_Order ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Delete Old Impored =" + no);
                    }
                }
                sql = new StringBuilder("UPDATE I_Order ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, SysDate),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Reset=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Org=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName").append(" AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PO DocType=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName").append(" AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set SO DocType=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName").append(" AND d.DocBaseType IN ('SOO','POO') AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set DocType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocTypeName, ' ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid DocTypeName=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PO Default DocType=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set SO Default DocType=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType IN('SOO','POO') AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default DocType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No DocType, ' ").append("WHERE C_DocType_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No DocType=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o SET IsSOTrx='Y' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set IsSOTrx=Y=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o SET IsSOTrx='N' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set IsSOTrx=N=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default Currency PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Currency PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PriceList=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PriceList, ' ").append("WHERE M_PriceList_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_OrderSource_ID=(SELECT C_OrderSource_ID FROM C_OrderSource p").append(" WHERE o.C_OrderSourceValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Order Source=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Not Found Order Source, ' ").append("WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No OrderSource=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p").append(" WHERE o.PaymentTermValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND PaymentTermValue IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PaymentTerm=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p").append(" WHERE p.IsDefault='Y' AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND o.PaymentTermValue IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default PaymentTerm=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PaymentTerm, ' ").append("WHERE C_PaymentTerm_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No PaymentTerm=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order o ").append("SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w").append(" WHERE o.AD_Client_ID=w.AD_Client_ID AND o.AD_Org_ID=w.AD_Org_ID) ").append("WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Warehouse=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order o ").append("SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w").append(" WHERE o.AD_Client_ID=w.AD_Client_ID) ").append("WHERE M_Warehouse_ID IS NULL").append(" AND EXISTS (SELECT AD_Client_ID FROM M_Warehouse w WHERE w.AD_Client_ID=o.AD_Client_ID GROUP BY AD_Client_ID HAVING COUNT(*)=1)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Only Client Warehouse=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' ").append("WHERE M_Warehouse_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No Warehouse=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u").append(" WHERE o.EMail=u.EMail AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) ").append("WHERE C_BPartner_ID IS NULL AND EMail IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP from EMail=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u").append(" WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) ").append("WHERE C_BPartner_ID IS NULL AND ContactName IS NOT NULL").append(" AND EXISTS (SELECT Name FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL GROUP BY Name HAVING COUNT(*)=1)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP from ContactName=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp").append(" WHERE o.BPartnerValue=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP from Value=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_BPartner_ID=(SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo c").append(" WHERE o.AD_Client_ID=c.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NULL AND Name IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default BP=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET (BillTo_ID,C_BPartner_Location_ID)=(SELECT C_BPartner_Location_ID,C_BPartner_Location_ID").append(" FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID)").append(" WHERE o.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=o.AD_Client_ID").append(" AND DUMP(o.Address1)=DUMP(l.Address1) AND DUMP(o.Address2)=DUMP(l.Address2)").append(" AND DUMP(o.City)=DUMP(l.City) AND DUMP(o.Postal)=DUMP(l.Postal)").append(" AND o.C_Region_ID=l.C_Region_ID AND o.C_Country_ID=l.C_Country_ID) ").append("WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Found Location=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET BillTo_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l").append(" WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID").append(" AND ((l.IsBillTo='Y' AND o.IsSOTrx='Y') OR (l.IsPayFrom='Y' AND o.IsSOTrx='N'))").append(") ").append("WHERE C_BPartner_ID IS NOT NULL AND BillTo_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP BillTo from BP=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_BPartner_Location_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l").append(" WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID").append(" AND ((l.IsShipTo='Y' AND o.IsSOTrx='Y') OR o.IsSOTrx='N')").append(") ").append("WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP Location from BP=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BP Location, ' ").append("WHERE C_BPartner_ID IS NOT NULL AND (BillTo_ID IS NULL OR C_BPartner_Location_ID IS NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No BP Location=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c").append(" WHERE o.CountryCode=c.CountryCode AND c.AD_Client_ID IN (0, o.AD_Client_ID)) ").append("WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND CountryCode IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Country=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Country, ' ").append("WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Country=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("Set RegionName=(SELECT MAX(Name) FROM C_Region r").append(" WHERE r.IsDefault='Y' AND r.C_Country_ID=o.C_Country_ID").append(" AND r.AD_Client_ID IN (0, o.AD_Client_ID)) ").append("WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Region Default=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r").append(" WHERE r.Name=o.RegionName AND r.C_Country_ID=o.C_Country_ID").append(" AND r.AD_Client_ID IN (0, o.AD_Client_ID)) ").append("WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Region=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Region, ' ").append("WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL ").append(" AND EXISTS (SELECT * FROM C_Country c").append(" WHERE c.C_Country_ID=o.C_Country_ID AND c.HasRegion='Y')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Region=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.ProductValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product from Value=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.UPC=p.UPC AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND UPC IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product from UPC=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.SKU=p.SKU AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND SKU IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product fom SKU=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' ").append("WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Product=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge c").append(" WHERE o.ChargeName=c.Name AND o.AD_Client_ID=c.AD_Client_ID) ").append("WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Charge=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Charge, ' ").append("WHERE C_Charge_ID IS NULL AND (ChargeName IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Charge=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Product and Charge, ' ").append("WHERE M_Product_ID IS NOT NULL AND C_Charge_ID IS NOT NULL ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Product and Charge exclusive=" + no);
                }
                sql = new StringBuilder("UPDATE I_Order o ").append("SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t").append(" WHERE o.TaxIndicator=t.TaxIndicator AND o.AD_Client_ID=t.AD_Client_ID) ").append("WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Tax=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Tax, ' ").append("WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Tax=" + no);
                }
                this.commitEx();
                sql = new StringBuilder("SELECT * FROM I_Order ").append("WHERE I_IsImported='N' AND C_BPartner_ID IS NULL").append((CharSequence)clientCheck);
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MBPartner bp;
                            X_I_Order imp = new X_I_Order(this.getCtx(), rs, this.get_TrxName());
                            if (imp.getBPartnerValue() == null) {
                                if (imp.getEMail() != null) {
                                    imp.setBPartnerValue(imp.getEMail());
                                } else {
                                    if (imp.getName() == null) continue;
                                    imp.setBPartnerValue(imp.getName());
                                }
                            }
                            if (imp.getName() == null) {
                                if (imp.getContactName() != null) {
                                    imp.setName(imp.getContactName());
                                } else {
                                    imp.setName(imp.getBPartnerValue());
                                }
                            }
                            if ((bp = MBPartner.get((Properties)this.getCtx(), (String)imp.getBPartnerValue())) == null) {
                                bp = new MBPartner(this.getCtx(), -1, this.get_TrxName());
                                bp.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                                bp.setValue(imp.getBPartnerValue());
                                bp.setName(imp.getName());
                                if (!bp.save()) continue;
                            }
                            imp.setC_BPartner_ID(bp.getC_BPartner_ID());
                            MBPartnerLocation bpl = null;
                            MBPartnerLocation[] bpls = bp.getLocations(true);
                            int i = 0;
                            while (bpl == null && i < bpls.length) {
                                MLocation loc;
                                if (imp.getC_BPartner_Location_ID() == bpls[i].getC_BPartner_Location_ID()) {
                                    bpl = bpls[i];
                                } else if (imp.getC_Location_ID() == bpls[i].getC_Location_ID()) {
                                    bpl = bpls[i];
                                } else if (imp.getC_Location_ID() == 0 && (loc = bpls[i].getLocation(false)).equals(imp.getC_Country_ID(), imp.getC_Region_ID(), imp.getPostal(), "", imp.getCity(), imp.getAddress1(), imp.getAddress2())) {
                                    bpl = bpls[i];
                                }
                                ++i;
                            }
                            if (bpl == null) {
                                MLocation loc = new MLocation(this.getCtx(), 0, this.get_TrxName());
                                loc.setAddress1(imp.getAddress1());
                                loc.setAddress2(imp.getAddress2());
                                loc.setCity(imp.getCity());
                                loc.setPostal(imp.getPostal());
                                if (imp.getC_Region_ID() != 0) {
                                    loc.setC_Region_ID(imp.getC_Region_ID());
                                }
                                loc.setC_Country_ID(imp.getC_Country_ID());
                                if (!loc.save()) continue;
                                bpl = new MBPartnerLocation(bp);
                                bpl.setC_Location_ID(loc.getC_Location_ID());
                                if (!bpl.save()) continue;
                            }
                            imp.setC_Location_ID(bpl.getC_Location_ID());
                            imp.setBillTo_ID(bpl.getC_BPartner_Location_ID());
                            imp.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                            if (imp.getContactName() != null || imp.getEMail() != null || imp.getPhone() != null) {
                                MUser[] users = bp.getContacts(true);
                                MUser user = null;
                                int i2 = 0;
                                while (user == null && i2 < users.length) {
                                    String name = users[i2].getName();
                                    if (name.equals(imp.getContactName()) || name.equals(imp.getName())) {
                                        user = users[i2];
                                        imp.setAD_User_ID(user.getAD_User_ID());
                                    }
                                    ++i2;
                                }
                                if (user == null) {
                                    user = new MUser((X_C_BPartner)bp);
                                    if (imp.getContactName() == null) {
                                        user.setName(imp.getName());
                                    } else {
                                        user.setName(imp.getContactName());
                                    }
                                    user.setEMail(imp.getEMail());
                                    user.setPhone(imp.getPhone());
                                    if (user.save()) {
                                        imp.setAD_User_ID(user.getAD_User_ID());
                                    }
                                }
                            }
                            imp.save();
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, "BP - " + sql.toString(), (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block113;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner, ' ").append("WHERE C_BPartner_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (no != 0) {
                this.log.warning("No BPartner=" + no);
            }
            this.commitEx();
            noInsert = 0;
            noInsertLine = 0;
            sql = new StringBuilder("SELECT * FROM I_Order ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY C_BPartner_ID, BillTo_ID, C_BPartner_Location_ID, I_Order_ID");
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    int oldC_BPartner_ID = 0;
                    int oldBillTo_ID = 0;
                    int oldC_BPartner_Location_ID = 0;
                    String oldDocumentNo = "";
                    MOrder order = null;
                    int lineNo = 0;
                    while (rs.next()) {
                        X_I_Order imp = new X_I_Order(this.getCtx(), rs, this.get_TrxName());
                        String cmpDocumentNo = imp.getDocumentNo();
                        if (cmpDocumentNo == null) {
                            cmpDocumentNo = "";
                        }
                        if (oldC_BPartner_ID != imp.getC_BPartner_ID() || oldC_BPartner_Location_ID != imp.getC_BPartner_Location_ID() || oldBillTo_ID != imp.getBillTo_ID() || !oldDocumentNo.equals(cmpDocumentNo)) {
                            if (order != null) {
                                if (this.m_docAction != null && this.m_docAction.length() > 0) {
                                    order.setDocAction(this.m_docAction);
                                    if (!order.processIt(this.m_docAction)) {
                                        this.log.warning("Order Process Failed: " + order + " - " + order.getProcessMsg());
                                        throw new IllegalStateException("Order Process Failed: " + order + " - " + order.getProcessMsg());
                                    }
                                }
                                order.saveEx();
                            }
                            oldC_BPartner_ID = imp.getC_BPartner_ID();
                            oldC_BPartner_Location_ID = imp.getC_BPartner_Location_ID();
                            oldBillTo_ID = imp.getBillTo_ID();
                            oldDocumentNo = imp.getDocumentNo();
                            if (oldDocumentNo == null) {
                                oldDocumentNo = "";
                            }
                            order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                            order.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                            order.setC_DocTypeTarget_ID(imp.getC_DocType_ID());
                            order.setIsSOTrx(imp.isSOTrx());
                            if (imp.getDeliveryRule() != null) {
                                order.setDeliveryRule(imp.getDeliveryRule());
                            }
                            if (imp.getDocumentNo() != null) {
                                order.setDocumentNo(imp.getDocumentNo());
                            }
                            order.setC_BPartner_ID(imp.getC_BPartner_ID());
                            order.setC_BPartner_Location_ID(imp.getC_BPartner_Location_ID());
                            if (imp.getAD_User_ID() != 0) {
                                order.setAD_User_ID(imp.getAD_User_ID());
                            }
                            order.setBill_BPartner_ID(imp.getC_BPartner_ID());
                            order.setBill_Location_ID(imp.getBillTo_ID());
                            if (imp.getDescription() != null) {
                                order.setDescription(imp.getDescription());
                            }
                            order.setC_PaymentTerm_ID(imp.getC_PaymentTerm_ID());
                            order.setM_PriceList_ID(imp.getM_PriceList_ID());
                            order.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                            if (imp.getM_Shipper_ID() != 0) {
                                order.setM_Shipper_ID(imp.getM_Shipper_ID());
                            }
                            if (imp.getSalesRep_ID() != 0) {
                                order.setSalesRep_ID(imp.getSalesRep_ID());
                            }
                            if (order.getSalesRep_ID() == 0) {
                                order.setSalesRep_ID(this.getAD_User_ID());
                            }
                            if (imp.getAD_OrgTrx_ID() != 0) {
                                order.setAD_OrgTrx_ID(imp.getAD_OrgTrx_ID());
                            }
                            if (imp.getC_Activity_ID() != 0) {
                                order.setC_Activity_ID(imp.getC_Activity_ID());
                            }
                            if (imp.getC_Campaign_ID() != 0) {
                                order.setC_Campaign_ID(imp.getC_Campaign_ID());
                            }
                            if (imp.getC_Project_ID() != 0) {
                                order.setC_Project_ID(imp.getC_Project_ID());
                            }
                            if (imp.getDateOrdered() != null) {
                                order.setDateOrdered(imp.getDateOrdered());
                            }
                            if (imp.getDateAcct() != null) {
                                order.setDateAcct(imp.getDateAcct());
                            }
                            if (imp.getC_OrderSource() != null) {
                                order.setC_OrderSource_ID(imp.getC_OrderSource_ID());
                            }
                            order.saveEx();
                            ++noInsert;
                            lineNo = 10;
                        }
                        imp.setC_Order_ID(order.getC_Order_ID());
                        MOrderLine line = new MOrderLine(order);
                        line.setLine(lineNo);
                        lineNo += 10;
                        if (imp.getM_Product_ID() != 0) {
                            line.setM_Product_ID(imp.getM_Product_ID(), true);
                        }
                        if (imp.getC_Charge_ID() != 0) {
                            line.setC_Charge_ID(imp.getC_Charge_ID());
                        }
                        line.setQty(imp.getQtyOrdered());
                        line.setPrice();
                        if (imp.getPriceActual().compareTo(Env.ZERO) != 0) {
                            line.setPrice(imp.getPriceActual());
                        }
                        if (imp.getC_Tax_ID() != 0) {
                            line.setC_Tax_ID(imp.getC_Tax_ID());
                        } else {
                            line.setTax();
                            imp.setC_Tax_ID(line.getC_Tax_ID());
                        }
                        if (imp.getFreightAmt() != null) {
                            line.setFreightAmt(imp.getFreightAmt());
                        }
                        if (imp.getLineDescription() != null) {
                            line.setDescription(imp.getLineDescription());
                        }
                        line.saveEx();
                        imp.setC_OrderLine_ID(line.getC_OrderLine_ID());
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        if (!imp.save()) continue;
                        ++noInsertLine;
                    }
                    if (order != null) {
                        if (this.m_docAction != null && this.m_docAction.length() > 0) {
                            order.setDocAction(this.m_docAction);
                            if (!order.processIt(this.m_docAction)) {
                                this.log.warning("Order Process Failed: " + order + " - " + order.getProcessMsg());
                                throw new IllegalStateException("Order Process Failed: " + order + " - " + order.getProcessMsg());
                            }
                        }
                        order.saveEx();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Order - " + sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block115;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = new StringBuilder("UPDATE I_Order ").append("SET I_IsImported='N', Updated=SysDate ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Order_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@C_OrderLine_ID@: @Inserted@");
        StringBuilder msgreturn = new StringBuilder("#").append(noInsert).append("/").append(noInsertLine);
        return msgreturn.toString();
    }
}

