/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.OracleDriver;
import org.adempiere.db.oracle.OracleBundleActivator;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_Oracle;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.jfree.io.IOUtils;

public class DB_Oracle
implements AdempiereDatabase {
    private static final String POOL_PROPERTIES = "pool.properties";
    private static OracleDriver s_driver = null;
    public static final String DRIVER = "oracle.jdbc.OracleDriver";
    public static final int DEFAULT_PORT = 1521;
    public static final int DEFAULT_CM_PORT = 1630;
    private String m_connectionURL;
    private ComboPooledDataSource m_ds = null;
    private String m_userName = null;
    private Convert m_convert = new Convert_Oracle();
    private static CLogger log = CLogger.getCLogger(DB_Oracle.class);
    private static int m_maxbusyconnections = 0;
    private Random rand = new Random();

    public DB_Oracle() {
        try {
            System.setProperty("oracle.jdbc.V8Compatible", "true");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public String getName() {
        return Database.DB_ORACLE;
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 1521;
    }

    public synchronized Driver getDriver() throws SQLException {
        if (s_driver == null) {
            System.setProperty("oracle.jdbc.TcpNoDelay", "true");
            System.setProperty("oracle.jdbc.defaultNChar", "true");
            s_driver = new OracleDriver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuilder sb = null;
        if (connection.isBequeath()) {
            sb = new StringBuilder("jdbc:oracle:oci8:@");
        } else {
            sb = new StringBuilder("jdbc:oracle:thin:@");
            if (connection.isViaFirewall()) {
                sb.append("(DESCRIPTION=(ADDRESS_LIST=").append("(SOURCE_ROUTE=YES)").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getFwHost()).append(")(PORT=").append(connection.getFwPort()).append("))").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getDbHost()).append(")(PORT=").append(connection.getDbPort()).append(")))").append("(CONNECT_DATA=(SERVICE_NAME=").append(connection.getDbName()).append(")))");
            } else {
                sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
            }
        }
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:oracle:thin:@//" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DB_Oracle[");
        sb.append(this.m_connectionURL);
        try {
            StringBuilder logBuffer = new StringBuilder(50);
            logBuffer.append("# Connections: ").append(this.m_ds.getNumConnections());
            logBuffer.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            logBuffer.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            logBuffer.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        if (this.m_ds == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("# Connections: ").append(this.m_ds.getNumConnections());
            sb.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            sb.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            sb.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
            sb.append(" , # Min Pool Size: ").append(this.m_ds.getMinPoolSize());
            sb.append(" , # Max Pool Size: ").append(this.m_ds.getMaxPoolSize());
            sb.append(" , # Max Statements Cache Per Session: ").append(this.m_ds.getMaxStatementsPerConnection());
            sb.append(" , # Active Transactions: ").append(Trx.getActiveTransactions().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        Convert.logMigrationScript((String)oraStatement, null);
        return oraStatement;
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public String getSystemUser() {
        return "system";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(SysDate)";
            }
            return "SysDate";
        }
        StringBuilder dateString = new StringBuilder("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuilder retValue = new StringBuilder("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric((int)displayType)) {
            if (displayType == 12) {
                retValue.append(",'999G999G999G990D00'");
            } else {
                retValue.append(",'TM9'");
            }
            if (!Language.isDecimalPoint((String)AD_Language)) {
                retValue.append(",'NLS_NUMERIC_CHARACTERS='',.'''");
            }
        } else if (DisplayType.isDate((int)displayType)) {
            retValue.append(",'").append(Language.getLanguage((String)AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public String[] getCommands(int cmdType) {
        if (cmdType == 0) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    private String getFileName() {
        String base = null;
        base = Ini.isClient() ? System.getProperty("user.home") : Ini.getAdempiereHome();
        if (base != null && !base.endsWith(File.separator)) {
            base = String.valueOf(base) + File.separator;
        }
        return String.valueOf(base) + this.getName() + File.separator + POOL_PROPERTIES;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        InputStream inputStream = null;
        String propertyFilename = this.getFileName();
        File propertyFile = null;
        if (!Util.isEmpty((String)propertyFilename) && (propertyFile = new File(propertyFilename)).exists() && propertyFile.canRead()) {
            try {
                inputStream = new FileInputStream(propertyFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        URL url = null;
        if (inputStream == null) {
            propertyFile = null;
            url = Ini.isClient() ? OracleBundleActivator.bundleContext.getBundle().getEntry("META-INF/pool/client.default.properties") : OracleBundleActivator.bundleContext.getBundle().getEntry("META-INF/pool/server.default.properties");
            try {
                inputStream = url.openStream();
            }
            catch (IOException e) {
                throw new DBException((Exception)e);
            }
        }
        Properties poolProperties = new Properties();
        try {
            poolProperties.load(inputStream);
            inputStream.close();
            inputStream = null;
        }
        catch (IOException e) {
            throw new DBException((Exception)e);
        }
        if (propertyFile == null) {
            String directoryName = propertyFilename.substring(0, propertyFilename.length() - (POOL_PROPERTIES.length() + 1));
            File dir = new File(directoryName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            propertyFile = new File(propertyFilename);
            try {
                FileOutputStream fos = new FileOutputStream(propertyFile);
                inputStream = url.openStream();
                IOUtils.getInstance().copyStreams(inputStream, (OutputStream)fos);
                fos.close();
                inputStream.close();
                inputStream = null;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException directoryName) {
                // empty catch block
            }
        }
        int idleConnectionTestPeriod = this.getIntProperty(poolProperties, "IdleConnectionTestPeriod", 1200);
        int acquireRetryAttempts = this.getIntProperty(poolProperties, "AcquireRetryAttempts", 2);
        int maxIdleTimeExcessConnections = this.getIntProperty(poolProperties, "MaxIdleTimeExcessConnections", 1200);
        int maxIdleTime = this.getIntProperty(poolProperties, "MaxIdleTime", 1200);
        int unreturnedConnectionTimeout = this.getIntProperty(poolProperties, "UnreturnedConnectionTimeout", 0);
        boolean testConnectionOnCheckin = this.getBooleanProperty(poolProperties, "TestConnectionOnCheckin", false);
        boolean testConnectionOnCheckout = this.getBooleanProperty(poolProperties, "TestConnectionOnCheckout", false);
        int checkoutTimeout = this.getIntProperty(poolProperties, "CheckoutTimeout", 0);
        try {
            System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDataSourceName("iDempiereDS");
            cpds.setDriverClass(DRIVER);
            cpds.setJdbcUrl(this.getConnectionURL(connection));
            cpds.setUser(connection.getDbUid());
            cpds.setPassword(connection.getDbPwd());
            cpds.setPreferredTestQuery("SELECT Version FROM AD_System");
            cpds.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
            cpds.setAcquireRetryAttempts(acquireRetryAttempts);
            cpds.setTestConnectionOnCheckin(testConnectionOnCheckin);
            cpds.setTestConnectionOnCheckout(testConnectionOnCheckout);
            if (checkoutTimeout > 0) {
                cpds.setCheckoutTimeout(checkoutTimeout);
            }
            cpds.setMaxIdleTimeExcessConnections(maxIdleTimeExcessConnections);
            cpds.setMaxIdleTime(maxIdleTime);
            if (Ini.isClient()) {
                int maxPoolSize = this.getIntProperty(poolProperties, "MaxPoolSize", 15);
                int initialPoolSize = this.getIntProperty(poolProperties, "InitialPoolSize", 1);
                int minPoolSize = this.getIntProperty(poolProperties, "MinPoolSize", 1);
                cpds.setInitialPoolSize(initialPoolSize);
                cpds.setMinPoolSize(minPoolSize);
                cpds.setMaxPoolSize(maxPoolSize);
                m_maxbusyconnections = (int)((double)maxPoolSize * 0.9);
            } else {
                int maxPoolSize = this.getIntProperty(poolProperties, "MaxPoolSize", 400);
                int initialPoolSize = this.getIntProperty(poolProperties, "InitialPoolSize", 10);
                int minPoolSize = this.getIntProperty(poolProperties, "MinPoolSize", 5);
                cpds.setInitialPoolSize(initialPoolSize);
                cpds.setMinPoolSize(minPoolSize);
                cpds.setMaxPoolSize(maxPoolSize);
                m_maxbusyconnections = (int)((double)maxPoolSize * 0.9);
                int maxStatementsPerConnection = this.getIntProperty(poolProperties, "MaxStatementsPerConnection", 0);
                if (maxStatementsPerConnection > 0) {
                    cpds.setMaxStatementsPerConnection(maxStatementsPerConnection);
                }
            }
            if (unreturnedConnectionTimeout > 0) {
                cpds.setUnreturnedConnectionTimeout(1200);
                cpds.setDebugUnreturnedConnectionStackTraces(true);
            }
            this.m_ds = cpds;
        }
        catch (Exception ex) {
            this.m_ds = null;
            System.err.println("Could not initialise C3P0 Datasource: " + ex.getLocalizedMessage());
        }
        return this.m_ds;
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        Exception exception = null;
        try {
            block20: {
                if (this.m_ds == null) {
                    this.getDataSource(connection);
                }
                try {
                    int randomNum;
                    int numConnections = this.m_ds.getNumBusyConnections();
                    if (numConnections >= m_maxbusyconnections && m_maxbusyconnections > 0) {
                        randomNum = this.rand.nextInt(21) + 20;
                        Thread.sleep(randomNum * 1000);
                    }
                    if ((conn = this.m_ds.getConnection()) == null) {
                        randomNum = this.rand.nextInt(21) + 10;
                        Thread.sleep(randomNum * 1000);
                        conn = this.m_ds.getConnection();
                    }
                    if (conn != null) {
                        if (conn.getTransactionIsolation() != transactionIsolation) {
                            conn.setTransactionIsolation(transactionIsolation);
                        }
                        if (conn.getAutoCommit() != autoCommit) {
                            conn.setAutoCommit(autoCommit);
                        }
                    }
                }
                catch (Exception e) {
                    exception = e;
                    conn = null;
                    if (!DBException.isInvalidUserPassError((Exception)e)) break block20;
                    StringBuilder msgerr = new StringBuilder("Cannot connect to database: ").append(this.getConnectionURL(connection)).append(" - UserID=").append(connection.getDbUid());
                    System.err.println(msgerr.toString());
                }
            }
            if (conn == null && exception != null) {
                System.err.println(exception.toString());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            if (conn != null) {
                boolean trace = "true".equalsIgnoreCase(System.getProperty("org.adempiere.db.traceStatus"));
                int numConnections = this.m_ds.getNumBusyConnections();
                if (numConnections > 1) {
                    if (trace) {
                        log.warning(this.getStatus());
                    }
                    if (numConnections >= m_maxbusyconnections && m_maxbusyconnections > 0) {
                        if (!trace) {
                            log.warning(this.getStatus());
                        }
                        Runtime.getRuntime().runFinalization();
                    }
                }
            } else {
                System.err.println("Failed to acquire new connection. Status=" + this.getStatus());
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.toString());
        }
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not close Data Source");
            }
        }
        this.m_ds = null;
    }

    public void cleanup() {
    }

    public String getDataType(String columnName, int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        if (columnName != null && displayType == 28 && columnName.endsWith("_ID")) {
            retValue = "NUMBER(10)";
        }
        if (retValue == null) {
            switch (displayType) {
                case 13: 
                case 18: 
                case 19: 
                case 21: 
                case 25: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 53370: {
                    retValue = "NUMBER(10)";
                    break;
                }
                case 12: {
                    retValue = "NUMBER";
                    if (!defaultValue) break;
                    retValue = String.valueOf(retValue) + " DEFAULT 0";
                    break;
                }
                case 23: {
                    retValue = "BLOB";
                    break;
                }
                case 28: {
                    retValue = "CHAR(1)";
                    break;
                }
                case 37: {
                    retValue = "NUMBER";
                    if (!defaultValue) break;
                    retValue = String.valueOf(retValue) + " DEFAULT 0";
                    break;
                }
                case 15: 
                case 16: 
                case 24: {
                    retValue = "DATE";
                    if (!defaultValue) break;
                    retValue = String.valueOf(retValue) + " DEFAULT SYSDATE";
                    break;
                }
                case 11: {
                    retValue = "NUMBER(10)";
                    break;
                }
                case 17: {
                    retValue = "CHAR(" + precision + ")";
                    break;
                }
                case 10: 
                case 14: 
                case 34: {
                    retValue = "NVARCHAR(" + precision + ")";
                    break;
                }
                case 36: {
                    retValue = "CLOB";
                    break;
                }
                case 29: {
                    retValue = "NUMBER";
                    break;
                }
                case 20: {
                    retValue = "CHAR(1)";
                    break;
                }
                default: {
                    log.severe("Unknown: " + displayType);
                }
            }
        }
        return retValue;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)true);
        CConnection cc = CConnection.get();
        DB_Oracle db = (DB_Oracle)cc.getDatabase();
        db.cleanup();
        try {
            Connection conn = null;
            DataSource ds = db.getDataSource(cc);
            System.out.println("DS=" + ds.getConnection());
            conn = db.getCachedConnection(cc, true, 2);
            System.out.println("Cached=" + conn);
            System.out.println(db);
            System.out.println("JAVA classpath: [\n" + System.getProperty("java.class.path") + "\n]");
            DatabaseMetaData dmd = conn.getMetaData();
            System.out.println("DriverVersion: [" + dmd.getDriverVersion() + "]");
            System.out.println("DriverMajorVersion: [" + dmd.getDriverMajorVersion() + "]");
            System.out.println("DriverMinorVersion: [" + dmd.getDriverMinorVersion() + "]");
            System.out.println("DriverName: [" + dmd.getDriverName() + "]");
            System.out.println("ProductName: [" + dmd.getDatabaseProductName() + "]");
            System.out.println("ProductVersion: [\n" + dmd.getDatabaseProductVersion() + "\n]");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        try {
            String myString1 = "123456789 12345678";
            StringBuilder myString = new StringBuilder();
            int i = 0;
            while (i < 99) {
                myString.append(myString1).append((char)(97 + i)).append("\n");
                ++i;
            }
            System.out.println(myString.length());
            System.out.println(Util.size((String)myString.toString()));
            myString = new StringBuilder().append(Util.trimSize((String)myString.toString(), (int)2000));
            System.out.println(myString.length());
            System.out.println(Util.size((String)myString.toString()));
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            PreparedStatement pstmt = conn2.prepareStatement("INSERT INTO X_Test(Text1, Text2) values(?,?)");
            pstmt.setString(1, myString.toString());
            pstmt.setString(2, myString.toString());
            System.out.println(pstmt.executeUpdate());
            Statement stmt = conn2.createStatement();
            System.out.println(stmt.executeUpdate("INSERT INTO X_Test(Text1, Text2) values('" + myString + "','" + myString + "')"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.exit(0);
        System.out.println("--------------------------------------------------");
        try {
            Connection conn1 = db.getCachedConnection(cc, false, 2);
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            Connection conn3 = db.getCachedConnection(cc, false, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn1 = db.getCachedConnection(cc, true, 2);
            conn2 = db.getCachedConnection(cc, true, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("0 -> " + db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(DB.createConnection((boolean)false, (int)2));
        System.out.println(db);
        try {
            System.out.println("-- Sleeping --");
            Thread.sleep(60000L);
            System.out.println(db);
            db.close();
            db.cleanup();
            System.out.println(db);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Convert getConvert() {
        return this.m_convert;
    }

    public int getNextID(String Name) {
        int m_sequence_id = DB.getSQLValueEx(null, (String)("SELECT " + Name.toUpperCase() + ".nextval FROM DUAL"), (Object[])new Object[0]);
        return m_sequence_id;
    }

    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no;
        int cnt = DB.getSQLValueEx((String)trxName, (String)"SELECT COUNT(*) FROM USER_SEQUENCES WHERE UPPER(sequence_name)=?", (Object[])new Object[]{name.toUpperCase()});
        if (start < minvalue) {
            start = minvalue;
        }
        if (cnt == 0) {
            no = DB.executeUpdate((String)("CREATE SEQUENCE " + name.toUpperCase() + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START WITH " + start + " INCREMENT BY " + increment + " CACHE 20"), (String)trxName);
        } else {
            no = DB.executeUpdate((String)("ALTER SEQUENCE " + name.toUpperCase() + " INCREMENT BY " + increment + " MAXVALUE " + maxvalue + " CACHE 20"), (String)trxName);
            while (DB.getSQLValue((String)trxName, (String)("SELECT " + name.toUpperCase() + ".NEXTVAL FROM DUAL")) < start) {
            }
        }
        return no != -1;
    }

    public boolean isQueryTimeoutSupported() {
        return true;
    }

    public String addPagingSQL(String sql, int start, int end) {
        return sql;
    }

    public boolean isPagingSupported() {
        return false;
    }

    private int getIntProperty(Properties properties, String key, int defaultValue) {
        int i = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                i = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    private boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        boolean b = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                b = Boolean.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public boolean forUpdate(PO po, int timeout) {
        if (po.get_TrxName() == null) {
            return false;
        }
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0 && !po.is_new()) {
            ResultSet rs;
            CPreparedStatement stmt;
            block12: {
                StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
                sqlBuffer.append(keyColumns[0]).append(" FROM ").append(po.get_TableName()).append(" WHERE ");
                int i = 0;
                while (i < keyColumns.length) {
                    if (i > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keyColumns[i]).append("=?");
                    ++i;
                }
                sqlBuffer.append(" FOR UPDATE WAIT ").append(timeout > 0 ? timeout : 60);
                Object[] parameters = new Object[keyColumns.length];
                int i2 = 0;
                while (i2 < keyColumns.length) {
                    Object parameter = po.get_Value(keyColumns[i2]);
                    if (parameter != null && parameter instanceof Boolean) {
                        parameter = (Boolean)parameter != false ? "Y" : "N";
                    }
                    parameters[i2] = parameter;
                    ++i2;
                }
                stmt = null;
                rs = null;
                try {
                    stmt = DB.prepareStatement((String)sqlBuffer.toString(), (int)1003, (int)1008, (String)po.get_TrxName());
                    int i3 = 0;
                    while (i3 < keyColumns.length) {
                        stmt.setObject(i3 + 1, parameters[i3]);
                        ++i3;
                    }
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block12;
                }
                catch (Exception e) {
                    try {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                        }
                        throw new DBException("Could not lock record for " + po.toString() + " caused by " + e.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)stmt);
                return true;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            return false;
        }
        return false;
    }

    public String getNameOfUniqueConstraintError(Exception e) {
        String info = e.getMessage();
        int fromIndex = info.indexOf(".");
        if (fromIndex == -1) {
            return info;
        }
        int toIndex = info.indexOf(")", fromIndex + 1);
        if (toIndex == -1) {
            return info;
        }
        return info.substring(fromIndex + 1, toIndex);
    }
}

