/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.Adempiere;
import org.compiere.model.X_AD_Package_Imp_Backup;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CodeSnippetElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        action = "Update";
        String releaseNumber = this.getStringValue(element, "ReleaseNo");
        if (Adempiere.MAIN_VERSION.equals(releaseNumber) || releaseNumber.equals("all")) {
            String fileDate;
            String targetDirectoryModified;
            String packagePath;
            String sourceName;
            block16: {
                boolean success;
                sourceName = this.getStringValue(element, "filename");
                String targetDirectory = this.getStringValue(element, "filedir");
                String oldCode = this.getStringValue(element, "oldcode");
                String newCode = this.getStringValue(element, "newcode");
                packagePath = null;
                String sourcePath = null;
                try {
                    packagePath = this.getPackageDirectory(ctx.ctx);
                    File parentDirectory = new File(packagePath);
                    while (!parentDirectory.getName().equals("packages")) {
                        parentDirectory = parentDirectory.getParentFile();
                    }
                    parentDirectory = parentDirectory.getParentFile();
                    sourcePath = parentDirectory.getCanonicalPath();
                }
                catch (IOException e1) {
                    System.out.println("Can't find adempiere-all directory.");
                }
                File backupDir = new File(String.valueOf(packagePath) + File.separator + "backup" + File.separator);
                if (!backupDir.exists() && !(success = new File(String.valueOf(packagePath) + File.separator + "backup" + File.separator).mkdirs())) {
                    this.log.info("Backup directory creation failed");
                }
                String fullDirectory = String.valueOf(sourcePath) + targetDirectory;
                targetDirectoryModified = null;
                fileDate = null;
                char slash1 = '\\';
                char slash2 = '/';
                targetDirectoryModified = File.separator.equals("/") ? fullDirectory.replace(slash1, slash2) : fullDirectory.replace(slash2, slash1);
                File file = new File(String.valueOf(targetDirectoryModified) + sourceName);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(targetDirectoryModified) + sourceName);
                }
                boolean force = true;
                if (file.exists()) {
                    if (!force) {
                        System.out.println("Output file exists.  Use the -f option to replace it.");
                        return;
                    }
                    action = "Update";
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Target Backup:" + targetDirectoryModified + sourceName);
                    }
                    FileInputStream source = this.OpenInputfile(String.valueOf(targetDirectoryModified) + sourceName);
                    SimpleDateFormat formatter_file = new SimpleDateFormat("yyMMddHHmmssSSSSZ");
                    Date today = new Date();
                    fileDate = formatter_file.format(today);
                    OutputStream copy = this.OpenOutputfile(String.valueOf(packagePath) + File.separator + "backup" + File.separator + fileDate + "_" + sourceName);
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Source Backup:" + packagePath + File.separator + "backup" + File.separator + fileDate + "_" + sourceName);
                    }
                    this.copyFile(source, copy);
                    this.log.info("Backup Complete");
                }
                int success2 = CodeSnippetElementHandler.readReplace(String.valueOf(targetDirectoryModified) + sourceName, oldCode, newCode);
                X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, "codesnipit", sourceName, 0);
                if (success2 != -1) {
                    try {
                        this.logImportDetail(ctx, impDetail, 1, sourceName, 0, action);
                    }
                    catch (SAXException e) {
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("setfile:" + e);
                        }
                        break block16;
                    }
                }
                try {
                    this.logImportDetail(ctx, impDetail, 0, sourceName, 0, action);
                }
                catch (SAXException e) {
                    if (!this.log.isLoggable(Level.INFO)) break block16;
                    this.log.info("setfile:" + e);
                }
            }
            X_AD_Package_Imp_Backup backup = new X_AD_Package_Imp_Backup(ctx.ctx, 0, this.getTrxName(ctx));
            backup.setAD_Org_ID(Env.getAD_Org_ID((Properties)ctx.ctx));
            backup.setAD_Package_Imp_ID(this.getPackageImpId(ctx.ctx));
            backup.setAD_Package_Imp_Org_Dir(String.valueOf(targetDirectoryModified) + sourceName);
            backup.setAD_Package_Imp_Bck_Dir(String.valueOf(packagePath) + File.separator + "backup" + File.separator + fileDate + "_" + sourceName);
            backup.saveEx();
        }
    }

    public static int readReplace(String fname, String oldPattern, String replPattern) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            FileInputStream fis = new FileInputStream(fname);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll(oldPattern, replPattern);
                System.err.println(line);
                sb.append(String.valueOf(line) + "\n");
            }
            reader.close();
            BufferedWriter out = new BufferedWriter(new FileWriter(fname));
            out.write(sb.toString());
            out.close();
        }
        catch (Throwable e) {
            System.err.println("error replacing codesnipit " + e);
            return -1;
        }
        return 0;
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext pipoContext, TransformerHandler document) throws SAXException {
        String FileDir = Env.getContext((Properties)pipoContext.ctx, (String)"DestinationDirectory");
        String FileName = Env.getContext((Properties)pipoContext.ctx, (String)"DestinationFileName");
        String OldCode = Env.getContext((Properties)pipoContext.ctx, (String)"AD_Package_Code_Old");
        String NewCode = Env.getContext((Properties)pipoContext.ctx, (String)"AD_Package_Code_New");
        String ReleaseNo = Env.getContext((Properties)pipoContext.ctx, (String)"ReleaseNo");
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "custom");
        this.createSnipitBinding(atts, FileDir, FileName, OldCode, NewCode, ReleaseNo);
        document.startElement("", "", "Code_Snipit", atts);
        document.endElement("", "", "Code_Snipit");
    }

    private AttributesImpl createSnipitBinding(AttributesImpl atts, String FileDir, String FileName, String OldCode, String NewCode, String ReleaseNo) {
        atts.clear();
        atts.addAttribute("", "", "filedir", "CDATA", FileDir);
        atts.addAttribute("", "", "filename", "CDATA", FileName);
        String preOldCode = OldCode.toString();
        String preNewCode = NewCode.toString();
        String modOldCode = preOldCode.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\.").replaceAll("\\^", "\\\\^").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\/", "\\\\/").replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\|", "\\\\|");
        String modNewCode = preNewCode.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\.").replaceAll("\\^", "\\\\^").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\/", "\\\\/").replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\|", "\\\\|");
        atts.addAttribute("", "", "oldcode", "CDATA", modOldCode);
        atts.addAttribute("", "", "newcode", "CDATA", modNewCode);
        atts.addAttribute("", "", "ReleaseNo", "CDATA", ReleaseNo);
        return atts;
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        Env.setContext((Properties)packout.getCtx().ctx, (String)"DestinationDirectory", (String)((String)detail.getProperty("DestinationDirectory")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"DestinationFileName", (String)((String)detail.getProperty("DestinationFileName")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Package_Code_Old", (String)((String)detail.getProperty("AD_Package_Code_Old")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Package_Code_New", (String)((String)detail.getProperty("AD_Package_Code_New")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"ReleaseNo", (String)((String)detail.getProperty("ReleaseNo")));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("DestinationDirectory");
        packout.getCtx().ctx.remove("DestinationFileName");
        packout.getCtx().ctx.remove("AD_Package_Code_Old");
        packout.getCtx().ctx.remove("AD_Package_Code_New");
        packout.getCtx().ctx.remove("ReleaseNo");
    }
}

