/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GenericPOElementHandler
extends AbstractElementHandler {
    private String tableName;

    public GenericPOElementHandler() {
    }

    public GenericPOElementHandler(String tableName) {
        this.tableName = tableName;
    }

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String entityType;
        String tableName = element.getElementValue();
        PO po = this.findPO(ctx, element);
        if (po == null) {
            MTable table = MTable.get((Properties)ctx.ctx, (String)tableName);
            po = table.getPO(0, this.getTrxName(ctx));
        }
        PoFiller filler = new PoFiller(ctx, po, element, (AbstractElementHandler)this);
        List excludes = this.defaultExcludeList(tableName);
        List notfounds = filler.autoFill(excludes);
        int idxet = po.get_ColumnIndex("EntityType");
        if (idxet >= 0 && !this.isProcessElement(ctx.ctx, entityType = (String)po.get_Value(idxet))) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Generic PO not processed as it's official " + po.toString());
            }
            element.skip = true;
            return;
        }
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        po.saveEx();
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String sql = Env.getContext((Properties)ctx.ctx, (String)"SQLStatement");
        String[] components = null;
        if (sql.indexOf(";") > 0) {
            components = sql.split("[;]");
            sql = components[0];
        } else {
            components = new String[]{sql};
        }
        int tableId = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Table_ID");
        String tableName = MTable.getTableName((Properties)ctx.ctx, (int)tableId);
        List excludes = this.defaultExcludeList(tableName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                sql = MRole.getDefault().addAccessSQL(sql, tableName, true, true);
                stmt = DB.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    GenericPO po = new GenericPO(tableName, ctx.ctx, rs, this.getTrxName(ctx));
                    int AD_Client_ID = po.getAD_Client_ID();
                    if (AD_Client_ID != Env.getAD_Client_ID((Properties)ctx.ctx)) continue;
                    boolean createElement = this.isPackOutElement(ctx, (PO)po);
                    if (createElement) {
                        ElementHandler handler;
                        if (po.get_ID() > 0 && (handler = ctx.packOut.getHandler(po.get_TableName())) != null && !handler.getClass().equals(((Object)((Object)this)).getClass())) {
                            handler.packOut(ctx.packOut, document, ctx.logDocument, po.get_ID());
                            createElement = false;
                        }
                        if (createElement) {
                            this.verifyPackOutRequirement((PO)po);
                            this.addTypeName(atts, "table");
                            document.startElement("", "", tableName, atts);
                            PoExporter filler = new PoExporter(ctx, document, (PO)po);
                            filler.export(excludes, true);
                        }
                    }
                    int i = 1;
                    while (i < components.length) {
                        String[] tables = components[i].split("[>]");
                        this.exportDetail(ctx, document, po, 0, tables);
                        ++i;
                    }
                    if (!createElement) continue;
                    document.endElement("", "", tableName);
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)stmt);
    }

    private void exportDetail(PIPOContext ctx, TransformerHandler document, GenericPO parent, int index, String[] tables) {
        AttributesImpl atts = new AttributesImpl();
        tables[index] = tables[index].trim();
        String sql = "SELECT * FROM " + tables[index] + " WHERE " + parent.get_TableName() + "_ID = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                sql = MRole.getDefault().addAccessSQL(sql, tables[index], true, true);
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, parent.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    GenericPO po = new GenericPO(tables[index], ctx.ctx, rs, this.getTrxName(ctx));
                    int AD_Client_ID = po.getAD_Client_ID();
                    if (AD_Client_ID != Env.getAD_Client_ID((Properties)ctx.ctx)) continue;
                    boolean createElement = this.isPackOutElement(ctx, (PO)po);
                    if (createElement) {
                        ElementHandler handler;
                        if (po.get_ID() > 0 && (handler = ctx.packOut.getHandler(po.get_TableName())) != null && !handler.getClass().equals(((Object)((Object)this)).getClass())) {
                            handler.packOut(ctx.packOut, document, ctx.logDocument, po.get_ID());
                            createElement = false;
                        }
                        if (createElement) {
                            this.verifyPackOutRequirement((PO)po);
                            List excludes = this.defaultExcludeList(tables[index]);
                            this.addTypeName(atts, "table");
                            document.startElement("", "", tables[index], atts);
                            PoExporter filler = new PoExporter(ctx, document, (PO)po);
                            filler.export(excludes, true);
                        }
                    }
                    int i = index + 1;
                    while (i < tables.length) {
                        this.exportDetail(ctx, document, po, 0, new String[]{tables[i]});
                        ++i;
                    }
                    if (!createElement) continue;
                    document.endElement("", "", tables[index]);
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        int tableId = 0;
        String sql = null;
        if (detail.getProperty("AD_Table_ID") != null) {
            tableId = (Integer)detail.getProperty("AD_Table_ID");
            sql = (String)detail.getProperty("SQLStatement");
        } else {
            tableId = MTable.get((Properties)packout.getCtx().ctx, (String)this.tableName).getAD_Table_ID();
            sql = "SELECT * FROM " + this.tableName + " WHERE " + this.tableName + "_ID=" + recordId;
        }
        packout.getCtx().ctx.put("AD_Table_ID", Integer.toString(tableId));
        packout.getCtx().ctx.put("SQLStatement", sql);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Table_ID");
        packout.getCtx().ctx.remove("SQLStatement");
    }
}

