### /conv/score.py

from gui.imageimport import *

from obj.objImage    import objImage
from obj.objFilter   import objFilter
from obj.objGrid     import grid

from conv.object     import *
from conv.ly         import *
from conv.abc        import *

import string
import os

def makeObjVoice(obj, length, maintimes = None):
	# function
	def func_greyImage_t(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + color * func[2])
	def func_greyImage_p(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + color * func[2])
	def func_greyImage_d(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + color * func[2]) % 256
	def func_greyGrid_d(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + color * func[2]) % 256

	def func_rgbImage_t(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + \
					color[0] * func[2] + color[1] * func[3] + color[2] * func[4])
	def func_rgbImage_p(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + \
					color[0] * func[2] + color[1] * func[3] + color[2] * func[4])
	def func_rgbImage_d(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + \
					color[0] * func[2] + color[1] * func[3] + color[2] * func[4]) % 256
	def func_rgbGrid_d(xy, color, func):
		return int(xy[0] * func[0] + xy[1] * func[1] + \
					color[0] * func[2] + color[1] * func[3] + color[2] * func[4]) % 256
	
	# get obj's preferences
	if   len(obj.preferences) > 4:
		time        = obj.preferences[0]
		pitch       = obj.preferences[1]
		midi        = obj.preferences[2]
		noteNum     = obj.preferences[3]
		noteppt     = obj.preferences[4]
	else:
		return
	
	# change length by maintimes and obj's time
	if maintimes <> None:
		length = length / maintimes[0] * time[0] / maintimes[1] * time[1]
	
	oldImage = None
	oldData  = None
	
	# get obj's output
	if   isinstance(obj, objImage):
		oldImage = obj.image
	elif isinstance(obj, objFilter):
		oldData = obj.dataoutput
		if   isinstance(obj.dataoutput, Image.Image):
			oldImage = obj.dataoutput
		elif isinstance(obj.dataoutput, grid):
			oldImage = obj.dataoutput.pil

	ap = abs(pitch[0] - pitch[1]) + 1
	w = oldImage.size[0]
	h = oldImage.size[1]
	
	# processing - body
	if   len(noteppt) == 10:		# grey - image
		oldImage = oldImage.convert('L')
		newImage = Image.new('L', (length, ap), 0)
		for i in range(w):
			for j in range(h):
				t = func_greyImage_t( \
					 (i,j),
					 oldImage.getpixel((i,j)),
					 (noteppt[1], noteppt[2], noteppt[3]) )
				if t > length - 1: continue
				p = func_greyImage_p( \
					 (i,j),
					 oldImage.getpixel((i,j)),
					 (noteppt[4], noteppt[5], noteppt[6]))
				if p > ap - 1: continue
				d = func_greyImage_d( \
					 (i,j),
					 oldImage.getpixel((i,j)),
					 (noteppt[7], noteppt[8], noteppt[9]) )
				newImage.putpixel((t, p), d)
		if noteppt[0] == 0:
			newBond = Image.new('1', (length, ap), 255)
		else:
			newBond = Image.new('1', (length, ap), 0)
		newGrid = grid()
		newGrid.l = (1,1)
		newGrid.setData(newImage, newBond)
	elif len(noteppt) == 3:			# grey - grid
		tmp_length =  length
		newGrid = obj.dataoutput.crop((0, 0, tmp_length, ap))
		
		# processing - data
		newData = newGrid.data.copy().convert('L')
		w = newData.size[0]
		h = newData.size[1]
		
		for i in range(w):
			for j in range(h):
				d = func_greyGrid_d( \
					 (i,j),
					 newData.getpixel((i,j)),
					 (noteppt[0], noteppt[1], noteppt[2]) )				
				newData.putpixel((i, j), d)
		newData = newData.convert('L')
		
		# processing - chgrid - this is not the truth!!!
		for k in range(len(newGrid.chgrid)):
			newData = obj.chgrid[k].data.copy().convert('L')
			w = newData.size[0]
			h = newData.size[1]

			for i in range(w):
				for j in range(h):
					d = func_greyGrid_d( \
						 (i,j),
						 newData.getpixel((i,j)),
						 (noteppt[0], noteppt[1], noteppt[2]) )				
					newData.putpixel((i, j), d)
			
		newGrid.setData(newData, newGrid.bond)
	elif len(noteppt) == 16:		# RGB  - image
		newImage = Image.new('L', (length, ap), 0)
		for i in range(w):
			for j in range(h):
				t = func_rgbImage_t( \
					 (i,j),
					 oldImage.getpixel((i,j)),
					 (noteppt[1], noteppt[2], noteppt[3], noteppt[4], noteppt[5]) )
				if t > length - 1: continue
				p = func_rgbImage_p( \
					 (i,j),
					 oldImage.getpixel((i,j)),
					 (noteppt[6], noteppt[7], noteppt[8], noteppt[9], noteppt[10]))
				if p > ap - 1: continue
				d = func_rgbImage_d( \
					 (i,j),
					 oldImage.getpixel((i,j)),
					 (noteppt[11],noteppt[12],noteppt[13], noteppt[14], noteppt[15]))
				newImage.putpixel((t, p), d)
		if noteppt[0] == 0:
			newBond = Image.new('1', (length, ap), 255)
		else:
			newBond = Image.new('1', (length, ap), 0)
		newGrid = grid()
		newGrid.l = (1,1)
		newGrid.setData(newImage, newBond)
	elif len(noteppt) == 5:			# RGB  - grid
		tmp_length =  length
		newGrid = obj.dataoutput.crop((0, 0, tmp_length, ap))
		
		# processing - data
		newData = newGrid.data.copy()
		w = newData.size[0]
		h = newData.size[1]
		
		for i in range(w):
			for j in range(h):
				d = func_rgbGrid_d( \
					 (i,j),
					 newData.getpixel((i,j)),
					 (noteppt[0], noteppt[1], noteppt[2], noteppt[3], noteppt[4]) )				
				newData.putpixel((i, j), (d,d,d))
		newData = newData.convert('L')
		# processing - chgrid - this is not the truth!!!
		for k in range(len(newGrid.chgrid)):
			newData = obj.chgrid[k].data.copy()
			w = newData.size[0]
			h = newData.size[1]
			
			for i in range(w):
				for j in range(h):
					d = func_rgbGrid_d( \
						 (i,j),
						 newData.getpixel((i,j)),
						 (noteppt[0], noteppt[1], noteppt[2], noteppt[3], noteppt[4]) )				
					newData.putpixel((i, j), (d,d,d))
			newData = newData.convert('L')
			newGrid.chgrid[k].setData(newData, newGrid.chgrid[k].bond)
			
		newGrid.setData(newData, newGrid.bond)
	else:
		obj.voice = None
		return
	
	newVoice = voice(newGrid, time, pitch, midi)
	obj.voice = newVoice
#------------------------------------------------------------------------------
def convert_score(score):
	# divide databond to melody
	voicetable = []
	for voice in score.voices:
		voicetable.append( \
			convert_databond_melody(voice.grid.data, voice.grid.bond, voice.pitch))

	# set score
	score.SetVoiceTable(voicetable)
	score.SetTimes(score.voices[0].time)
	
	#-------------- Lilypond ---------------
	out  = ""
	out += n(program_version)
	out += n(lilypond_version)
	if score.selectConv.count(0) == 1:
		out += convert_score_layout(score)
	if score.selectConv.count(1) == 1:
		out += convert_score_midi(score)
	
	if score.selectConv.count(0) == 1 or score.selectConv.count(1) == 1:
		filename = os.path.join(os.getcwd(), score.filename) + ".ly"
		fw = open(filename, 'w')
		fw.write(out)
		fw.close()
	"""
	#---------------- abc ------------------
	out  = ""
	out += n(("%" * 40) + program_version + ("%" * 40))
	out += "X: 1\nT: " + score.filename + "\nC:" + \
	       "\nM: C\nL: 1/8\nQ: " + str(score.tempo) + "\nK: C\n" + out
	
	if score.selectConv.count(2) == 1:
		# abc
		for voice in voicetable:
			pass
			#out += convert_voice_newStaff_d(voice)
		
		
		filename = os.path.join(os.getcwd(), score.filename) + ".abc"
		fw = open(filename, 'w')
		fw.write(out)
		fw.close()
	"""