### /filter/anchor.py

import wx
from gui.imageimport import *

from obj.objImage   import objImage
from obj.objFilter  import objFilter
from obj.objGrid    import grid
from gui.colorPanel import *
from gui.validator  import *

from getInput import *
from setOutput import *

### properties
### ["anchor",ColorDis(Discrimination),BackColor,ColorChange,anchor]

### anchor
### 0 -> None, 1 -> North, 2 -> East, 3 -> South, 4 -> West

anchorList = ['None','North','East','South','West']
		
def anchor(obj):
	if len(obj.datainput) < 1:
		obj.dataoutput = None
		return 

	p = get_properties_anchor(obj)
	if isinstance(obj.datainput[0], Image.Image):
		w = obj.datainput[0].size[0]
		h = obj.datainput[0].size[1]
		
		oldImage = obj.datainput[0].copy()
		newImage = Image.new('RGB', (w, h), p.ColorBack)
		
		if   p.anchor == 0:	
			for i in range(w):
				for j in range(h):
					if dis(oldImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
						newImage.putpixel((i,j), oldImage.getpixel((i,j)))
		elif p.anchor == 1:
			for i in range(w):
				for j in range(h):
					if dis(oldImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
						newImage.putpixel((i,j), oldImage.getpixel((i,j)))
						break
		elif p.anchor == 2:
			for j in range(h):
				for i in range(w - 1, -1, -1):
					if dis(oldImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
						newImage.putpixel((i,j), oldImage.getpixel((i,j)))
						break
		elif p.anchor == 3:
			for i in range(w):
				for j in range(h - 1, -1, -1):
					if dis(oldImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
						newImage.putpixel((i,j), oldImage.getpixel((i,j)))
						break
		elif p.anchor == 4:
			for j in range(h):
				for i in range(w):
					if dis(oldImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
						newImage.putpixel((i,j), oldImage.getpixel((i,j)))
						break
		obj.dataoutput = newImage.copy()
	else:
		obj.dataoutput = None
		
class get_properties_anchor:
	def __init__(self,obj):
		if len(obj.properties) == 5:
			self.ColorDis    = obj.properties[1]
			self.ColorBack   = obj.properties[2]
			self.ColorChange = obj.properties[3]
			self.anchor      = obj.properties[4]
		else:
			self.ColorDis    = (0,0,0)
			self.ColorBack	 = (255,255,255)
			self.ColorChange = 0
			self.anchor	     = 0
			
class anchorUI:
	def __init__(self, panel, obj):
		self.obj = obj
		self.p = get_properties_anchor(self.obj)
		self.panel = panel
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		elif not isinstance(obj.datainput[0],Image.Image):
			self.panel.frame.Close(True)
		else:
			self.gui()
	def gui(self):
		d = 160
		# make pil_input_thumbnail picture and wxinput
		self.datainputh = self.obj.datainput[0].copy()
		self.datainputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxinput = wx.EmptyImage(self.datainputh.size[0], self.datainputh.size[1])
		self.wxinput.SetData(self.datainputh.convert('RGB').tostring())
		
		# make dataoutput's copy
		if self.obj.dataoutput == None:
			self.obj.dataoutput = self.obj.datainput[0].copy()
		
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# make gui
		self.panel.frame.SetSize((386,300))
		
		TopSize = wx.BoxSizer()
		self.wxginput = wx.StaticBitmap(self.panel, -1, self.wxinput.ConvertToBitmap(),	\
					   (self.wxinput.GetWidth(), self.wxinput.GetHeight()))
		self.wxgoutput = wx.StaticBitmap(self.panel, -1, self.wxoutput.ConvertToBitmap(), \
					   (self.wxoutput.GetWidth(), self.wxoutput.GetHeight()))
		TopSize.Add(self.wxginput,0,wx.FIXED_MINSIZE | wx.BOTTOM, 10)
		TopSize.Add(wx.DefaultSize,1,wx.EXPAND)
		TopSize.Add(self.wxgoutput,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MiddleSize = wx.BoxSizer()
		self.ButtonColorDis  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorDis, \
			id = self.ButtonColorDis.GetId())
		self.LabelPM = wx.StaticText(self.panel, -1," +- ")
		self.TextPer = wx.TextCtrl(self.panel, -1, "1", \
			size = wx.DefaultSize, validator = MyValidator())
		self.panel.Bind(wx.EVT_TEXT, self.OnTextPer, self.TextPer)
		self.LabelPer = wx.StaticText(self.panel, -1," %")
		self.ChoiceAnchor = wx.Choice(self.panel, -1, choices = anchorList)
		self.panel.Bind(wx.EVT_CHOICE, self.OnChoice, self.ChoiceAnchor)
		self.ButtonColorBack  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorBack, \
			id = self.ButtonColorBack.GetId())
		
		MiddleSize.Add(self.ButtonColorBack,0,wx.FIXED_MINSIZE, 10)
		MiddleSize.Add(self.ButtonColorDis,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.LabelPM,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.TextPer,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.LabelPer,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		MiddleSize.Add(self.ChoiceAnchor,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		ButtonRefresh = wx.Button(self.panel, -1, "Refresh")
		self.panel.Bind(wx.EVT_BUTTON, self.ImageRefresh, ButtonRefresh)
		
		BottomSize = wx.BoxSizer()
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(ButtonRefresh,0,wx.FIXED_MINSIZE , 10)
		BottomSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		BottomSize.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(MiddleSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.ALL , 10)
		
		self.panel.SetSizer(MainSize)
		self.SetValueUI()
	def SetValueUI(self):
		self.ButtonColorDis.SetColor(self.p.ColorDis)
		self.ButtonColorBack.SetColor(self.p.ColorBack)
		self.ChoiceAnchor.Select(self.p.anchor)
		self.TextPer.SetValue(str(self.p.ColorChange))
	def SetValueObj(self):
		self.obj.properties = \
			['anchor', \
			 self.p.ColorDis, \
			 self.p.ColorBack, \
			 self.p.ColorChange, \
			 self.p.anchor]
	def OnChoice(self, e):
		self.p.anchor = self.ChoiceAnchor.GetSelection()
	def OnChangeColorDis(self, e):
		self.p.ColorDis = e.GetColor()
	def OnChangeColorBack(self, e):
		self.p.ColorBack = e.GetColor()
	def OnTextPer(self, e):
		if self.TextPer.GetValue()!="":
			i = int(self.TextPer.GetValue())
			if not (0 <= i <= 100):
				self.TextPer.SetValue('0')
				i = 0
			self.p.ColorChange = i
	def ImageRefresh(self ,e = None):
		d = 160
		# make dataoutput with PIL function "anchor"
		self.SetValueObj()
		self.dataoutput = anchor(self.obj)
		
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# refresh!
		self.wxgoutput.SetBitmap(self.wxoutput.ConvertToBitmap())
	def OnCloseMe(self,e):
		# make shape's bitmap
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		# dismiss
		self.panel.frame.Close(True)
