### /fitler/rotate.py

import wx
from gui.imageimport import *

from obj.objImage  import objImage
from obj.objFilter import objFilter

from getInput import *
from setOutput import *

### properties
### ["rotate",degree]


def rotate(obj):
	if len(obj.datainput) < 1:
		obj.dataoutput = None
		return 

	if isinstance(obj.datainput[0],Image.Image):
		degree = obj.properties[1]
		obj.dataoutput = obj.datainput[0].rotate(degree)
	else:
		obj.dataoutput = None

class rotateUI:
	def __init__(self,panel,obj):
		# take properties
		self.obj = obj
		if len(self.obj.properties)>1:
			self.degree = self.obj.properties[1]
			self.degree_old = self.degree
		else:
			self.degree = 0
			self.degree_old = -181 		# impossible number makes change in OnCloseMe
		
		self.panel = panel
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		elif not isinstance(obj.datainput[0],Image.Image):
			self.panel.frame.Close(True)
		else:
			# make gui
			self.gui()
	def gui(self):	# make panel
		
		d = 160
		# make pil_input_thumbnail picture and wxinput
		self.datainputh = self.obj.datainput[0].copy()
		self.datainputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxinput = wx.EmptyImage(self.datainputh.size[0], self.datainputh.size[1])
		self.wxinput.SetData(self.datainputh.convert('RGB').tostring())
		
		# make dataoutput with PIL function "rotate" 
		self.obj.dataoutput = self.obj.datainput[0].rotate(self.degree)
		
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# make gui
		self.panel.frame.SetSize((386,275))
		
		TopSize = wx.BoxSizer()
		self.wxginput = wx.StaticBitmap(self.panel, -1, self.wxinput.ConvertToBitmap(),	\
					   (self.wxinput.GetWidth(), self.wxinput.GetHeight()))
		self.wxgoutput = wx.StaticBitmap(self.panel, -1, self.wxoutput.ConvertToBitmap(), \
					   (self.wxoutput.GetWidth(), self.wxoutput.GetHeight()))
		TopSize.Add(self.wxginput,0,wx.FIXED_MINSIZE | wx.BOTTOM, 10)
		TopSize.Add(wx.DefaultSize,1,wx.EXPAND)
		TopSize.Add(self.wxgoutput,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		self.slider = wx.Slider(
			self.panel, 3,0,-180,180,(0,0),(360,-1), \
			wx.SL_HORIZONTAL | wx.SL_AUTOTICKS | wx.SL_LABELS
			)
		self.slider.SetTickFreq(18,1)
		self.slider.SetValue(self.degree)
		
		ButtonRefresh = wx.Button(self.panel, -1, "Refresh")
		#ButtonRefresh.SetPosition((3,190))
		self.panel.Bind(wx.EVT_BUTTON, self.get_rotate, ButtonRefresh)
		
		BottomSize = wx.BoxSizer()
		ButtonClose = wx.Button(self.panel, -1, "Close")
		#ButtonClose.SetPosition((140,190))
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(ButtonRefresh,0,wx.FIXED_MINSIZE , 10)
		BottomSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		BottomSize.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(self.slider, 0, wx.EXPAND | wx.LEFT | wx.RIGHT , 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.BOTTOM , 10)
		
		self.panel.SetSizer(MainSize)
	def ImageRefresh(self):
		d = 160
		# make dataoutput with PIL function "rotate" 
		self.obj.dataoutput = self.obj.datainput[0].rotate(self.degree)
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# refresh!
		self.wxgoutput.SetBitmap(self.wxoutput.ConvertToBitmap())
	def get_rotate(self,e):
		self.degree = self.slider.GetValue()
		self.ImageRefresh()
	def OnCloseMe(self,e):	
		# if there were some change, update value
		if self.degree_old <> self.degree:
			self.obj.properties = ["rotate",self.degree]
			self.obj.editcount = self.panel.frame.get_editcount()
			
			name = str("rotate, " + str(self.degree))
			#objFilter._text(self.obj,name)
		# make shape's bitmap
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		
		# dismiss
		self.panel.frame.Close(True)
