### /gui/view.py

import wx
from gui.imageimport import *

from obj.objImage import objImage 
from obj.objFilter import objFilter
from obj.objGrid import grid

from viewPanel import *

class View(wx.Frame):
	def __init__(self,frame,obj=None):
		self.frame = frame
		self.obj = obj
		if isinstance(self.obj, objImage):
			title = "View: Image (w: %d px, h: %d px)" \
				% (int(self.obj.image.size[0]), int(self.obj.image.size[1]))
		elif isinstance(self.obj, objFilter):
			if isinstance(self.obj.dataoutput, Image.Image):
				title = "View: Image (w: %d px, h: %d px)" \
					% (int(self.obj.dataoutput.size[0]), \
					   int(self.obj.dataoutput.size[1]))
			elif isinstance(self.obj.dataoutput, grid):
				title = "View: Grid (w: %d px, h: %d px, l: %d / %d, chgrids: %d)" \
					% (
					   int(self.obj.dataoutput.w), \
					   int(self.obj.dataoutput.h),
					   int(self.obj.dataoutput.l[0]), \
					   int(self.obj.dataoutput.l[1]), \
					   int(len(self.obj.dataoutput.chgrid))
					  )
			else:
				title = "View: None"
		wx.Frame.__init__(self,frame,-1,title, 
							  style=wx.DEFAULT_FRAME_STYLE | wx.TINY_CAPTION_HORIZ)
		
		# make gui
		self.gui()
		self.Show()
	def gui(self):
		self.SetSize((360,360))
		
		##  BottomSize
		BottomSize = wx.BoxSizer()
		
		ButtonShow     = wx.Button(self, -1, "Show")
		ButtonShowBond = wx.Button(self, -1, "Show Bond")
		ButtonClose    = wx.Button(self, -1, "Close")
		self.Bind(wx.EVT_BUTTON, self.OnShow, ButtonShow)
		self.Bind(wx.EVT_BUTTON, self.OnShowBond, ButtonShowBond)
		self.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		BottomSize.Add(ButtonShow, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomSize.Add(ButtonShowBond, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomSize.Add(ButtonClose, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		
		## ViewPanel
		self.vpanel = ViewPanel(self)
		if   isinstance(self.obj, objImage):
			self.vpanel.SetObj(self.obj.image)
		elif isinstance(self.obj, objFilter):
			self.vpanel.SetObj(self.obj.dataoutput)
		self.Bind(EVT_VP_CHANGE_COLOR, self.OnChangeColorDis, \
			id = self.vpanel.GetId())
		
		## MiddlePanel
		MiddleSize = wx.BoxSizer()
		self.ColorPanel = wx.Panel(self, size = (14,14))
		self.LabelColor = wx.StaticText(self, -1,"")
		
		MiddleSize.Add(self.ColorPanel, 0, wx.EXPAND | wx.ALL, 0)
		MiddleSize.Add(self.LabelColor, 0, wx.EXPAND | wx.LEFT, 10)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(self.vpanel, 1, wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 10)
		MainSize.Add(MiddleSize,  0, wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 10)
		MainSize.Add(BottomSize,  0, wx.EXPAND | wx.ALL, 10)
		
		self.SetSizer(MainSize)
		
	def OnShow(self, e):
		if isinstance(self.obj, objImage):
			self.obj.image.show()
		elif isinstance(self.obj, objFilter):
			if isinstance(self.obj.dataoutput, Image.Image):
				self.obj.dataoutput.show()
			elif isinstance(self.obj.dataoutput, grid):
				self.obj.dataoutput.pil.show()
	def OnShowBond(self, e):
		if isinstance(self.obj, objFilter):
			if isinstance(self.obj.dataoutput, grid):
				self.obj.dataoutput.bond.show()
	def OnChangeColorDis(self, e):
		self.ColorPanel.SetBackgroundColour(e.GetColor())
		self.ColorPanel.Refresh()
		xy = "x: " + str(e.GetXY()[0]) + ", y: " + str(e.GetXY()[1])
		string = xy + " (" + str(e.GetColor()[0]) + "," + \
				str(e.GetColor()[1]) + "," + \
				str(e.GetColor()[2]) + ")"
				
		self.LabelColor.SetLabel(string)
	def OnCloseMe(self,e):
		# dismiss
		self.Close(True)
