### /filter/copy.py

import wx
from gui.imageimport import *

import sets
from obj.objImage   import objImage
from obj.objFilter  import objFilter
from obj.objGrid    import grid
from gui.colorPanel import *

from getInput import *
from setOutput import *
### properties
### ["copy", ColorDis(discrimination), ColorMask, ColorCopy
###  FixedCanvas, Alpha, s(swap)]

### fromImage(Grid): obj.datainput[0]
###   toImage(Grid): obj.datainput[1]

d = 96

def copy(obj):
	# swap
	if len(obj.datainput) == 2:
		if len(obj.properties) == 7:
			if obj.properties[6] == 1:
				obj.datainput[0],obj.datainput[1] = \
					obj.datainput[1],obj.datainput[0]
	copyconv(obj)

class get_properties_copy:
	def __init__(self,obj):
		if len(obj.properties) == 7:
			self.ColorDis    = obj.properties[1]
			self.ColorMask   = obj.properties[2]
			self.ColorCopy   = obj.properties[3]
			self.FixedCanvas = obj.properties[4]
			self.Alpha       = obj.properties[5]
			self.s           = obj.properties[6]
		else:
			self.ColorDis    = (0,0,0)
			self.ColorMask   = None
			self.ColorCopy   = None
			self.FixedCanvas = True		# True -> Fixed, False -> Dynamic
			self.Alpha       = 100
			self.s           = 0

def copyconv(obj):
	p = get_properties_copy(obj)
	if len(obj.datainput) < 2:
		obj.dataoutput = None
	else:
		if isinstance(obj.datainput[0], grid) or \
			isinstance(obj.datainput[1], grid):
			obj.dataoutput = None
		else:
			if p.FixedCanvas == True:
				if p.ColorCopy <> None:
					convertImageFixedColorCopy(obj)
				else:
					convertImageFixedCopy(obj)
			else:
				convertImageDynamicCopy(obj)

def convertImageFixedCopy(obj):
	p = get_properties_copy(obj)
	
	fromImage = obj.datainput[0].copy()
	fw = fromImage.size[0]
	fh = fromImage.size[1]
	toImage = obj.datainput[1].copy()
	nw = toImage.size[0]
	data = toImage.getdata()
	
	# make copypoint
	copypoint = []
	copypoint_x_max, copypoint_y_max = 0, 0
	if p.ColorMask == None:
		for i in range(len(data)):
			if data[i] == p.ColorDis:
				copypoint.append((i % nw, int(i / nw)))
				if copypoint_x_max < i % nw: copypoint_x_max = i % nw
				if copypoint_y_max < int(i / nw) : copypoint_y_max = int(i / nw)
	else:
		for i in range(len(data)):
			if data[i] == p.ColorDis:
				copypoint.append((i % nw, int(i / nw)))
				toImage.putpixel((i % nw, int(i / nw)),p.ColorMask)
				if copypoint_x_max < i % nw: copypoint_x_max = i % nw
				if copypoint_y_max < int(i / nw) : copypoint_y_max = int(i / nw)

	# get last copypoint
	newImageWidth  = toImage.size[0]
	newImageHeight = toImage.size[1]
	
	if copypoint_x_max + fw > newImageWidth:
		newImageWidth = copypoint_x_max + fw
	if copypoint_y_max + fh > newImageHeight:
		newImageHeight = copypoint_y_max + fh
	
	if p.ColorMask == None:
		newImage = Image.new('RGB', (newImageWidth, newImageHeight), (0,0,0))
	else:
		newImage = Image.new('RGB', (newImageWidth, newImageHeight), p.ColorMask)
	newImage.paste(toImage, (0,0, toImage.size[0], toImage.size[1]))
	
	# copy
	for c in copypoint:
		i, j = c[0], c[1]
		outt = newImage.crop((i,j,fw+i,fh+j))
		out = Image.blend(outt,fromImage,(p.Alpha / 100.0))
		newImage.paste(out,(i,j,fw+i,fh+j))
		
	#-- set obj.dataoutput
	obj.dataoutput = newImage

def convertImageFixedColorCopy(obj):
	p = get_properties_copy(obj)
	# make fromImage's color table
	table = []
	fromData = obj.datainput[0].getdata()
	fw = obj.datainput[0].size[0]
	fh = obj.datainput[0].size[1]
	
	for i in range(len(fromData)):
		if fromData[i] == p.ColorCopy:
			table.append((i % fw, int(i / fw)))
	fromData = None
	
	# make copypoint
	toImage   = obj.datainput[1].copy()
	tw = toImage.size[0]
	th = toImage.size[1]
	data = toImage.getdata()
	copypoint = []
	copypoint_x_max, copypoint_y_max = 0, 0
	if p.ColorMask == None:
		for i in range(len(data)):
			if data[i] == p.ColorDis:
				copypoint.append((i % tw, int(i / tw)))
				if copypoint_x_max < i % tw: copypoint_x_max = i % tw
				if copypoint_y_max < int(i / tw) : copypoint_y_max = int(i / tw)

	else:
		for i in range(len(data)):
			if data[i] == p.ColorDis:
				copypoint.append((i % tw, int(i / tw)))
				toImage.putpixel((i % tw, int(i / tw)),p.ColorMask)
				if copypoint_x_max < i % tw: copypoint_x_max = i % tw
				if copypoint_y_max < int(i / tw) : copypoint_y_max = int(i / tw)
	
	# get last copypoint
	newImageWidth  = toImage.size[0]
	newImageHeight = toImage.size[1]
	
	if copypoint_x_max + fw > newImageWidth:
		newImageWidth = copypoint_x_max + fw
	if copypoint_y_max + fh > newImageHeight:
		newImageHeight = copypoint_y_max + fh
	
	if p.ColorMask == None:
		newImage = Image.new('RGB', (newImageWidth, newImageHeight), (0,0,0))
	else:
		newImage = Image.new('RGB', (newImageWidth, newImageHeight), p.ColorMask)
	newImage.paste(toImage, (0,0, toImage.size[0], toImage.size[1]))
		
	# copy color table on copypoint
	for c in copypoint:		# p.alpha / 100
		for t in table:
			#if c[0] + t[0] < nw and c[1] + t[1] < nh:
			newImage.putpixel(((c[0] + t[0]), (c[1] + t[1])), p.ColorCopy)
		
	#-- set obj.dataoutput
	obj.dataoutput = newImage

def convertImageDynamicCopy(obj):
	p = get_properties_copy(obj)

	fromImage = obj.datainput[0].copy()
	fw = fromImage.size[0]
	fh = fromImage.size[1]
	toImage   = obj.datainput[1].copy()
	data = toImage.getdata()
	tw = toImage.size[0]
	th = toImage.size[1]
	
	copypoint = []
	cxc = []		# copypoint:x:count
	cyc = []		# copypoint:y:count
	
	for i in range(len(data)):
		if data[i] == p.ColorDis:
			copypoint.append((i % tw, int(i / tw)))
			
	for i in range(len(copypoint)):
		if not copypoint[i][0] in cxc:
			cxc.append(copypoint[i][0])
		if not copypoint[i][1] in cyc:
			cyc.append(copypoint[i][1])
	cxc.sort()
	cyc.sort()
	
	if p.ColorMask == None:
		newImage = Image.new('RGB', \
			(tw + len(cxc) * fw - len(cxc), th + len(cyc) * fh - len(cyc)), \
			(255,255,255))
	else:
		newImage = Image.new('RGB', \
			(tw + len(cxc) * fw - len(cxc), th + len(cyc) * fh - len(cyc)), \
			p.ColorMask)
		
	# toImage to newImage
	ncxc = [-1] + cxc		# a convenient way
	if not tw - 1 in ncxc:
		ncxc = ncxc + [tw]

	ncyc = [-1] + cyc		# a convenient way
	if not th - 1 in ncyc:
		ncyc = ncyc + [th]
	for i in range(len(ncxc) - 1):
		for j in range(len(ncyc) - 1):
			x1, x2 = ncxc[i] + 1, ncxc[i + 1] + 1
			y1, y2 = ncyc[j] + 1, ncyc[j + 1] + 1
			
			box = toImage.crop((x1, y1, x2, y2))
			newImage.paste(box, (x1+i*fw-i,y1+j*fh-j,x2+i*fw-i,y2+j*fh-j))
			
	# fromImage to newImage
	
	for i in range(len(copypoint)):
		px = cxc.index(copypoint[i][0]) * fw + copypoint[i][0] - cxc.index(copypoint[i][0])
		py = cyc.index(copypoint[i][1]) * fh + copypoint[i][1] - cyc.index(copypoint[i][1])
		
		outt = newImage.crop((px, py, px + fw, py + fh))
		out = Image.blend(outt,fromImage,1)
		newImage.paste(out,(px, py, px + fw, py + fh))
		
	#-- set obj.dataoutput
	obj.dataoutput = newImage

		
class copyUI:
	def __init__(self,panel,obj):
		self.obj = obj
		self.panel = panel
		self.p = get_properties_copy(obj)
		
		# get datainput
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 2:
			self.panel.frame.Close(True)
		elif isinstance(obj.datainput[0],grid) or isinstance(obj.datainput[1],grid):
			self.panel.frame.Close(True)
		else:
			# make gui
			self.gui()
	def makeFromToImage(self):
		#   fromImage 
		if   isinstance(self.obj.datainput[0], Image.Image):
			self.fromImage = self.obj.datainput[0].copy().resize((d,d))
		elif isinstance(self.obj.datainput[0], grid):
			self.fromImage = self.obj.datainput[0].pil.copy().resize((d,d))
		self.fromImage.thumbnail((d,d),Image.ANTIALIAS)
		
		if   isinstance(self.obj.datainput[1], Image.Image):
			self.toImage = self.obj.datainput[1].copy().resize((d,d))
		elif isinstance(self.obj.datainput[1], grid):
			self.toImage = self.obj.datainput[1].pil.copy().resize((d,d))
		self.toImage.thumbnail((d,d),Image.ANTIALIAS)
	def gui(self):
		### make thumbnail and wxinput
		self.makeFromToImage()
		#   fromImage 
		self.wxfromImage = wx.EmptyImage( \
			self.fromImage.size[0], self.fromImage.size[1])
		self.wxfromImage.SetData(self.fromImage.convert('RGB').tostring())
		
		#   toImage 
		self.wxtoImage = wx.EmptyImage( \
			self.toImage.size[0], self.toImage.size[1])
		self.wxtoImage.SetData(self.toImage.convert('RGB').tostring())
		
		#   canvasImage
		if self.obj.dataoutput <> None:
			if   isinstance(self.obj.dataoutput, Image.Image):
				self.canvasImage = self.obj.dataoutput
			elif isinstance(self.obj.dataoutput, grid):
				self.canvasImage = self.obj.dataoutput.pil
			else:
				self.canvasImage = Image.new('RGB',(d*2+13,d*2+13), "white")
		else:
			self.canvasImage = Image.new('RGB',(d*2+13,d*2+13), "white")
		
		pcanvasImage = self.canvasImage.copy().resize((d*2+13,d*2+13))
		pcanvasImage.thumbnail((d*2+13,d*2+13),Image.ANTIALIAS)
		self.wxcanvasImage = wx.EmptyImage( \
			pcanvasImage.size[0], pcanvasImage.size[1])
		self.wxcanvasImage.SetData(pcanvasImage.convert('RGB').tostring())
		
		### gui
		self.panel.frame.SetSize((525,285))
		
		##  TopSize
		TopSize = wx.BoxSizer()
		TopLeftSize = wx.BoxSizer(wx.VERTICAL)
		TopRightSize = wx.BoxSizer(wx.VERTICAL)
		
		#   TopLeftSize
		
		self.LabelFrom = wx.StaticText(self.panel, -1,"From :")
		self.wxgfromImage = wx.StaticBitmap \
			(self.panel, -1, self.wxfromImage.ConvertToBitmap(),	\
			(self.wxfromImage.GetWidth(), self.wxfromImage.GetHeight()))
			
		self.LabelTo = wx.StaticText(self.panel, -1,"To :")
		self.wxgtoImage = wx.StaticBitmap \
			(self.panel, -1, self.wxtoImage.ConvertToBitmap(), \
			(self.wxtoImage.GetWidth(), self.wxtoImage.GetHeight()))
		
		TopLeftSize.Add(self.LabelFrom,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.wxgfromImage,0,wx.EXPAND | wx.BOTTOM, 0)
		#TopLeftSize.Add((-1,d),1,wx.EXPAND | wx.BOTTOM, 10)
		TopLeftSize.Add(self.LabelTo,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.wxgtoImage,0,wx.EXPAND | wx.ALIGN_RIGHT| wx.BOTTOM, 0)
		
		#   TopRightSize
		self.LabelCanvas = wx.StaticText(self.panel, -1,"Canvas :")
		self.wxgcanvasImage = wx.StaticBitmap \
			(self.panel, -1, self.wxcanvasImage.ConvertToBitmap(),	\
			(self.wxcanvasImage.GetWidth(), self.wxcanvasImage.GetHeight()))
		TopRightSize.Add(self.LabelCanvas,0,wx.ALL, 0)			
		TopRightSize.Add(self.wxgcanvasImage,0,wx.EXPAND | wx.Top, 10)
		
		#   Labels:
		self.SetLabel()
		
		##  BottomSize
		BottomSize           = wx.BoxSizer()
		box = wx.StaticBox(self.panel,-1, "Option")
		BottomLeftSize = wx.StaticBoxSizer(box)
		BottomLeftPanelSize  = wx.BoxSizer(wx.VERTICAL)
		BottomLeftOptionSize = wx.BoxSizer(wx.VERTICAL)
		BottomRightSize      = wx.BoxSizer()
		
		#   BottomLeftPanelSize 
		self.LabelCopy = wx.StaticText(self.panel, -1,"Copy")
		self.ButtonColorCopy  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorCopy, \
			id = self.ButtonColorCopy.GetId())
		self.LabelMask = wx.StaticText(self.panel, -1,"Mask")
		self.ButtonColorMask = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorMask, \
			id = self.ButtonColorMask.GetId())
		self.LabelDis = wx.StaticText(self.panel, -1,"Dis")
		self.ButtonColorDis  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorDis, \
			id = self.ButtonColorDis.GetId())
		
		BottomLeftPanelSize.Add(self.LabelCopy, 0,wx.EXPAND | wx.BOTTOM, 5)
		BottomLeftPanelSize.Add(self.ButtonColorCopy, 0,wx.EXPAND | wx.BOTTOM, 5)
		BottomLeftPanelSize.Add(self.LabelDis, 0,wx.EXPAND | wx.BOTTOM, 5)
		BottomLeftPanelSize.Add(self.ButtonColorDis, 0,wx.EXPAND | wx.BOTTOM, 5)
		BottomLeftPanelSize.Add(self.LabelMask, 0,wx.EXPAND | wx.BOTTOM, 5)
		BottomLeftPanelSize.Add(self.ButtonColorMask,0,wx.EXPAND | wx.BOTTOM | wx.ALIGN_RIGHT, 5)
		
		#   BottomLeftOptionSize
		self.CheckCopyColor = wx.CheckBox(self.panel,-1,"Copy color")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckCopyColor, self.CheckCopyColor)
		self.CheckFixedCanvas = wx.CheckBox(self.panel,-1,"Fixed canvas")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckFixed, self.CheckFixedCanvas)
		self.CheckMaskColor = wx.CheckBox(self.panel,-1,"Mask color")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckMaskColor, self.CheckMaskColor)
		self.slider = wx.Slider(
			self.panel, 3,0,0,100,(0,0),(-1,-1), \
			wx.SL_HORIZONTAL | wx.SL_AUTOTICKS | wx.SL_LABELS
			)
		self.slider.SetTickFreq(10,1)
		
		BottomLeftOptionSize.Add(self.CheckCopyColor, 0,wx.EXPAND | wx.BOTTOM, 10)
		BottomLeftOptionSize.Add(self.CheckMaskColor, 0,wx.EXPAND | wx.BOTTOM, 10)
		BottomLeftOptionSize.Add(self.CheckFixedCanvas, 0,wx.EXPAND | wx.BOTTOM, 10)
		BottomLeftOptionSize.Add(self.slider, 0,wx.EXPAND | wx.BOTTOM, 10)
		
		##  ButtomLeftSize
		BottomLeftSize.Add(BottomLeftPanelSize, 0,wx.EXPAND | wx.ALL,10)
		BottomLeftSize.Add(BottomLeftOptionSize,1,wx.EXPAND | wx.RIGHT | wx.TOP | wx.BOTTOM,10)
		
		#   TopSize
		TopSize.Add(BottomLeftSize,0,wx.EXPAND | wx.RIGHT, 13)
		TopSize.Add(TopLeftSize,0,wx.FIXED_MINSIZE | wx.RIGHT, 13)	
		TopSize.Add(TopRightSize,1,wx.EXPAND,0)
		
		##  ButtomRightSize
		ButtonMake = wx.Button(self.panel, -1, "Make")
		self.panel.Bind(wx.EVT_BUTTON, self.OnMake, ButtonMake)
		ButtonSwap = wx.Button(self.panel, -1, "Swap")
		self.panel.Bind(wx.EVT_BUTTON, self.swap, ButtonSwap)
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomRightSize.Add(wx.DefaultSize, 1,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)		
		BottomRightSize.Add(ButtonMake, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomRightSize.Add(ButtonSwap, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomRightSize.Add(ButtonClose,0,wx.EXPAND | wx.ALL, 0)
		
		##  MainSize
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(BottomRightSize, 0, wx.EXPAND | wx.ALL, 10)
		
		self.panel.SetSizer(MainSize)
		self.SetValueUI()
		
	def SetValueUI(self):
		if self.p.ColorCopy <> None:
			self.ButtonColorCopy.Enable(True)
			self.CheckCopyColor.SetValue(True)
			self.OnCheckCopyColor(None)
		else:
			self.ButtonColorCopy.Enable(False)
			self.CheckCopyColor.SetValue(False)
		if self.p.ColorMask <> None:
			self.ButtonColorMask.Enable(True)
			self.CheckMaskColor.SetValue(True)
		else:
			self.ButtonColorMask.Enable(False)
			self.CheckMaskColor.SetValue(False)
			
		self.ButtonColorMask.SetColor(self.p.ColorMask)
		self.ButtonColorCopy.SetColor(self.p.ColorCopy)		
		self.ButtonColorDis.SetColor(self.p.ColorDis)
		
		self.CheckFixedCanvas.SetValue(self.p.FixedCanvas)
		self.slider.SetValue(self.p.Alpha)
		
	def OnChangeColorCopy(self, e):
		self.p.ColorCopy  = e.GetColor()
	def OnChangeColorDis(self, e):
		self.p.ColorDis   = e.GetColor()
	def OnChangeColorMask(self, e):
		self.p.ColorMask  = e.GetColor()
	def swap(self,e):
		if len(self.obj.datainput) > 1:
			if self.p.s == 1:
				self.p.s = 0
			else:
				self.p.s = 1
			
			self.obj.datainput[0],self.obj.datainput[1] = \
				self.obj.datainput[1],self.obj.datainput[0]
			self.ImageRefresh()
	def OnMake(self,e):
		d = 96
		
		# set obj.properties
		
		self.p.Alpha = self.slider.GetValue()
		if 	self.CheckMaskColor.IsChecked() == False:
			self.p.ColorMask = None
			
		if 	self.CheckCopyColor.IsChecked() == False:
			self.p.ColorCopy = None
			
		self.obj.properties = \
			['copy', \
			 self.p.ColorDis, \
			 self.p.ColorMask, \
			 self.p.ColorCopy, \
			 self.p.FixedCanvas, \
			 self.p.Alpha, \
			 self.p.s]
		copyconv(self.obj)
		
		# make canvasImage
		self.canvasImage = self.obj.dataoutput.copy()
		self.canvasImageth = self.canvasImage.copy().resize((d*2+13,d*2+13))
		self.canvasImageth.thumbnail((d*2+13,d*2+13),Image.ANTIALIAS)
		
		self.wxcanvasImage = wx.EmptyImage( \
			self.canvasImageth.size[0], self.canvasImageth.size[1])
		self.wxcanvasImage.SetData(self.canvasImageth.convert('RGB').tostring())
		self.wxgcanvasImage.SetBitmap(self.wxcanvasImage.ConvertToBitmap())
		self.SetLabel()
	def SetLabel(self):
		if isinstance(self.obj.datainput[0],Image.Image):
			self.LabelFrom.SetLabel("Fr: Image %dx%d" % \
				(self.obj.datainput[0].size[0], \
				 self.obj.datainput[0].size[1]))
		elif isinstance(self.obj.datainput[0],grid):
			self.LabelFrom.SetLabel("Fr: Grid  %dx%d" % \
				(self.obj.datainput[0].w, \
				 self.obj.datainput[0].h))
		else:
			self.LabelFrom.SetLabel("Fr: ")
			
		if isinstance(self.obj.datainput[1],Image.Image):
			self.LabelTo.SetLabel("To: Image %dx%d" % \
				(self.obj.datainput[1].size[0], \
				 self.obj.datainput[1].size[1]))
		elif isinstance(self.obj.datainput[1],grid):
			self.LabelTo.SetLabel("To: Grid  %dx%d" % \
				(self.obj.datainput[1].w, \
				 self.obj.datainput[1].h))
		else:
			self.LabelTo.SetLabel("To: ")
			
		if isinstance(self.obj.dataoutput,Image.Image):
			self.LabelCanvas.SetLabel("Canvas: Image %dx%d" % \
				(self.canvasImage.size[0],self.canvasImage.size[1]))
		elif isinstance(self.obj.dataoutput,grid):
			self.LabelCanvas.SetLabel("Canvas: Grid  %dx%d" % \
				(self.obj.dataoutput.w,self.obj.dataoutput.h))
		else:
			self.LabelCanvas.SetLabel("Canvas: ")
	def ImageRefresh(self):
		d = 96
		### make thumbnail and wxinput
		self.makeFromToImage()
		#   fromImage 
		self.wxfromImage = wx.EmptyImage( \
			self.fromImage.size[0], self.fromImage.size[1])
		self.wxfromImage.SetData(self.fromImage.convert('RGB').tostring())
		
		#   toImage
		self.wxtoImage = wx.EmptyImage( \
			self.toImage.size[0], self.toImage.size[1])
		self.wxtoImage.SetData(self.toImage.convert('RGB').tostring())
		
		self.wxgfromImage.SetBitmap(self.wxfromImage.ConvertToBitmap())
		self.wxgtoImage.SetBitmap(self.wxtoImage.ConvertToBitmap())
		
		#   Label
		self.SetLabel()
	def OnCheckFixed(self,e):
		self.p.FixedCanvas = self.CheckFixedCanvas.IsChecked()
	def OnCheckMaskColor(self,e):
		if self.CheckMaskColor.IsChecked() == True:
			self.ButtonColorMask.Enable(True)
		else:
			self.ButtonColorMask.Enable(False)
			self.ButtonColorMask.SetColor(None)
	def OnCheckCopyColor(self,e):
		if self.CheckCopyColor.IsChecked() == True:
			self.ButtonColorCopy.Enable(True)
			self.CheckFixedCanvas.SetValue(True)
			self.CheckFixedCanvas.Enable(False)
		else:
			self.ButtonColorCopy.Enable(False)
			self.CheckFixedCanvas.Enable(True)
			self.ButtonColorCopy.SetColor(None)	
		self.OnCheckFixed(None)
	def OnCloseMe(self,e):
		# dismiss
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		self.panel.frame.Close(True)
		