### /filter/desaturate.py

import wx
from gui.imageimport import *

from obj.objImage   import objImage
from obj.objFilter  import objFilter
from obj.objGrid    import grid
from gui.colorPanel import *
from gui.validator  import *

from getInput import *
from setOutput import *

### properties
### ["desaturate",ColorDis1,ColorChange,ColorDis2,CheckDis2]

def desaturate(obj):
	if len(obj.datainput) < 1:
		obj.dataoutput = None
		return 
	p = get_properties_desaturate(obj)
	if isinstance(obj.datainput[0], Image.Image):
		w = obj.datainput[0].size[0]
		h = obj.datainput[0].size[1]
		
		oldImage = obj.datainput[0].copy()
		newImage = Image.new('L', (w, h), 0)
		oldData = oldImage.getdata()
		
		if   p.CheckDis2 == False:
			for i in range(len(oldData)):
				d = rdis(oldData[i], p.ColorDis1, p.ColorChange / 100.0)
				if d == -1:
					d = 0
				else:
					d = int(256 * d)
				newImage.putpixel((i % w, int(i / w)), d)
		else:
			for i in range(len(oldData)):
				d = rdis2(p.ColorDis1, p.ColorDis2, oldData[i])
				if d == -1:
					d = 0
				else:
					d = int(256 * d)
				newImage.putpixel((i % w, int(i / w)), d)
		
		oldData = None
		
		obj.dataoutput = newImage.convert('RGB')
	else:
		obj.dataoutput = None
		
class get_properties_desaturate:
	def __init__(self,obj):
		if len(obj.properties) == 5:
			self.ColorDis1   = obj.properties[1]
			self.ColorChange = obj.properties[2]
			self.ColorDis2   = obj.properties[3]
			self.CheckDis2   = obj.properties[4]
		else:
			self.ColorDis1   = (0,0,0)
			self.ColorChange = 0
			self.ColorDis2   = (255,255,255)
			self.CheckDis2   = False
			
class desaturateUI:
	def __init__(self, panel, obj):
		self.obj = obj
		self.p = get_properties_desaturate(self.obj)
		self.panel = panel
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		elif not isinstance(obj.datainput[0],Image.Image):
			self.panel.frame.Close(True)
		else:
			self.gui()
	def gui(self):
		d = 160
		# make pil_input_thumbnail picture and wxinput
		self.datainputh = self.obj.datainput[0].copy()
		self.datainputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxinput = wx.EmptyImage(self.datainputh.size[0], self.datainputh.size[1])
		self.wxinput.SetData(self.datainputh.convert('RGB').tostring())
		
		# make dataoutput's copy
		if self.obj.dataoutput == None:
			self.obj.dataoutput = self.obj.datainput[0].copy()
		
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# make gui
		self.panel.frame.SetSize((386,300))
		
		TopSize = wx.BoxSizer()
		self.wxginput = wx.StaticBitmap(self.panel, -1, self.wxinput.ConvertToBitmap(),	\
					   (self.wxinput.GetWidth(), self.wxinput.GetHeight()))
		self.wxgoutput = wx.StaticBitmap(self.panel, -1, self.wxoutput.ConvertToBitmap(), \
					   (self.wxoutput.GetWidth(), self.wxoutput.GetHeight()))
		TopSize.Add(self.wxginput,0,wx.FIXED_MINSIZE | wx.BOTTOM, 10)
		TopSize.Add(wx.DefaultSize,1,wx.EXPAND)
		TopSize.Add(self.wxgoutput,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MiddleSize1 = wx.BoxSizer()
		self.ButtonColorDis1  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorDis1, \
			id = self.ButtonColorDis1.GetId())
		self.LabelPM = wx.StaticText(self.panel, -1," +- ")
		self.TextPer = wx.TextCtrl(self.panel, -1, "1", \
			size = wx.DefaultSize, validator = MyValidator())
		self.panel.Bind(wx.EVT_TEXT, self.OnTextPer, self.TextPer)
		self.LabelPer = wx.StaticText(self.panel, -1," %")
		MiddleSize1.Add(self.ButtonColorDis1,0,wx.FIXED_MINSIZE, 10)
		MiddleSize1.Add(self.LabelPM,0,wx.FIXED_MINSIZE , 10)
		MiddleSize1.Add(self.TextPer,0,wx.FIXED_MINSIZE , 10)
		MiddleSize1.Add(self.LabelPer,0,wx.FIXED_MINSIZE , 10)
		
		MiddleSize2 = wx.BoxSizer()
		self.ButtonColorDis2  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorDis2, \
			id = self.ButtonColorDis2.GetId())
		self.CheckFixedCanvas = wx.CheckBox(self.panel,-1,"Enable Color2")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckFixed, self.CheckFixedCanvas)

		MiddleSize2.Add(self.ButtonColorDis2, 0, wx.EXPAND)
		MiddleSize2.Add(self.CheckFixedCanvas,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		ButtonRefresh = wx.Button(self.panel, -1, "Refresh")
		self.panel.Bind(wx.EVT_BUTTON, self.ImageRefresh, ButtonRefresh)
		
		BottomSize = wx.BoxSizer()
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(ButtonRefresh,0,wx.FIXED_MINSIZE , 10)
		BottomSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		BottomSize.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(MiddleSize1, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(MiddleSize2, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.ALL , 10)
		
		self.panel.SetSizer(MainSize)
		self.SetValueUI()
	def SetValueUI(self):
		self.ButtonColorDis1.SetColor(self.p.ColorDis1)
		self.ButtonColorDis2.SetColor(self.p.ColorDis2)
		self.CheckFixedCanvas.SetValue(self.p.CheckDis2)
		self.TextPer.SetValue(str(self.p.ColorChange))

		if self.p.CheckDis2 == True:
			self.TextPer.Enable(False)
			self.ButtonColorDis2.Enable(True)
		else:
			self.TextPer.Enable(True)
			self.ButtonColorDis2.Enable(False)
	def SetValueObj(self):
		self.obj.properties = \
			['desaturate', \
			 self.p.ColorDis1, \
			 self.p.ColorChange, \
			 self.p.ColorDis2, \
			 self.p.CheckDis2]
	def OnCheckFixed(self, e):
		self.p.CheckDis2 = self.CheckFixedCanvas.IsChecked()
		if self.p.CheckDis2 == True:
			self.TextPer.Enable(False)
			self.ButtonColorDis2.Enable(True)
		else:
			self.TextPer.Enable(True)
			self.ButtonColorDis2.Enable(False)
	def OnChangeColorDis1(self, e):
		self.p.ColorDis1 = e.GetColor()
	def OnChangeColorDis2(self, e):
		self.p.ColorDis2 = e.GetColor()
	def OnTextPer(self, e):
		if self.TextPer.GetValue()!="":
			i = int(self.TextPer.GetValue())
			if not (0 <= i <= 100):
				self.TextPer.SetValue('0')
				i = 0
			self.p.ColorChange = i
	def ImageRefresh(self ,e = None):
		d = 160
		# make dataoutput with PIL function "desaturate"
		self.SetValueObj()
		self.dataoutput = desaturate(self.obj)
		
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# refresh!
		self.wxgoutput.SetBitmap(self.wxoutput.ConvertToBitmap())
	def OnCloseMe(self,e):
		# make shape's bitmap
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		# dismiss
		self.panel.frame.Close(True)
