### /gui/dlgView.py

import os

import wx
from gui.imageimport import *

import BmpImagePlugin
import CurImagePlugin
import GifImagePlugin
import IcoImagePlugin
import JpegImagePlugin
import PdfImagePlugin
import PngImagePlugin
import PpmImagePlugin
import PsdImagePlugin
import TiffImagePlugin

import sets
from obj.objImage import objImage 
from obj.objFilter import objFilter
from filter.filter import filterPanel
from filter.setOutput import setOutput
import imageMake

class ImageView(wx.MiniFrame):
	def __init__(self,frame,obj):
		self.obj = obj
		
		title = ("w : %dpx, h : %dpx" % (self.obj.w,self.obj.h))
		wx.MiniFrame.__init__(self,frame, -1,title)
		
		self.SetSize((148,186))
		
		# set obj.flgdialog
		self.obj.flgdialog = 1
		
		# get input
		d = 128
		input = self.obj.image.copy()
		input.thumbnail((d,d),Image.ANTIALIAS)
		image = wx.EmptyImage(input.size[0], input.size[1])
		image.SetData(input.convert('RGB').tostring())
		
		# view image
		PreImage = wx.StaticBitmap \
			(self, -1, image.ConvertToBitmap(), \
			(image.GetWidth(), image.GetHeight()))
			
		# make button
		ButtonClose = wx.Button(self, -1, "Close")
		#ButtonClose.SetPosition((3,140))
		self.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		# Sizer
		Sizer = wx.BoxSizer(wx.VERTICAL)
		Sizer.Add(PreImage,0,wx.FIXED_MINSIZE | wx.TOP | wx.LEFT | wx.BOTTOM | wx.RIGHT,0)
		Sizer.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.BOTTOM | wx.LEFT | wx.RIGHT, 0)		
		self.SetSizer(Sizer)
	def OnCloseMe(self,e):
		# set obj.flgdialog
		self.obj.flgdialog = 0
		self.Close(True)

def ImageMakeView(frame,obj=None):
	imageMake.ImageMakeView(frame,obj)
	
class FilterView(wx.MiniFrame):
	def __init__(self,frame,obj):
		self.obj = obj
		self.frame = frame
		title = self.obj.properties[0]
		wx.MiniFrame.__init__(self,frame,-1,title, 
							  style=wx.DEFAULT_FRAME_STYLE | wx.TINY_CAPTION_HORIZ)
		panel = filterPanel(self,self.obj)
		self.Refresh()
		panel.Fit()
	def get_editcount(self):
		return self.frame.get_editcount()
		
class ScoreView(wx.Frame):
	def __init__(self,frame,obj):
		self.obj = obj
		self.frame = frame
		title = self.obj.properties[0]
		wx.Frame.__init__(self,frame,-1,title, 
							  style=wx.DEFAULT_FRAME_STYLE | wx.TINY_CAPTION_HORIZ)
		panel = filterPanel(self,self.obj)
		self.Refresh()
		panel.Fit()
	def get_editcount(self):
		return self.frame.get_editcount()
	
def Open(self,wildcard = "All files (*.*)|*.*"):
	dlg = wx.FileDialog(
		self,message="Choose a file",defaultDir = os.getcwd(),
		defaultFile = "", wildcard = wildcard,
		style=wx.OPEN | wx.CHANGE_DIR)
	if dlg.ShowModal() == wx.ID_OK:
		path = dlg.GetPaths()
		dlg.Destroy()
		return path
	else:
		dlg.Destroy()
		return None