/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_IM_CONTEXT_IIIM_H__
#define __GTK_IM_CONTEXT_IIIM_H__


#include <gtk/gtkimcontext.h>
#include <gtk/gtk.h>
#include <iiimcf.h>

G_BEGIN_DECLS

extern GType gtk_type_im_context_iiim;

#define GTK_TYPE_IM_CONTEXT_IIIM              gtk_type_im_context_iiim
#define GTK_IM_CONTEXT_IIIM(obj)              (GTK_CHECK_CAST ((obj), GTK_TYPE_IM_CONTEXT_IIIM, GtkIMContextIIIM))
#define GTK_IM_CONTEXT_IIIM_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_IM_CONTEXT_IIIM, GtkIMContextIIIMClass))
#define GTK_IS_IM_CONTEXT_IIIM(obj)           (GTK_CHECK_TYPE ((obj), GTK_TYPE_IM_CONTEXT_IIIM))
#define GTK_IS_IM_CONTEXT_IIIM_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IM_CONTEXT_IIIM))
#define GTK_IM_CONTEXT_IIIM_GET_CLASS(obj)    (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_IM_CONTEXT_IIIM, GtkIMContextIIIMClass))

typedef struct _GtkIMContextIIIM       GtkIMContextIIIM;
typedef struct _GtkIMContextIIIMClass  GtkIMContextIIIMClass;

typedef struct _GtkIIIMInfo GtkIIIMInfo;

struct _GtkIMContextIIIM
{
	GtkIMContext object;

	GtkIIIMInfo *iiim_info;

	gchar *locale;
	gchar *le_name;

	GdkWindow *client_window;

	IIIMCF_context context;
	IIIMCF_lookup_choice lookup_choice;

	GtkWidget *candidate;
	GdkRectangle cursor;

	guint trigger_notified :1;
	guint candidate_start :1;
	guint use_preedit : 1;
	guint status_visible :1;
};

struct _GtkIMContextIIIMClass
{
	GtkIMContextClass parent_class;
};

void im_context_iiim_register_type (GTypeModule *type_module);
GtkIMContext *im_context_iiim_new (void);

void im_context_iiim_shutdown (void);

G_END_DECLS

#endif


