/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 * Copyright (C) 2003 Motonobu Ichimura
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: imiiim.c,v 1.1.1.1 2003/04/21 08:58:40 famao Exp $ */

#include "gtk/gtkimmodule.h"
#include "gtkimcontextiiim.h"
#include <string.h>

static const GtkIMContextInfo iiim_info = { 
  "iiim",		           /* ID */
  "Internet/Intranet Input Method",            /* Human readable name */
  "gtk+",			   /* Translation domain */
   "",				   /* Dir for bindtextdomain (not strictly needed for "gtk+") */
  ""			           /* Languages for which this module is the default */
};

static const GtkIMContextInfo *info_list[] = {
  &iiim_info
};

void
im_module_init (GTypeModule *type_module)
{
  im_context_iiim_register_type (type_module);
}

void 
im_module_exit (void)
{
  im_context_iiim_shutdown ();
}

void 
im_module_list (const GtkIMContextInfo ***contexts,
		int                      *n_contexts)
{
  *contexts = info_list;
  *n_contexts = G_N_ELEMENTS (info_list);
}

GtkIMContext *
im_module_create (const gchar *context_id)
{
  if (strcmp (context_id, "iiim") == 0)
    return im_context_iiim_new ();
  else
    return NULL;
}
