#!/usr/bin/env/ python
# -*- coding: utf-8 -*-

import re
import subprocess
import sys
import xmlrpclib

class CommitHook(object):

    # サポートされているコマンド：
    # コマンドを追加する際は、この変数に追加して同名のメソッドを定義すること
    _supported_cmds = {'close':      '_cmdClose',
                       'closed':     '_cmdClose',
                       'closes':     '_cmdClose',
                       'fix':        '_cmdClose',
                       'fixed':      '_cmdClose',
                       'fixes':      '_cmdClose',
                       'addresses':  '_cmdRefs',
                       're':         '_cmdRefs',
                       'references': '_cmdRefs',
                       'refs':       '_cmdRefs',
                       'see':        '_cmdRefs',
                       'done':       '_cmdDone',}

    _status_id     = {'none':   1,
                      'doing':  2,
                      'done':   3,
                      'closed': 4}

    _resolution_id = {'fixed':      0,
                      'wontfix':    1,
                      'invalid':    2,
                      'duplicate':  3,
                      'worksforme': 4}

    # コミットログ置換('?\048' -> '0')
    def _repl(self, m):
        return chr(int(m.group(0)[2:])) # remove '?\'

    # Backlog API実行
    def execCmd(self, repos, rev, log, spaceId, user, password):

        # ログ変換
        if sys.platform.find('win') >= 0:
            log = unicode(log, 'mbcs')
        log = re.sub(r'\?\\\d\d\d', CommitHook()._repl, log)

        # XML-RPCエンドポイントインスタンス生成
        server = xmlrpclib.ServerProxy('https://%s:%s@%s.backlog.jp/XML-RPC' %
                                       (user, password, spaceId))

        # 所属しているプロジェクト全てに対して、課題の検索
        for project in server.backlog.getProjects():

            # 課題検索用正規表現パターン
            issue_prefix = '(?:\[{0,2})'
            issue_suffix = '(?:]{0,2})'
            issue_reference = issue_prefix + '%s-\d+' % project['key'] + issue_suffix
            issue_command = (r'(?P<action>[A-Za-z]*).?'
                             '(?P<issue>%s(?:(?:[, &]*|[ ]?and[ ]?)%s)*)' %
                             (issue_reference, issue_reference))
            command_re = re.compile(issue_command)
            issue_re = re.compile(issue_prefix + '(%s-\d+)' % project['key'] + issue_suffix)

            # 各課題に対するコマンド設定
            issues = {}
            for cmd, isus in command_re.findall(log):
                funcname = CommitHook._supported_cmds.get(cmd.lower(), '')
                if funcname:
                    for issue in issue_re.findall(isus):
                        func = getattr(self, funcname)
                        issues.setdefault(issue, set([])).add(func)

            # 設定されたコマンドに応じたBacklog API起動
            for issue, cmds in issues.iteritems():
                try:
                    for cmd in cmds:
                        cmd(server, issue, '(ln #rev(%s)) %s' % (rev, log))
                except Exception, e:
                    print>>sys.stderr, 'Unexpected error while processing issue ' \
                                       'ID %s: %s' % (issue, e)

    # 課題完了用Backlog API
    def _cmdClose(self, server, issue, comment):
        server.backlog.switchStatus({'key'         : issue,
                                     'statusId'    : CommitHook._status_id['closed'],
                                     'resolutionId': CommitHook._resolution_id['fixed'],
                                     'comment'     : comment})

    # 課題参照用Backlog API
    def _cmdRefs(self,  server, issue, comment):
        server.backlog.updateIssue({'key'    : issue,
                                    'comment': comment})

    # 課題対応用Backlog API
    def _cmdDone(self, server, issue, comment):
        server.backlog.switchStatus({'key'     : issue,
                                     'statusId': CommitHook._status_id['done'],
                                     'comment' : comment})

if __name__ == '__main__':
    (repos, rev, log, spaceId, user, password) = sys.argv[1:]
    CommitHook().execCmd(repos, rev, log, spaceId, user, password)
