/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imageviewer;

import java.awt.Dimension;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ThumbnailButton
extends JButton {
    static String[] READER_FORMAT_NAMES = ImageIO.getReaderFormatNames();
    static final String FOLDER = "/Users/nog/Pictures/FolderIcon.png";
    static final String NO_SUPPORT = "/Users/nog/Pictures/NoSupport.png";
    static ImageIcon FOLDER_ICON = null;
    static ImageIcon NO_SUPPORT_ICON = null;
    static Dimension dimension = new Dimension();
    File file;

    public ThumbnailButton(File file, int size) {
        super(ThumbnailButton.getIcon(file, size));
        this.file = file;
        this.setToolTipText(file.toString());
    }

    static ImageIcon getIcon(File file, int size) {
        ImageIcon icon = null;
        if (file.isDirectory()) {
            icon = FOLDER_ICON == null ? ThumbnailButton.getIcon(new File(FOLDER), size) : FOLDER_ICON;
        } else {
            String filename = file.getName().toLowerCase();
            int i = 0;
            while (i < READER_FORMAT_NAMES.length) {
                String format = READER_FORMAT_NAMES[i];
                if (filename.endsWith(format)) {
                    icon = ThumbnailButton.getIcon(file, format, size);
                }
                ++i;
            }
            if (icon == null) {
                icon = NO_SUPPORT_ICON == null ? ThumbnailButton.getIcon(new File(NO_SUPPORT), size) : NO_SUPPORT_ICON;
            }
        }
        return icon;
    }

    static ImageIcon getIcon(File file, String format, int size) {
        ImageIcon icon = null;
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(format);
            ImageReader reader = readers.next();
            reader.setInput(ImageIO.createImageInputStream(file), true);
            ImageReadParam param = reader.getDefaultReadParam();
            int tall = 0;
            int width = reader.getWidth(0);
            int height = reader.getHeight(0);
            tall = width > height ? width : height;
            int power = tall / size;
            if (power < 1) {
                power = 1;
            }
            if (!param.canSetSourceRenderSize()) {
                param.setSourceRenderSize(new Dimension(64, 64));
            } else {
                System.out.println("Cant change image size: " + file.getName());
            }
            icon = new ImageIcon(reader.read(0, param));
            if (icon.getIconWidth() > size || icon.getIconHeight() > size) {
                System.out.println(String.valueOf(file.getName()) + " " + icon.getIconWidth() + " " + icon.getIconHeight());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (NO_SUPPORT_ICON == null) {
                NO_SUPPORT_ICON = ThumbnailButton.getIcon(new File(NO_SUPPORT), size);
            }
            icon = NO_SUPPORT_ICON;
        }
        return icon;
    }

    public File getFile() {
        return this.file;
    }
}

