/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.sourceforge.imageviewer.ThumbnailImage;

public class ThumbnailWindow
extends JFrame {
    private static String TITLE = "Image Viewer";
    private static ImageIcon checker = new ImageIcon();
    private File file = null;
    private Vector vector = new Vector();
    private JFrame fullview = null;
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel panel = new JPanel();
    private JPanel buttonPanel = new JPanel(new BorderLayout());
    private JFileChooser chooser = new JFileChooser();
    private JList bookmarkList = null;
    private LinkedList list = new LinkedList();
    private int ICON_SIZE = 96;
    private int FRAME_WSIZE = 800;
    private int WCOUNT = 0;
    private ImageIcon FOLDER_ICON = ThumbnailImage.getFolderIcon(this.ICON_SIZE);
    private ImageIcon NO_SUPPORT_ICON = ThumbnailImage.getNoSupportIcon(this.ICON_SIZE);
    private GridBagLayout GRIDBAG = new GridBagLayout();
    private GridBagConstraints CONSTRAINTS = new GridBagConstraints();

    public ThumbnailWindow() {
        this.init();
    }

    public ThumbnailWindow(String[] args) {
        switch (args.length) {
            case 0: {
                this.init();
                break;
            }
            case 1: {
                this.file = new File(args[0]);
                if (this.file.isDirectory()) {
                    this.init();
                    this.add(this.file);
                    break;
                }
                if (this.file.isFile()) {
                    this.view(this.file);
                    break;
                }
                this.init();
                break;
            }
            default: {
                this.init();
                this.file = new File(args[0]);
                this.addFile(this.file);
                int i = 1;
                while (i < args.length) {
                    this.addFile(new File(args[i]));
                    ++i;
                }
                this.show();
            }
        }
    }

    public void init() {
        this.setTitle(TITLE);
        this.chooser.setFileSelectionMode(1);
        this.panel.setLayout(this.GRIDBAG);
        this.scrollPane.getViewport().add(this.panel);
        JButton openButton = new JButton("Open");
        openButton.addActionListener(new OpenAction());
        JButton bookmarkButton = new JButton("+");
        bookmarkButton.addActionListener(new BookmarkAction());
        this.buttonPanel.add((Component)bookmarkButton, "West");
        this.buttonPanel.add((Component)openButton, "East");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(3);
        this.setSize(this.FRAME_WSIZE, 600);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getSize();
        this.setLocation((screenSize.width - this.FRAME_WSIZE) / 2, (screenSize.height - 600) / 2);
        this.show();
    }

    public void add(File file) {
        this.reset();
        Dimension dimension = this.scrollPane.getSize();
        this.FRAME_WSIZE = (int)dimension.getWidth();
        if (file.isDirectory()) {
            File[] files;
            this.file = file;
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                this.addFile(parentFile);
            }
            if ((files = file.listFiles()) != null) {
                int i = 0;
                while (i < files.length) {
                    this.addFile(files[i]);
                    this.show();
                    ++i;
                }
            }
        }
        this.setTitle(String.valueOf(TITLE) + " - " + file);
        this.show();
        this.WCOUNT = 0;
    }

    void addFile(File file) {
        this.CONSTRAINTS.fill = 1;
        int temp = this.CONSTRAINTS.gridwidth;
        if (this.WCOUNT > this.FRAME_WSIZE / this.ICON_SIZE - 4) {
            this.WCOUNT = 0;
            this.CONSTRAINTS.gridwidth = 0;
        } else {
            ++this.WCOUNT;
        }
        JComponent label = this.getLabel(file);
        this.GRIDBAG.setConstraints(label, this.CONSTRAINTS);
        this.CONSTRAINTS.gridwidth = temp;
        this.panel.add(label);
    }

    JComponent getLabel(File file) {
        ThumbnailImage label = new ThumbnailImage(file, this.ICON_SIZE);
        label.setBorder(BorderFactory.createTitledBorder(file.getName()));
        label.addActionListener(new PreviewAction(label));
        try {
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return label;
    }

    void open() {
        this.chooser.showOpenDialog(null);
        File file = this.chooser.getSelectedFile();
        if (file != null) {
            this.add(file);
        }
    }

    void reset() {
        Component[] components = this.panel.getComponents();
        int i = 0;
        while (i < components.length) {
            JButton button = (JButton)components[i];
            ActionListener[] actionListeners = button.getActionListeners();
            int j = 0;
            while (j < actionListeners.length) {
                button.removeActionListener(actionListeners[j]);
                ++j;
            }
            ++i;
        }
        this.panel.removeAll();
        this.scrollPane.getViewport().add(this.panel);
    }

    void bookmark() {
        if (this.file != null) {
            if (this.bookmarkList == null) {
                this.bookmarkList = new JList();
                JScrollPane listPanel = new JScrollPane();
                listPanel.getViewport().add(this.bookmarkList);
                this.getContentPane().add((Component)listPanel, "West");
            }
            this.vector.add(this.file.getName());
            this.bookmarkList.setListData(this.vector);
            this.validate();
        }
    }

    void view(File file) {
        ImageIcon icon = this.getPreviewImageIcon(file);
        if (icon != null) {
            this.viewFullImage(icon);
        }
    }

    void viewFullImage(ImageIcon icon) {
        if (this.fullview == null) {
            this.fullview = new JFrame();
        }
        this.fullview.getContentPane().removeAll();
        this.fullview.getContentPane().add(new JLabel(icon));
        this.fullview.pack();
        this.fullview.setTitle(this.file.getAbsolutePath());
        this.fullview.show();
    }

    private ImageIcon getPreviewImageIcon(File file) {
        Image image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        checker.setImage(image);
        int imageHeight = checker.getIconHeight();
        int imageWidth = checker.getIconWidth();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = (int)(dimension.getHeight() * 0.95);
        int screenWidth = (int)(dimension.getWidth() * 0.95);
        ImageIcon icon = null;
        if (imageHeight <= screenHeight && imageWidth <= screenWidth) {
            icon = new ImageIcon(image);
        } else {
            int viewWidth = 0;
            int viewHeight = 0;
            if (screenHeight > imageHeight && screenWidth < imageHeight) {
                viewWidth = screenWidth;
                viewHeight = imageHeight * screenWidth / imageWidth;
            } else if (screenHeight < imageHeight && screenWidth > imageHeight) {
                viewWidth = imageWidth * screenHeight / imageHeight;
                viewHeight = screenHeight;
            } else if (screenHeight / imageHeight < screenWidth / imageHeight) {
                viewWidth = screenWidth;
                viewHeight = imageHeight * screenWidth / imageWidth;
            } else {
                viewWidth = imageWidth * screenHeight / imageHeight;
                viewHeight = screenHeight;
            }
            icon = new ImageIcon(image.getScaledInstance(viewWidth, viewHeight, 1));
            image.flush();
        }
        return icon;
    }

    private class OpenAction
    implements ActionListener {
        OpenAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ThumbnailWindow.this.open();
        }
    }

    private class BookmarkAction
    implements ActionListener {
        BookmarkAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ThumbnailWindow.this.bookmark();
        }
    }

    private class PreviewAction
    implements ActionListener {
        ThumbnailImage button;

        PreviewAction(ThumbnailImage button) {
            this.button = button;
        }

        public void actionPerformed(ActionEvent e) {
            File file = this.button.getFile();
            if (file.isDirectory()) {
                ThumbnailWindow.this.reset();
                ThumbnailWindow.this.add(file);
            } else {
                ThumbnailWindow.this.view(file);
            }
        }
    }
}

